/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.daemon;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInsight.intention.EmptyIntentionAction;
import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.lang.annotation.Annotation;
import com.intellij.lang.annotation.AnnotationHolder;
import com.intellij.lang.annotation.AnnotationSession;
import com.intellij.lang.annotation.Annotator;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.lang.annotation.ProblemGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.colors.TextAttributesKey;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.MultiRangeReference;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.daemon.OCAnnotatorHelper;
import com.jetbrains.cidr.lang.daemon.OCArgumentsChecker;
import com.jetbrains.cidr.lang.daemon.OCCppChecker;
import com.jetbrains.cidr.lang.daemon.OCDeclaratorChecker;
import com.jetbrains.cidr.lang.daemon.OCErrorAnnotator;
import com.jetbrains.cidr.lang.daemon.OCImplementationChecker;
import com.jetbrains.cidr.lang.daemon.OCOperatorsChecker;
import com.jetbrains.cidr.lang.daemon.OCPragmaSuppressionUtils;
import com.jetbrains.cidr.lang.daemon.OCProblemGroup;
import com.jetbrains.cidr.lang.daemon.OCResolveAnnotator;
import com.jetbrains.cidr.lang.daemon.OCSuppressionGroup;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageDescriptor;
import com.jetbrains.cidr.lang.daemon.clang.OCClangMessageFinder;
import com.jetbrains.cidr.lang.inspections.OCInspection;
import com.jetbrains.cidr.lang.inspections.OCInspections;
import com.jetbrains.cidr.lang.parser.OCMacroRange;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.preprocessor.OCImmutableInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContext;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCCompoundInitializer;
import com.jetbrains.cidr.lang.psi.OCDirective;
import com.jetbrains.cidr.lang.psi.OCElement;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCFunctionDeclaration;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCMacroCallArgument;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCReturnStatement;
import com.jetbrains.cidr.lang.psi.visitors.OCVisitor;
import com.jetbrains.cidr.lang.quickfixes.OCChangeTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCConvertLiteralIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCConvertTypeIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCInsertCastIntentionAction;
import com.jetbrains.cidr.lang.quickfixes.OCQuickFix;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCFunctionSymbol;
import com.jetbrains.cidr.lang.types.OCIdType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCCodeInsightUtil;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import com.jetbrains.cidr.lang.util.OCElementsRange;
import com.jetbrains.cidr.lang.workspace.OCResolveConfiguration;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCAnnotator
extends OCVisitor
implements Annotator {
    public static final Key<Boolean> RESOLVE_INFO_IN_MESSAGE = Key.create((String)"RESOLVE_INFO_IN_MESSAGE");
    private static final String ERROR_AFTER_MACRO_SUBSTITUTION = "Error after macro substitution: ";
    public static final String CIDR_DIAG = "CIDR";
    @Nullable
    protected AnnotationHolder myHolder;
    protected PsiElement myAnnotatingElement;
    protected OCOperatorsChecker myOperatorsChecker;
    protected OCCppChecker myCppChecker;
    protected OCDeclaratorChecker myDeclaratorChecker;
    protected OCImplementationChecker myImplementationChecker;

    @NotNull
    public static OCAnnotator[] getAnnotators() {
        return new OCAnnotator[]{new OCErrorAnnotator(), new OCResolveAnnotator()};
    }

    @NotNull
    public static OCAnnotatorHelper[] getAnnotatorHelpers() {
        return (OCAnnotatorHelper[])Extensions.getExtensions(OCAnnotatorHelper.EP_NAME);
    }

    @Nullable
    public AnnotationHolder getHolder() {
        return this.myHolder;
    }

    public PsiElement getAnnotatingElement() {
        return this.myAnnotatingElement;
    }

    protected void copyCheckers(OCAnnotator annotator) {
        this.myDeclaratorChecker = annotator.myDeclaratorChecker;
        this.myOperatorsChecker = annotator.myOperatorsChecker;
        this.myCppChecker = annotator.myCppChecker;
        this.myImplementationChecker = annotator.myImplementationChecker;
    }

    public void setHolder(@Nullable AnnotationHolder holder, @Nullable PsiElement annotatingElement) {
        this.myHolder = holder;
        this.myAnnotatingElement = annotatingElement;
    }

    public void annotate(@NotNull PsiElement psiElement, @NotNull AnnotationHolder holder) {
        this.annotate(psiElement, holder, holder.getCurrentAnnotationSession());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(@NotNull PsiElement psiElement, @Nullable AnnotationHolder holder, @Nullable AnnotationSession session) {
        PsiFile file2;
        this.setHolder(holder, psiElement);
        OCFile ocFile = null;
        if (session != null && (file2 = session.getFile()) instanceof OCFile) {
            ocFile = (OCFile)file2;
            if (!ocFile.isInProjectSourcesOrLibraries()) {
                return;
            }
            ocFile.pushAnnotationSession(session);
        }
        try {
            psiElement.accept((PsiElementVisitor)this);
        }
        finally {
            this.setHolder(null, null);
            if (ocFile != null) {
                ocFile.popAnnotationSession();
            }
        }
    }

    @Nullable
    public Annotation addErrorAnnotation(@Nullable PsiElement element, @Nullable String clangID, @NotNull String message) {
        return this.addErrorAnnotation(element, null, clangID, message, null);
    }

    @Nullable
    public Annotation addErrorAnnotation(@Nullable PsiElement element, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message) {
        return this.addErrorAnnotation(element, inspectionClass, clangID, message, null);
    }

    @Nullable
    public Annotation addErrorAnnotation(@Nullable PsiElement element, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        if (element == null) {
            return null;
        }
        OCElementsRange elementsRange = element instanceof OCFunctionDeclaration ? ((OCFunctionDeclaration)element).getHeaderRange() : new OCElementsRange(element, element).trim(OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
        if (elementsRange != null) {
            TextRange range = elementsRange.getTextRange();
            return this.addErrorAnnotation(element, range, inspectionClass, clangID, message, highlightType);
        }
        return null;
    }

    @Nullable
    public Annotation addErrorAnnotation(@Nullable PsiElement element, @Nullable TextRange range, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        OCMacroRange macroRange = OCElementUtil.getRangeInMacroCall(element);
        OCElement context = (OCElement)PsiTreeUtil.getParentOfType((PsiElement)element, (Class[])new Class[]{OCMacroCallArgument.class, OCDirective.class});
        if (context != null) {
            if (context instanceof OCDirective) {
                PsiElement headerToken = ((OCDirective)context).getHeaderToken();
                IElementType type = headerToken.getNode().getElementType();
                if (type != OCTokenTypes.ERROR_DIRECTIVE && type != OCTokenTypes.WARNING_DIRECTIVE) {
                    return null;
                }
            } else {
                return null;
            }
        }
        if (macroRange == null) {
            return this.addErrorAnnotation(range, inspectionClass, clangID, message, highlightType);
        }
        if (!macroRange.mapsToArguments()) {
            if (element instanceof OCParenthesizedExpression) {
                return this.addErrorAnnotation(((OCParenthesizedExpression)element).getOperand(), range, inspectionClass, clangID, message, highlightType);
            }
            OCMacroCall macroCall = macroRange.getMacroCall();
            if (!message.startsWith(ERROR_AFTER_MACRO_SUBSTITUTION)) {
                message = ERROR_AFTER_MACRO_SUBSTITUTION + message;
            }
            return this.addErrorAnnotation(macroCall, macroCall.getTextRange(), inspectionClass, clangID, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
        return this.addErrorAnnotation(macroRange.getArgumentRange(), inspectionClass, clangID, message, highlightType);
    }

    @Nullable
    public Annotation addErrorAnnotation(@Nullable TextRange range, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        if (this.myHolder == null || range == null || range.isEmpty()) {
            return null;
        }
        OCFile file2 = (OCFile)this.myAnnotatingElement.getContainingFile();
        OCProblemGroup problemGroup = OCAnnotator.getProblemGroup(file2, range, inspectionClass, clangID);
        String suppressOption = problemGroup != null ? problemGroup.getSuppressOption() : null;
        OCPragmaSuppressionUtils.Mode mode = OCPragmaSuppressionUtils.getDiagnosticMode(file2, range.getStartOffset(), suppressOption);
        if (mode != null) {
            switch (mode) {
                case IGNORE: {
                    return null;
                }
                case WARNING: {
                    highlightType = ProblemHighlightType.WEAK_WARNING;
                    break;
                }
            }
        }
        message = OCAnnotator.addConfigRef(message, file2);
        Annotation annotation = this.myHolder.createErrorAnnotation(range, message);
        this.setupAnnotation(annotation, highlightType, inspectionClass, problemGroup);
        return annotation;
    }

    @NotNull
    public static String addConfigRef(@NotNull String message, @NotNull OCFile file2) {
        Boolean needConfig = (Boolean)RESOLVE_INFO_IN_MESSAGE.get((UserDataHolder)file2.getProject());
        if (needConfig == Boolean.TRUE) {
            VirtualFile problemFile = file2.getVirtualFile();
            OCResolveRootAndConfiguration rootAndConfig = OCInclusionContextUtil.getResolveRootAndActiveConfiguration(problemFile, file2.getProject());
            VirtualFile rootFile = rootAndConfig.getRootFile();
            OCResolveConfiguration resolveConfiguration = rootAndConfig.getConfiguration();
            if (rootFile != null && resolveConfiguration != null) {
                message = message + ";";
                OCImmutableInclusionContext context = OCInclusionContext.tryFindInCachedPCHPrecompiledContexts(resolveConfiguration, problemFile, rootFile);
                if (context != null) {
                    message = message + " Language:" + context.getLanguageKind();
                    message = message + "; ARCMode:" + context.isClangFeatureOrExtensionEnabled("objc_arc");
                    message = message + ";";
                }
                message = message + " resolved for '" + resolveConfiguration.getDisplayName(true) + "', root '" + rootFile.getName() + "'";
            }
        }
        return message;
    }

    @Nullable
    public Annotation addWarningAnnotation(@Nullable PsiElement element, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message) {
        return this.addWarningAnnotation(element, inspectionClass, clangID, message, null);
    }

    @Nullable
    public Annotation addWarningAnnotation(@Nullable PsiElement element, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        if (element == null) {
            return null;
        }
        OCElementsRange elementsRange = element instanceof OCFunctionDeclaration ? ((OCFunctionDeclaration)element).getHeaderRange() : new OCElementsRange(element, element).trim(OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET);
        if (elementsRange != null) {
            TextRange range = elementsRange.getTextRange();
            return this.addWarningAnnotation(element, range, inspectionClass, clangID, message, highlightType);
        }
        return null;
    }

    @Nullable
    public Annotation addWarningAnnotation(@Nullable PsiElement element, @Nullable TextRange range, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        if (element == null) {
            return null;
        }
        OCMacroRange macroRange = OCElementUtil.getRangeInMacroCall(element);
        if (macroRange == null) {
            return this.doAddWarningAnnotation(element, range, inspectionClass, clangID, message, highlightType);
        }
        if (!macroRange.mapsToArguments()) {
            if (element instanceof OCParenthesizedExpression) {
                return this.addWarningAnnotation(((OCParenthesizedExpression)element).getOperand(), range, inspectionClass, clangID, message, highlightType);
            }
            if (OCElementUtil.getRangeInMacroCall(this.myAnnotatingElement) == null) {
                return this.doAddWarningAnnotation(macroRange.getMacroCall(), macroRange.getMacroCall().getTextRange(), inspectionClass, clangID, message, highlightType);
            }
            return null;
        }
        return this.doAddWarningAnnotation(element, macroRange.getTextRange(), inspectionClass, clangID, message, highlightType);
    }

    @Nullable
    private Annotation doAddWarningAnnotation(@Nullable PsiElement element, @Nullable TextRange range, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        if (range == null || range.isEmpty()) {
            return null;
        }
        if (PsiTreeUtil.getParentOfType((PsiElement)element, OCMacroCallArgument.class) != null) {
            return null;
        }
        if (this.myHolder == null) {
            return null;
        }
        if ((highlightType = OCAnnotator.getInspectionHighlightType(element, inspectionClass, highlightType != null ? highlightType : ProblemHighlightType.GENERIC_ERROR_OR_WARNING)) == null) {
            return null;
        }
        OCFile file2 = (OCFile)this.myAnnotatingElement.getContainingFile();
        OCProblemGroup problemGroup = OCAnnotator.getProblemGroup(file2, range, inspectionClass, clangID);
        String suppressOption = problemGroup != null ? problemGroup.getSuppressOption() : null;
        OCPragmaSuppressionUtils.Mode mode = OCPragmaSuppressionUtils.getDiagnosticMode(file2, range.getStartOffset(), suppressOption);
        if (mode != null) {
            switch (mode) {
                case IGNORE: {
                    return null;
                }
                case ERROR: 
                case FATAL: {
                    highlightType = ProblemHighlightType.GENERIC_ERROR;
                    break;
                }
            }
        }
        Annotation annotation = highlightType == ProblemHighlightType.INFORMATION ? this.myHolder.createInfoAnnotation(range, message) : this.myHolder.createWarningAnnotation(range, message);
        this.setupAnnotation(annotation, highlightType, inspectionClass, problemGroup);
        return annotation;
    }

    @Nullable
    public static OCProblemGroup getProblemGroup(@Nullable OCFile file2, @NotNull TextRange range, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String problemID) {
        OCClangMessageDescriptor descriptor;
        if (inspectionClass == null || problemID == null) {
            return null;
        }
        OCSuppressionGroup suppressionGroup = problemID.startsWith(CIDR_DIAG) ? new OCSuppressionGroup("ide", problemID.equals(CIDR_DIAG) ? inspectionClass.getSimpleName() : problemID.substring(CIDR_DIAG.length())) : ((descriptor = OCClangMessageFinder.getInstance().getSupportedMessageDescriptor(problemID)) != null ? descriptor.getSuppressionGroup() : null);
        return new OCProblemGroup(inspectionClass.getSimpleName(), suppressionGroup, file2, range);
    }

    private void setupAnnotation(@Nullable Annotation annotation, @Nullable ProblemHighlightType highlightType, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable OCProblemGroup problemGroup) {
        if (annotation != null) {
            if (inspectionClass != null) {
                this.registerQuickFix(annotation, (IntentionAction)new EmptyIntentionAction(OCCodeInsightUtil.getPrettyNameFromClassName(inspectionClass)));
            }
            if (problemGroup != null) {
                annotation.setProblemGroup((ProblemGroup)problemGroup);
                if (this.myHolder instanceof AnnotationAndQuickFixHolder) {
                    for (SuppressIntentionAction action : problemGroup.getSuppressActions(null)) {
                        ((AnnotationAndQuickFixHolder)this.myHolder).createQuickFix(annotation, (IntentionAction)action);
                    }
                }
            }
            annotation.setHighlightType(highlightType != null ? highlightType : ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
        }
    }

    @Nullable
    public static ProblemHighlightType getInspectionHighlightType(@Nullable PsiElement element, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable ProblemHighlightType highlightType) {
        if (inspectionClass != null && element != null) {
            InspectionProjectProfileManager profileManager = InspectionProjectProfileManager.getInstance(element.getProject());
            InspectionProfile inspectionProfile = profileManager.getInspectionProfile();
            HighlightDisplayKey key = HighlightDisplayKey.find((String)inspectionClass.getSimpleName());
            if (key != null) {
                if (!inspectionProfile.isToolEnabled(key, element) && !ApplicationManager.getApplication().isUnitTestMode()) {
                    return null;
                }
                HighlightDisplayLevel level = inspectionProfile.getErrorLevel(key, element);
                if (!level.equals(HighlightDisplayLevel.WARNING)) {
                    if (level.getSeverity().equals((Object)HighlightSeverity.ERROR)) {
                        highlightType = ProblemHighlightType.ERROR;
                    } else if (level.getSeverity().equals((Object)HighlightSeverity.GENERIC_SERVER_ERROR_OR_WARNING)) {
                        highlightType = ProblemHighlightType.GENERIC_ERROR_OR_WARNING;
                    } else if (level.getSeverity().equals((Object)HighlightSeverity.INFORMATION)) {
                        highlightType = ProblemHighlightType.INFORMATION;
                    } else if (level.getSeverity().equals((Object)HighlightSeverity.WEAK_WARNING)) {
                        highlightType = ProblemHighlightType.WEAK_WARNING;
                    }
                }
            }
        }
        return highlightType;
    }

    public void registerQuickFix(@Nullable Annotation annotation, @NotNull IntentionAction intentionAction) {
        if (annotation != null) {
            if (intentionAction instanceof SuppressIntentionAction) {
                OCProblemGroup problemGroup = (OCProblemGroup)annotation.getProblemGroup();
                if (problemGroup != null) {
                    problemGroup.addSuppressAction((SuppressIntentionAction)intentionAction);
                }
            } else {
                Annotation.QuickFixInfo emptyFix;
                List quickFixes = annotation.getQuickFixes();
                Annotation.QuickFixInfo quickFixInfo = emptyFix = quickFixes != null ? (Annotation.QuickFixInfo)ContainerUtil.find((Iterable)quickFixes, (Condition)new Condition<Annotation.QuickFixInfo>(){

                    public boolean value(Annotation.QuickFixInfo info) {
                        return info.quickFix instanceof EmptyIntentionAction;
                    }
                }) : null;
                if (emptyFix != null) {
                    quickFixes.remove(emptyFix);
                }
                annotation.registerFix(intentionAction);
                if (intentionAction instanceof OCQuickFix && ((OCQuickFix)intentionAction).isSupportedInBatchMode()) {
                    annotation.registerBatchFix((IntentionAction)((OCQuickFix)intentionAction), null, null);
                }
            }
            if (this.myHolder instanceof AnnotationAndQuickFixHolder) {
                ((AnnotationAndQuickFixHolder)this.myHolder).createQuickFix(annotation, intentionAction);
            }
        }
    }

    public List<Annotation> addErrorAnnotations(@NotNull List<? extends PsiElement> elements, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (PsiElement psiElement : elements) {
            Annotation annotation = this.addErrorAnnotation(psiElement, inspectionClass, clangID, message);
            if (annotation == null) continue;
            annotations.add(annotation);
        }
        return annotations;
    }

    public List<Annotation> addWarningAnnotations(@NotNull List<? extends PsiElement> elements, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message) {
        return this.addWarningAnnotations(elements, inspectionClass, clangID, message, ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
    }

    public List<Annotation> addWarningAnnotations(@NotNull List<? extends PsiElement> elements, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, @Nullable ProblemHighlightType highlightType) {
        ArrayList<Annotation> annotations = new ArrayList<Annotation>();
        for (PsiElement psiElement : elements) {
            Annotation annotation = this.addWarningAnnotation(psiElement, inspectionClass, clangID, message, highlightType);
            if (annotation == null) continue;
            annotations.add(annotation);
        }
        return annotations;
    }

    @Nullable
    protected Annotation highlight(@Nullable PsiElement element, @Nullable TextAttributesKey key) {
        if (element != null && element.getTextLength() != 0 && this.myHolder != null && key != null) {
            Annotation ann = this.myHolder.createInfoAnnotation(element, null);
            ann.setTextAttributes(key);
            return ann;
        }
        return null;
    }

    protected void highlight(@NotNull PsiReference reference, @Nullable TextAttributesKey key) {
        PsiElement psiElement = reference.getElement();
        int offset = psiElement.getTextRange().getStartOffset();
        if (reference instanceof MultiRangeReference) {
            for (TextRange range : ((MultiRangeReference)reference).getRanges()) {
                this.highlight(range.shiftRight(offset), key);
            }
        } else {
            this.highlight(reference.getRangeInElement().shiftRight(offset), key);
        }
    }

    protected void highlight(@NotNull TextRange range, @Nullable TextAttributesKey key) {
        if (range.getLength() != 0 && this.myHolder != null && key != null) {
            Annotation ann = this.myHolder.createInfoAnnotation(range, null);
            ann.setTextAttributes(key);
        }
    }

    public void registerQuickFixes(@Nullable List<Annotation> annotations, @NotNull IntentionAction intentionAction) {
        if (annotations != null) {
            for (Annotation annotation : annotations) {
                this.registerQuickFix(annotation, intentionAction);
            }
        }
    }

    @Nullable
    public Annotation checkAssignment(@Nullable OCExpression rOperand, @Nullable OCSymbol rSymbol, @Nullable String rSubject, @NotNull PsiElement annotationElement, @NotNull OCType lType, @NotNull OCType rType, @Nullable OCSymbol lSymbol, @Nullable String lSubject, @Nullable OCType symbolRequiredType, boolean onlyWarnings, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String messagePrefix) {
        OCFunctionSymbol oCFunctionSymbol;
        boolean isBridgeCastNeeded;
        OCType.TypeCheckResult typeCheckResult = lType.checkCompatible(rType, rOperand, annotationElement);
        Annotation annotation = null;
        if (typeCheckResult.getAnnotationElement() != null) {
            annotationElement = typeCheckResult.getAnnotationElement();
        }
        if (inspectionClass == null) {
            inspectionClass = typeCheckResult.getInspectionClass();
            clangID = typeCheckResult.getClangID();
        }
        if (typeCheckResult.getState().isError(annotationElement)) {
            if (onlyWarnings) {
                annotation = this.addWarningAnnotation(annotationElement, inspectionClass, clangID, this.getMessage(messagePrefix, typeCheckResult));
                if (annotation != null) {
                    annotation.setHighlightType(ProblemHighlightType.GENERIC_ERROR_OR_WARNING);
                }
            } else {
                annotation = this.addErrorAnnotation(annotationElement, inspectionClass, clangID, this.getMessage(messagePrefix, typeCheckResult));
            }
        } else if (!typeCheckResult.getState().isOK()) {
            if (typeCheckResult.getState().isWarning(annotationElement)) {
                annotation = this.addWarningAnnotation(annotationElement, inspectionClass, clangID, this.getMessage(messagePrefix, typeCheckResult));
            } else if (typeCheckResult.getState() == OCType.TypeCheckState.INFO) {
                annotation = this.addWarningAnnotation(annotationElement, inspectionClass, clangID, this.getMessage(messagePrefix, typeCheckResult), ProblemHighlightType.WEAK_WARNING);
            }
        }
        boolean bl = isBridgeCastNeeded = typeCheckResult.getInspectionClass() == OCInspections.BridgeCastIssues.class;
        if (rOperand != null && !typeCheckResult.getState().isOK() && (typeCheckResult.canBeCasted(lType, rType, rOperand) || isBridgeCastNeeded)) {
            OCType oCType = lType.isPointerToObject() && rType.isPointerToObject() && !rType.isCompatible(lType, rOperand) && !lType.isPointerToID() ? OCIdType.pointerToID(rOperand.getProject()) : lType;
            this.registerQuickFix(annotation, new OCInsertCastIntentionAction(rOperand, oCType, isBridgeCastNeeded));
        }
        if (annotation != null) {
            if (rOperand != null) {
                this.registerQuickFix(annotation, new OCConvertTypeIntentionAction(rOperand, lType));
                this.registerQuickFix(annotation, new OCConvertLiteralIntentionAction(rOperand, lType, rType));
            }
            if (typeCheckResult.getQuickFixes() != null) {
                for (IntentionAction action : typeCheckResult.getQuickFixes()) {
                    this.registerQuickFix(annotation, action);
                }
            }
            if (lSymbol != null && symbolRequiredType != null) {
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(lSymbol, symbolRequiredType, annotationElement instanceof OCReturnStatement, lSubject));
            }
            if (rSymbol != null) {
                this.registerQuickFix(annotation, new OCChangeTypeIntentionAction(rSymbol, lType, rSubject));
            } else if (rOperand != null) {
                this.registerQuickFix(annotation, OCChangeTypeIntentionAction.getAction(rOperand, lType));
            }
        }
        if ((oCFunctionSymbol = typeCheckResult.getImplicitConstructor()) != null) {
            this.myOperatorsChecker.checkFieldVisibility(oCFunctionSymbol, annotationElement, null);
        }
        return annotation;
    }

    protected String getMessage(String messagePrefix, OCType.TypeCheckResult typeCheckResult) {
        return messagePrefix + (messagePrefix.endsWith(": ") || messagePrefix.isEmpty() ? typeCheckResult.getMessage() : "");
    }

    @Nullable
    public Annotation checkAssignment(@Nullable OCExpression rOperand, @NotNull PsiElement navigationElement, @NotNull OCType lType, @NotNull OCType rType, @Nullable OCSymbol lSymbol, @Nullable OCType symbolRequiredType, boolean onlyWarnings, @NotNull String messagePrefix) {
        return this.checkAssignment(rOperand, null, null, navigationElement, lType, rType, lSymbol, null, symbolRequiredType, onlyWarnings, null, null, messagePrefix);
    }

    @Nullable
    public Annotation checkAssignment(@Nullable OCExpression rOperand, @NotNull PsiElement navigationElement, @NotNull OCType lType, @NotNull OCType rType, @Nullable OCSymbol lSymbol, @NotNull String messagePrefix) {
        return this.checkAssignment(rOperand, null, null, navigationElement, lType, rType, lSymbol, null, rType, false, null, null, messagePrefix);
    }

    @Nullable
    public Annotation checkAssignment(@Nullable OCExpression rOperand, @NotNull PsiElement navigationElement, @NotNull OCType lType, @NotNull OCType rType, @Nullable OCSymbol lSymbol, @Nullable OCType symbolRequiredType) {
        return this.checkAssignment(rOperand, navigationElement, lType, rType, lSymbol, symbolRequiredType, false, "");
    }

    @Nullable
    public Annotation checkAssignment(@Nullable OCExpression rOperand, @NotNull PsiElement navigationElement, @NotNull OCType lType, @NotNull OCType rType, @NotNull String messagePrefix) {
        return this.checkAssignment(rOperand, navigationElement, lType, rType, null, null, false, messagePrefix);
    }

    protected class MyArgumentsChecker
    extends OCArgumentsChecker {
        protected MyArgumentsChecker() {
        }

        @Override
        protected void checkConstructor(OCCompoundInitializer compInitializer, OCSymbol constructor) {
        }

        @Override
        protected void checkAssignment(OCExpression rOperand, PsiElement element, OCType lType, OCType rType, OCSymbol lSymbol, OCType symbolRequiredType, boolean allowImplicitConversions, boolean onlyWarnings, String messagePrefix) {
            OCAnnotator.this.checkAssignment(rOperand, element, lType, rType, lSymbol, symbolRequiredType, onlyWarnings, messagePrefix);
        }

        @Override
        protected void checkAssignment(OCExpression rOperand, PsiElement element, OCType lType, OCType rType, String messagePrefix) {
            OCAnnotator.this.checkAssignment(rOperand, element, lType, rType, messagePrefix);
        }

        @Override
        @Nullable
        protected Annotation addWarningAnnotation(@Nullable PsiElement element, @Nullable Class<? extends OCInspection> aClass, @Nullable String inspectionID, @NotNull String message, @Nullable ProblemHighlightType highlightType, IntentionAction ... fixes) {
            Annotation annotation = OCAnnotator.this.addWarningAnnotation(element, aClass, inspectionID, message, highlightType);
            for (IntentionAction fix : fixes) {
                OCAnnotator.this.registerQuickFix(annotation, fix);
            }
            return annotation;
        }

        @Override
        @Nullable
        protected Annotation addErrorAnnotation(@Nullable PsiElement element, @Nullable Class<? extends OCInspection> inspectionClass, @Nullable String clangID, @NotNull String message, IntentionAction ... fixes) {
            Annotation annotation = OCAnnotator.this.addErrorAnnotation(element, inspectionClass, clangID, message);
            for (IntentionAction fix : fixes) {
                OCAnnotator.this.registerQuickFix(annotation, fix);
            }
            return annotation;
        }
    }

    public static interface AnnotationAndQuickFixHolder
    extends AnnotationHolder {
        public void createQuickFix(@NotNull Annotation var1, @NotNull IntentionAction var2);
    }
}

