/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.autoImport;

import com.intellij.codeInsight.intention.IntentionAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.util.Processor;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.autoImport.OCAutoImportHelper;
import com.jetbrains.cidr.lang.workspace.OCResolveRootAndConfiguration;
import com.jetbrains.cidr.lang.workspace.headerRoots.AppleFramework;
import com.jetbrains.cidr.lang.workspace.headerRoots.FrameworksSearchRoot;
import com.jetbrains.cidr.lang.workspace.headerRoots.IncludedHeadersRoot;
import java.util.Collections;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDefaultAutoImportHelper
implements OCAutoImportHelper {
    @Override
    public boolean supports(@NotNull OCResolveRootAndConfiguration rootAndConfiguration) {
        return true;
    }

    @Override
    public boolean processPathSpecificationToInclude(@NotNull Project project2, @Nullable VirtualFile targetFile, final @NotNull VirtualFile fileToImport, @NotNull OCResolveRootAndConfiguration rootAndConfiguration, @NotNull Processor<OCAutoImportHelper.ImportSpecification> processor2) {
        String relativePath;
        VirtualFile targetFileParent;
        String name = fileToImport.getName();
        String path = fileToImport.getPath();
        VirtualFile virtualFile = targetFileParent = targetFile != null ? targetFile.getParent() : null;
        if (targetFileParent != null && targetFileParent.equals(fileToImport.getParent()) && !processor2.process((Object)new OCAutoImportHelper.ImportSpecification(name, OCAutoImportHelper.ImportSpecification.Kind.PROJECT_HEADER))) {
            return false;
        }
        boolean isUnderSearchPaths = false;
        for (PsiFileSystemItem psiFileSystemItem : rootAndConfiguration.getLibraryHeadersRoots().getRoots()) {
            VirtualFile rootBase = psiFileSystemItem.getVirtualFile();
            OCLog.LOG.assertTrue(rootBase != null, (Object)(psiFileSystemItem + ": physical=" + psiFileSystemItem.isPhysical() + ", valid=" + psiFileSystemItem.isValid()));
            if (!VfsUtilCore.isAncestor((VirtualFile)rootBase, (VirtualFile)fileToImport, (boolean)true)) continue;
            isUnderSearchPaths = true;
            if (psiFileSystemItem instanceof IncludedHeadersRoot) {
                OCAutoImportHelper.ImportSpecification spec;
                IncludedHeadersRoot includedRoot = (IncludedHeadersRoot)psiFileSystemItem;
                if (includedRoot.isRecursive()) {
                    path = name;
                } else {
                    String relativePath2 = VfsUtilCore.getRelativePath((VirtualFile)fileToImport, (VirtualFile)rootBase);
                    if (relativePath2 == null) {
                        OCLog.LOG.error("Cannot calculate relative path: \n\tbase: " + rootBase + "\n\tchild: " + fileToImport);
                    } else {
                        path = relativePath2;
                    }
                }
                if (processor2.process((Object)(spec = new OCAutoImportHelper.ImportSpecification(path, includedRoot.isUserHeaders() ? OCAutoImportHelper.ImportSpecification.Kind.USER_HEADER_SEARCH_PATH : OCAutoImportHelper.ImportSpecification.Kind.SYSTEM_HEADER_SEARCH_PATH)))) continue;
                return false;
            }
            if (!(psiFileSystemItem instanceof FrameworksSearchRoot)) continue;
            FrameworksSearchRoot frameworksRoot = (FrameworksSearchRoot)psiFileSystemItem;
            final Ref found = new Ref();
            frameworksRoot.processChildren(new PsiElementProcessor<PsiFileSystemItem>(){

                public boolean execute(@NotNull PsiFileSystemItem element) {
                    if (!(element instanceof AppleFramework)) {
                        return true;
                    }
                    if (((AppleFramework)element).containsHeader(fileToImport)) {
                        found.set((Object)((AppleFramework)element));
                        return false;
                    }
                    return true;
                }
            });
            AppleFramework framework = (AppleFramework)((Object)found.get());
            if (framework == null) continue;
            VirtualFile frameworkHeader = framework.getMainFile();
            if (frameworkHeader == null) {
                frameworkHeader = fileToImport;
            }
            if (processor2.process((Object)new OCAutoImportHelper.ImportSpecification(framework.getName() + "/" + frameworkHeader.getName(), OCAutoImportHelper.ImportSpecification.Kind.SYSTEM_HEADER_SEARCH_PATH))) continue;
            return false;
        }
        return isUnderSearchPaths || targetFileParent == null || (relativePath = FileUtil.getRelativePath((String)targetFileParent.getPath(), (String)path, (char)'/')) == null || processor2.process((Object)new OCAutoImportHelper.ImportSpecification(relativePath, OCAutoImportHelper.ImportSpecification.Kind.USER_HEADER_SEARCH_PATH));
    }

    @Override
    public void addHeaderSearchPath(@NotNull Project project2, @Nullable VirtualFile targetFile, @NotNull VirtualFile fileToImport) {
    }

    @Override
    @NotNull
    public Iterable<IntentionAction> getAddHeaderSearchPathFixes(@NotNull Project project2, @NotNull VirtualFile targetFile, @NotNull String fileNameToImport) {
        return Collections.emptyList();
    }
}

