/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.util.io.FileUtilRt;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileWithSelectedExtensionAction;
import com.jetbrains.cidr.lang.psi.impl.OCFileImpl;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import icons.CidrLangIcons;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNewHeaderFileAction
extends OCNewFileWithSelectedExtensionAction<OCNewFileWithSelectedExtensionAction.CreateFileDialog> {
    public OCNewHeaderFileAction() {
        super((FileType)OCFileType.INSTANCE, OCBundle.message("create.cpp.header.title", new Object[0]), OCBundle.message("create.cpp.header.title", new Object[0]), CidrLangIcons.FileType_h);
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        return new OCNewFileActionBase.NewFileNames(null, selectedName + "." + ((OCNewFileWithSelectedExtensionAction.CreateFileDialog)this.myDialogPeer).myFileExtensionPair.myHeaderExt);
    }

    @Override
    @Nullable
    protected String getFileTemplate(String fileName) {
        return OCNewHeaderFileAction.headerTemplate();
    }

    @NotNull
    public static String headerTemplate() {
        return "C Header File.h";
    }

    @Override
    protected boolean isValidName(String selectedName) {
        String headerName = selectedName + "." + ((OCNewFileWithSelectedExtensionAction.CreateFileDialog)this.myDialogPeer).myFileExtensionPair.myHeaderExt;
        return super.isValidName(headerName) && !FileUtilRt.getExtension((String)headerName).isEmpty() && OCFileImpl.isHeaderFile(headerName);
    }

    @Override
    protected OCNewFileWithSelectedExtensionAction.CreateFileDialog createDialog(String defaultName) {
        return new MyCreateFileDialog(defaultName);
    }

    private class MyCreateFileDialog
    extends OCNewFileWithSelectedExtensionAction.CreateFileDialog {
        public MyCreateFileDialog(String defaultName) {
            super(defaultName);
        }

        @Override
        @NotNull
        protected String getPresentableName(@NotNull OCCodeStyleSettings.FileExtensionPair pair) {
            return "." + pair.myHeaderExt;
        }
    }
}

