/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.ui.mac.foundation.Foundation;
import com.intellij.util.Function;
import com.jetbrains.cidr.lang.preprocessor.OCInclusionContextUtil;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.symbols.symtable.FileSymbolTable;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNewFileHelperUtil {
    public static void addCreatedFiles(@NotNull PsiDirectory directory, @NotNull String[] fileNames, @NotNull PsiFile[] resultElements, @NotNull Project project2, @NotNull Function<VirtualFile, Void> fileHandler) {
        for (int i = 0; i < resultElements.length; ++i) {
            PsiFile file2 = resultElements[i];
            file2 = file2 == null ? directory.createFile(fileNames[i]) : (PsiFile)directory.add((PsiElement)file2);
            VirtualFile virtualFile = file2.getVirtualFile();
            if (virtualFile != null) {
                CommandProcessor.getInstance().addAffectedFiles(project2, new VirtualFile[]{virtualFile});
                fileHandler.fun((Object)virtualFile);
            }
            resultElements[i] = file2;
            CodeStyleManager.getInstance((Project)project2).reformat((PsiElement)file2);
            if (!(file2 instanceof OCFile)) continue;
            FileSymbolTable.forFile(file2, OCInclusionContextUtil.headerContext(file2).derive());
        }
    }

    public static void fillCommonTemplateProperties(@NotNull Properties properties, @Nullable String projectName) {
        String name = SystemInfo.isMac ? Foundation.fullUserName() : properties.getProperty("USER");
        properties.setProperty("USER_NAME", name);
        properties.setProperty("PROJECT_NAME", projectName);
        properties.setProperty("PROJECTNAME", projectName);
    }
}

