/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IdeView;
import com.intellij.ide.actions.CreateInDirectoryActionBase;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.util.EditorHelper;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.LangDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.command.UndoConfirmationPolicy;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.fileChooser.FileChooserFactory;
import com.intellij.openapi.fileChooser.FileTextField;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.PsiManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCLog;
import com.jetbrains.cidr.lang.actions.newFile.DialogWrapperFacade;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileHelper;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileHelperProvider;
import com.jetbrains.cidr.lang.formatting.OCFormattingModelBuilder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.UUID;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class OCNewFileActionBase<T extends CreateFileDialogBase>
extends CreateInDirectoryActionBase {
    public static Key<FileFactory> FILE_FACTORY = Key.create((String)"FILE_FACTORY");
    protected static final String HEADER_COMMENTS = "HEADER_COMMENTS";
    protected static final String NAME_TEMPLATE_PROPERTY = "NAME";
    protected static final String FILENAME_TEMPLATE_PROPERTY_1 = "FILE_NAME";
    protected static final String FILENAME_TEMPLATE_PROPERTY_2 = "FILENAME";
    protected static final String HEADER_FILENAME_TEMPLATE_PROPERTY = "HEADER_FILENAME";
    public static final String PROJECT_TEMPLATE_PROPERTY1 = "PROJECT_NAME";
    public static final String PROJECT_TEMPLATE_PROPERTY2 = "PROJECTNAME";
    public static final String USER_NAME_PROPERTY = "USER_NAME";
    public static final String ORGANIZATION_NAME_PROPERTY1 = "ORGANIZATIONNAME";
    public static final String ORGANIZATION_NAME_PROPERTY2 = "ORGANIZATION_NAME";
    protected static final String CLASS_TEMPLATE_NAME = "Objective-C Class.m";
    protected static final String CPP_CLASS_TEMPLATE_NAME = "C++ Class.cc";
    protected static final String HEADER_TEMPLATE_NAME = "Objective-C Header File.h";
    protected static final String CPP_CLASS_HEADER_TEMPLATE_NAME = "C++ Class Header.h";
    protected static final String C_HEADER_TEMPLATE_NAME = "C Header File.h";
    protected static final String C_SOURCE_TEMPLATE_NAME = "C Source File.c";
    protected static final String C_INCLUDE_GUARD_TEMPLATE_NAME = "INCLUDE_GUARD";
    @Nullable
    private final FileType myFileType;
    private List<Runnable> myAuxActions;
    protected PsiFile mySelectedFile;
    protected Project myProject;
    protected PsiDirectory mySelectedDir;
    protected String mySelectedName;
    protected PsiFile[] myResultElements;
    protected T myDialogPeer;
    @Nullable
    protected OCNewFileHelper myHelper;

    protected OCNewFileActionBase(@Nullable FileType type, String text, String description, Icon icon) {
        super(text, description, icon);
        this.myFileType = type;
        this.myAuxActions = new ArrayList<Runnable>();
        this.mySelectedFile = null;
        this.myProject = null;
        this.mySelectedDir = null;
        this.mySelectedName = null;
        this.myResultElements = null;
        OCNewFileHelperProvider[] providers = (OCNewFileHelperProvider[])Extensions.getExtensions(OCNewFileHelperProvider.EP_NAME);
        this.myHelper = providers.length == 1 ? providers[0].createHelper() : null;
    }

    public static boolean isNewFileActionSupported() {
        return ((OCNewFileHelperProvider[])Extensions.getExtensions(OCNewFileHelperProvider.EP_NAME)).length == 1;
    }

    public void addAuxAction(Runnable action) {
        this.myAuxActions.add(action);
    }

    protected boolean isAvailable(DataContext dataContext) {
        return super.isAvailable(dataContext) && this.isAvailable();
    }

    protected boolean isAvailable() {
        return this.myHelper != null;
    }

    public final void actionPerformed(AnActionEvent e) {
        DataContext dataContext = e.getDataContext();
        IdeView view = (IdeView)LangDataKeys.IDE_VIEW.getData(dataContext);
        if (view == null || !this.isAvailable() || this.myHelper == null || !this.myHelper.initFromDataContext(dataContext)) {
            return;
        }
        this.myProject = (Project)CommonDataKeys.PROJECT.getData(dataContext);
        PsiDirectory[] directories = view.getDirectories();
        this.mySelectedDir = directories.length == 1 ? directories[0] : null;
        this.mySelectedFile = (PsiFile)CommonDataKeys.PSI_FILE.getData(dataContext);
        if (!this.invokeDialog(this.myProject, dataContext, null)) {
            return;
        }
        this.selectResult(view);
    }

    protected void selectResult(IdeView view) {
        for (PsiFile createdElement : this.getCreatedElements()) {
            view.selectElement((PsiElement)createdElement);
        }
    }

    public boolean performAction(Project project2, PsiDirectory directory, @NotNull PsiFile file2, @Nullable String name) {
        this.mySelectedDir = directory;
        this.mySelectedFile = file2;
        this.myProject = project2;
        if (project2 == null || directory == null) {
            return false;
        }
        if (this.myHelper == null || !this.myHelper.initFromFile(file2)) {
            return false;
        }
        if (!this.invokeDialog(project2, null, name)) {
            return false;
        }
        this.openCreatedFiles();
        return true;
    }

    public boolean performActionWithoutDialog(String name, @NotNull PsiFile sampleFile, boolean unifyName) {
        VirtualFile virtualFile = sampleFile.getVirtualFile();
        if (virtualFile == null) {
            return false;
        }
        String uniqueName = name;
        int i = 1;
        while (true) {
            boolean wasCollision = false;
            for (String fileName : this.getNewFileNames(uniqueName, sampleFile).getNames()) {
                if (virtualFile.getParent().findChild(fileName) == null) continue;
                wasCollision = true;
                break;
            }
            if (!wasCollision) break;
            int extensionPos = name.lastIndexOf(46);
            uniqueName = extensionPos != -1 ? name.substring(0, extensionPos) + i + name.substring(extensionPos) : name + i;
            ++i;
        }
        if (!unifyName && uniqueName != name) {
            return false;
        }
        return this.performAction(sampleFile.getProject(), virtualFile.getPath(), name, uniqueName, null, sampleFile);
    }

    protected void openCreatedFiles() {
        for (PsiFile element : this.getCreatedElements()) {
            EditorHelper.openInEditor((PsiElement)element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invokeDialog(Project project2, @Nullable DataContext dataContext, @Nullable String defaultName) {
        T peer = this.createDialog(defaultName != null ? defaultName : this.getDefaultName());
        this.myDialogPeer = peer;
        OCLog.LOG.assertTrue(this.myHelper != null);
        DialogWrapper dialog = this.myHelper.createDialog((CreateFileDialogBase)((Object)peer), this.mySelectedDir, dataContext);
        dialog.show();
        try {
            if (dialog.getExitCode() == 0) {
                String selectedName = ((CreateFileDialogBase)((Object)peer)).getSelectedName();
                boolean bl = this.performAction(project2, ((CreateFileDialogBase)((Object)peer)).getSelectedPath(), selectedName, selectedName, dialog, null);
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.myDialogPeer = null;
            this.myAuxActions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean performAction(final Project project2, final String path, String name, String fileName, final DialogWrapper dialog, final @Nullable PsiFile sampleFile) {
        FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance(project2);
        final List<String> fileNames = (this.myDialogPeer != null ? this.getNewFileNames(fileName) : this.getNewFileNames(fileName, sampleFile)).getNames();
        this.myResultElements = new PsiFile[fileNames.size()];
        for (int i = 0; i < fileNames.size(); ++i) {
            String filename = fileNames.get(i);
            String fileTemplate = this.getFileTemplate(filename);
            FileTemplate template = this.loadFileTemplate(fileTemplate, project2);
            this.mySelectedName = name;
            Properties properties = new Properties(FileTemplateManager.getInstance(project2).getDefaultProperties());
            List words = StringUtil.getWordsIn((String)this.mySelectedName);
            if (!ApplicationManager.getApplication().isUnitTestMode()) {
                properties.setProperty(HEADER_COMMENTS, "true");
            }
            properties.setProperty(NAME_TEMPLATE_PROPERTY, words.isEmpty() ? this.mySelectedName : (String)words.get(0));
            properties.setProperty(FILENAME_TEMPLATE_PROPERTY_1, filename);
            properties.setProperty(FILENAME_TEMPLATE_PROPERTY_2, filename);
            if (this.myHelper != null) {
                this.myHelper.setProperties(dialog, properties, sampleFile, project2);
            }
            this.setAdditionalProperties(properties, filename, sampleFile, project2);
            String projectName = properties.getProperty(PROJECT_TEMPLATE_PROPERTY1);
            properties.setProperty(C_INCLUDE_GUARD_TEMPLATE_NAME, OCNewFileActionBase.includeGuard(projectName, filename));
            FileFactory factory = OCNewFileActionBase.getFileFactory(project2);
            try {
                String classText;
                String string = classText = template != null ? template.getText(properties) : "";
                if (classText.isEmpty()) continue;
                this.myResultElements[i] = factory.createFileFromText(filename, this.myFileType, classText);
                continue;
            }
            catch (Exception e) {
                if (fileTemplate == null) continue;
                throw new RuntimeException(String.format("Unable to load template for file template '%s'!", fileTemplateManager.internalTemplateToSubject(fileTemplate)), e);
            }
        }
        final boolean useHelperAndCreateFiles = this.myHelper != null && !ApplicationManager.getApplication().isUnitTestMode();
        final boolean[] dirFailed = new boolean[]{false};
        try {
            OCFormattingModelBuilder.requestAlwaysCreateFullModel();
            new WriteCommandAction(project2, "Creation of new file(s)", new PsiFile[0]){

                protected UndoConfirmationPolicy getUndoConfirmationPolicy() {
                    return UndoConfirmationPolicy.REQUEST_CONFIRMATION;
                }

                protected void run(@NotNull Result result) throws Throwable {
                    CommandProcessor.getInstance().markCurrentCommandAsGlobal(project2);
                    if (useHelperAndCreateFiles) {
                        VirtualFile dir = LocalFileSystem.getInstance().findFileByPath(path);
                        if (dir == null) {
                            dir = VfsUtil.createDirectoryIfMissing((String)path);
                        }
                        if (dir == null) {
                            dirFailed[0] = true;
                            return;
                        }
                        PsiDirectory directory = PsiManager.getInstance((Project)project2).findDirectory(dir.isDirectory() ? dir : dir.getParent());
                        OCLog.LOG.assertTrue(directory != null);
                        OCNewFileActionBase.this.myHelper.doCreateFiles(project2, directory, ArrayUtil.toStringArray((Collection)fileNames), OCNewFileActionBase.this.myResultElements, dialog, sampleFile);
                    }
                    for (Runnable action : OCNewFileActionBase.this.myAuxActions) {
                        action.run();
                    }
                    OCNewFileActionBase.this.myAuxActions.clear();
                }
            }.execute();
        }
        finally {
            OCFormattingModelBuilder.releaseAlwaysCreateFullModel();
        }
        if (dirFailed[0]) {
            Messages.showErrorDialog((String)OCBundle.message("create.directory.failed.message", path), (String)OCBundle.message("create.directory.failed", new Object[0]));
            return false;
        }
        return true;
    }

    @NotNull
    protected static String includeGuard(@Nullable String projectName, @NotNull String filename) {
        ArrayList parts = new ArrayList();
        ContainerUtil.addIfNotNull(parts, (Object)OCNewFileActionBase.toMacroNamePart(projectName));
        ContainerUtil.addIfNotNull(parts, (Object)OCNewFileActionBase.toMacroNamePart(filename));
        if (parts.isEmpty()) {
            return "INC_" + UUID.randomUUID().toString().replace("-", "").toUpperCase(Locale.getDefault());
        }
        String result = StringUtil.join(parts, (String)"_");
        return Character.isJavaIdentifierStart(result.charAt(0)) ? result : "INC_" + result;
    }

    @Nullable
    private static String toMacroNamePart(@Nullable String name) {
        if (name == null) {
            return null;
        }
        String result = StringUtil.join((Collection)StringUtil.getWordsIn((String)name), (String)"_").trim().replaceFirst("^_+", "").replaceFirst("_+$", "").replaceAll("_+", "_").toUpperCase(Locale.getDefault());
        return StringUtil.isEmptyOrSpaces((String)result) ? null : result;
    }

    protected FileTemplate loadFileTemplate(String fileTemplateName, Project project2) {
        FileTemplateManager ftm = FileTemplateManager.getInstance(project2);
        return fileTemplateName != null ? ftm.getInternalTemplate(fileTemplateName) : null;
    }

    private static FileFactory getFileFactory(final Project project2) {
        FileFactory factory = (FileFactory)project2.getUserData(FILE_FACTORY);
        return factory != null ? factory : new FileFactory(){

            @Override
            public PsiFile createFileFromText(@NotNull String fileName, @Nullable FileType fileType, @NotNull String text) {
                PsiFileFactory f = PsiFileFactory.getInstance((Project)project2);
                return fileType == null ? f.createFileFromText(fileName, text) : f.createFileFromText(fileName, fileType, (CharSequence)text);
            }
        };
    }

    protected void setAdditionalProperties(Properties properties, String fileName, @Nullable PsiFile sampleFile, Project project2) {
    }

    @Nullable
    protected abstract String getFileTemplate(String var1);

    @NotNull
    protected abstract NewFileNames getNewFileNames(String var1);

    @NotNull
    protected NewFileNames getNewFileNames(String selectedName, PsiFile sampleFile) {
        return this.getNewFileNames(selectedName);
    }

    @NotNull
    protected String getDefaultName() {
        return "";
    }

    @NotNull
    protected String getDefaultClassPrefix() {
        return this.myHelper != null ? this.myHelper.getDefaultClassPrefix() : "";
    }

    public PsiFile[] getCreatedElements() {
        return this.myResultElements;
    }

    protected boolean isValidName(String selectedName) {
        return StringUtil.isJavaIdentifier((String)selectedName);
    }

    protected abstract T createDialog(String var1);

    public class CreateFileDialogBase
    extends DialogWrapper {
        public static final String NAME_SELECTION_START_TAG = "<@!selection!@>";
        @NotNull
        private String myNameFieldTitle;
        private String myDefaultName;
        protected JTextField myNameField;
        protected TextFieldWithBrowseButton myLocationField;
        private boolean myLocationWasManuallyChanged;
        private DialogWrapperFacade myWrapper;
        @Nullable
        private final String myHelpId;

        public CreateFileDialogBase(String title, @Nullable String defaultName, String helpId) {
            this(title, OCBundle.message("create.field.name", new Object[0]), defaultName, helpId);
        }

        public CreateFileDialogBase(@NotNull String title, String nameFieldTitle, @Nullable String defaultName, String helpId) {
            super(false);
            this.myDefaultName = defaultName;
            this.myNameFieldTitle = nameFieldTitle;
            this.myHelpId = helpId;
            this.setTitle(title);
            this.init();
        }

        @Nullable
        public String getHelpId() {
            return this.myHelpId;
        }

        @Nullable
        public String getSelectedPath() {
            return this.myLocationField.getText();
        }

        @NotNull
        public String getSelectedName() {
            return this.myNameField.getText();
        }

        public PsiDirectory getSelectedDir() {
            return OCNewFileActionBase.this.mySelectedDir;
        }

        public void setSelectedDir(PsiDirectory selectedDir) {
            OCNewFileActionBase.this.mySelectedDir = selectedDir;
        }

        public TextFieldWithBrowseButton getLocationField() {
            return this.myLocationField;
        }

        public boolean isLocationWasManuallyChanged() {
            return this.myLocationWasManuallyChanged;
        }

        public void setLocationWasManuallyChanged(boolean locationWasManuallyChanged) {
            this.myLocationWasManuallyChanged = locationWasManuallyChanged;
        }

        public final void validateOkAction() {
            String error = this.collectOkActionErrors();
            this.setErrorText(null);
            this.setOKActionEnabled(error == null);
            if (!StringUtil.isEmptyOrSpaces((String)error)) {
                this.setErrorText(error);
            }
        }

        @Nullable
        protected String collectOkActionErrors() {
            VirtualFile file2;
            String selectedName = this.getSelectedName();
            if (StringUtil.isEmptyOrSpaces((String)selectedName)) {
                return "";
            }
            if (!this.isValidName(selectedName)) {
                return OCBundle.message("create.error.invalid.name", selectedName);
            }
            if (StringUtil.isEmpty((String)this.myLocationField.getText())) {
                return "";
            }
            String path = this.getSelectedPath();
            VirtualFile virtualFile = file2 = path == null ? null : LocalFileSystem.getInstance().findFileByPath(path);
            if (file2 == null || !file2.isDirectory()) {
                return OCBundle.message("create.error.missing.target.dir", new Object[0]);
            }
            StringBuilder errors = new StringBuilder();
            for (String filename : OCNewFileActionBase.this.getNewFileNames(selectedName).getNames()) {
                VirtualFile child = file2.findChild(filename);
                if (child == null) continue;
                if (child.isDirectory()) {
                    errors.append(OCBundle.message("create.error.dir.exists", filename)).append("<br>");
                    continue;
                }
                errors.append(OCBundle.message("create.error.file.exists", filename)).append("<br>");
            }
            return errors.length() > 0 ? errors.toString() : null;
        }

        public void setWrapper(DialogWrapperFacade wrapper) {
            this.myWrapper = wrapper;
        }

        protected void setOKActionEnabled(boolean isEnabled) {
            if (this.myWrapper == null) {
                super.setOKActionEnabled(isEnabled);
            } else {
                this.myWrapper.setOKEnabled(isEnabled);
            }
        }

        protected void setErrorText(@Nullable String text) {
            if (this.myWrapper == null) {
                super.setErrorText(text);
            } else {
                this.myWrapper.setErrorMessage(text);
            }
        }

        protected boolean areControlsConsistent() {
            return true;
        }

        @Nullable
        protected JComponent createCenterPanel() {
            return new JPanel();
        }

        public JComponent getPreferredFocusedComponent() {
            return this.myNameField;
        }

        public boolean checkCanDoOKAction() {
            if (!this.areControlsConsistent()) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        CreateFileDialogBase.this.myNameField.requestFocus();
                    }
                });
                return false;
            }
            return true;
        }

        protected void doOKAction() {
            if (this.checkCanDoOKAction()) {
                super.doOKAction();
            }
        }

        public void fillGenericControls(FormBuilder formBuilder) {
            this.addNameField(formBuilder);
            this.addLocationField(formBuilder, OCNewFileActionBase.this.myHelper == null || OCNewFileActionBase.this.myHelper.canChangeDir());
        }

        protected void addNameField(FormBuilder formBuilder) {
            this.addNameField(formBuilder, false);
        }

        protected final void addNameField(FormBuilder formBuilder, boolean withUpDownHint) {
            String name;
            int selectionStart = this.myDefaultName.indexOf(NAME_SELECTION_START_TAG);
            if (selectionStart < 0) {
                selectionStart = 0;
                name = this.myDefaultName;
            } else {
                name = this.myDefaultName.substring(0, selectionStart) + this.myDefaultName.substring(selectionStart + NAME_SELECTION_START_TAG.length());
            }
            this.myNameField = new JTextField();
            this.myNameField.setText(name);
            this.myNameField.setMinimumSize(new Dimension(250, this.myNameField.getPreferredSize().height));
            final NameFocusListener focusListener = new NameFocusListener(selectionStart);
            this.myNameField.addFocusListener(focusListener);
            this.myNameField.getDocument().addDocumentListener(new DocumentListener(){

                private void handleChange() {
                    CreateFileDialogBase.this.validateOkAction();
                    focusListener.resetSelectionStart();
                }

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.handleChange();
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.handleChange();
                }
            });
            JComponent nameFieldComponent = this.myNameField;
            if (withUpDownHint) {
                JPanel panel = new JPanel(new BorderLayout(5, 0));
                panel.add((Component)this.myNameField, "Center");
                JLabel hint = new JLabel(AllIcons.Ide.UpDown);
                hint.setToolTipText(OCBundle.message("create.tooltip.arrows.type", new Object[0]));
                panel.add((Component)hint, "East");
                nameFieldComponent = panel;
            }
            formBuilder.addLabeledComponent(this.myNameFieldTitle, nameFieldComponent);
            this.myNameField.setEnabled(this.isNameFieldEnabled());
        }

        protected final void addLocationField(FormBuilder formBuilder, boolean visible) {
            FileChooserDescriptor descriptor = FileChooserDescriptorFactory.createSingleFolderDescriptor();
            FileTextField field = FileChooserFactory.getInstance().createFileTextField(descriptor, this.myDisposable);
            field.getField().setColumns(25);
            this.myLocationField = new TextFieldWithBrowseButton(field.getField());
            this.myLocationField.addBrowseFolderListener(OCBundle.message("create.folder.dialog.title", new Object[0]), OCBundle.message("create.folder.dialog.description", new Object[0]), OCNewFileActionBase.this.myProject, descriptor);
            if (OCNewFileActionBase.this.mySelectedDir != null) {
                this.myLocationField.setText(OCNewFileActionBase.this.mySelectedDir.getVirtualFile().getPath());
            }
            field.getField().getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    CreateFileDialogBase.this.validateOkAction();
                    CreateFileDialogBase.this.myLocationWasManuallyChanged = true;
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    CreateFileDialogBase.this.validateOkAction();
                    CreateFileDialogBase.this.myLocationWasManuallyChanged = e.getDocument().getLength() != 0;
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                }
            });
            if (visible) {
                formBuilder.addLabeledComponent(OCBundle.message("create.field.location", new Object[0]), (JComponent)this.myLocationField);
            }
        }

        private boolean isValidName(String selectedName) {
            return OCNewFileActionBase.this.isValidName(selectedName);
        }

        protected boolean isNameFieldEnabled() {
            return true;
        }

        private class NameFocusListener
        implements FocusListener {
            private int mySelectionStart;

            public NameFocusListener(int selectionStart) {
                this.mySelectionStart = selectionStart;
            }

            @Override
            public void focusGained(@NotNull FocusEvent e) {
                CreateFileDialogBase.this.myNameField.setCaretPosition(this.mySelectionStart);
                CreateFileDialogBase.this.myNameField.moveCaretPosition(CreateFileDialogBase.this.myNameField.getText().length());
            }

            @Override
            public void focusLost(@NotNull FocusEvent e) {
            }

            public void resetSelectionStart() {
                this.mySelectionStart = 0;
            }
        }
    }

    public static class NewFileNames {
        @Nullable
        private final String mySourceName;
        @Nullable
        private final String myHeaderName;

        public NewFileNames(@Nullable String sourceName, @Nullable String headerName) {
            assert (sourceName != null || headerName != null) : "either source or header name should be specified";
            this.mySourceName = sourceName;
            this.myHeaderName = headerName;
        }

        @Nullable
        public String getSourceName() {
            return this.mySourceName;
        }

        @Nullable
        public String getHeaderName() {
            return this.myHeaderName;
        }

        public String toString() {
            return this.mySourceName + " & " + this.myHeaderName;
        }

        @NotNull
        public List<String> getNames() {
            return ContainerUtil.filter(Arrays.asList(this.mySourceName, this.myHeaderName), (Condition)Condition.NOT_NULL);
        }
    }

    public static interface FileFactory {
        public PsiFile createFileFromText(@NotNull String var1, @Nullable FileType var2, @NotNull String var3);
    }
}

