/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang.actions.newFile;

import com.intellij.internal.statistic.UsageTrigger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiFile;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.ImmutableList;
import com.intellij.util.ui.DialogUtil;
import com.intellij.util.ui.FormBuilder;
import com.jetbrains.cidr.lang.OCBundle;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCFileTypeHelpers;
import com.jetbrains.cidr.lang.OCLanguageKind;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileActionBase;
import com.jetbrains.cidr.lang.actions.newFile.OCNewFileWithSelectedExtensionAction;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.settings.OCCodeStyleSettings;
import com.jetbrains.cidr.lang.symbols.OCQualifiedName;
import com.jetbrains.cidr.lang.workspace.OCLanguageKindCalculator;
import icons.CidrLangIcons;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.List;
import java.util.Properties;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCNewCppClassAction<T extends MyCreateClassDialog>
extends OCNewFileWithSelectedExtensionAction<T> {
    protected static final String NAMESPACES_OPEN_PROPERTY = "NAMESPACES_OPEN";
    protected static final String NAMESPACES_CLOSE_PROPERTY = "NAMESPACES_CLOSE";
    private OCQualifiedName myNamespace;

    public OCNewCppClassAction() {
        super((FileType)OCFileType.INSTANCE, OCBundle.message("create.cpp.class.title", new Object[0]), OCBundle.message("create.cpp.class.description", new Object[0]), CidrLangIcons.CodeAssistantStruct);
    }

    public OCNewCppClassAction(@Nullable OCQualifiedName namespace) {
        this();
        this.myNamespace = namespace;
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName) {
        return new OCNewFileActionBase.NewFileNames(((MyCreateClassDialog)this.myDialogPeer).myHeaderOnly ? null : selectedName + "." + ((MyCreateClassDialog)this.myDialogPeer).myFileExtensionPair.mySourceExt, selectedName + "." + ((MyCreateClassDialog)this.myDialogPeer).myFileExtensionPair.myHeaderExt);
    }

    @Override
    @NotNull
    protected OCNewFileActionBase.NewFileNames getNewFileNames(String selectedName, PsiFile sampleFile) {
        Couple<String> extensions = this.determineExtensions((OCFile)sampleFile);
        return new OCNewFileActionBase.NewFileNames(selectedName + "." + (String)extensions.first, selectedName + "." + (String)extensions.second);
    }

    @Override
    protected boolean isValidName(String selectedName) {
        return StringUtil.isJavaIdentifier((String)selectedName);
    }

    @Override
    protected void setAdditionalProperties(Properties properties, String fileName, PsiFile sampleFile, Project project2) {
        String headerName;
        String name;
        String namespacesOpenText = "";
        String namespacesCloseText = "";
        for (OCQualifiedName curNamespace = this.myNamespace; curNamespace != null && (name = curNamespace.getName()) != null && !name.isEmpty(); curNamespace = curNamespace.getQualifier()) {
            namespacesOpenText = "namespace " + name + " {" + namespacesOpenText + "\n";
            namespacesCloseText = namespacesCloseText + "}\n";
        }
        if (this.myDialogPeer != null) {
            headerName = this.getNewFileNames(this.mySelectedName).getHeaderName();
        } else {
            assert (sampleFile != null);
            headerName = this.getNewFileNames(this.mySelectedName, sampleFile).getHeaderName();
        }
        properties.setProperty("HEADER_FILENAME", headerName);
        properties.setProperty(NAMESPACES_OPEN_PROPERTY, namespacesOpenText);
        properties.setProperty(NAMESPACES_CLOSE_PROPERTY, namespacesCloseText);
    }

    @Override
    protected String getFileTemplate(String fileName) {
        if (OCFileTypeHelpers.isSourceFile(fileName)) {
            return "C++ Class.cc";
        }
        if (OCFileTypeHelpers.isHeaderFile(fileName)) {
            return "C++ Class Header.h";
        }
        assert (false);
        return null;
    }

    @Override
    protected T createDialog(String defaultName) {
        return (T)((Object)new MyCreateClassDialog(defaultName));
    }

    @Override
    @NotNull
    protected ImmutableList<OCCodeStyleSettings.FileExtensionPair> getExtensions(final @NotNull Project project2) {
        List filtered = ContainerUtil.filter(super.getExtensions(project2), (Condition)new Condition<OCCodeStyleSettings.FileExtensionPair>(){

            public boolean value(OCCodeStyleSettings.FileExtensionPair pair) {
                OCLanguageKind kind = OCLanguageKindCalculator.tryFileExtension(project2, "." + pair.mySourceExt);
                return kind != null && kind.isCpp();
            }
        });
        return ContainerUtil.immutableList((List)filtered);
    }

    public class MyCreateClassDialog
    extends OCNewFileWithSelectedExtensionAction.CreateFileDialog {
        boolean myHeaderOnly;

        public MyCreateClassDialog(String defaultName) {
            super(OCNewCppClassAction.this, OCBundle.message("create.cpp.class.dialog.title", new Object[0]), defaultName);
        }

        @Override
        public void fillGenericControls(FormBuilder formBuilder) {
            super.fillGenericControls(formBuilder);
            NonFocusableCheckBox headerCheckBox = new NonFocusableCheckBox(OCBundle.message("create.checkbox.cpp.class.header", new Object[0]));
            DialogUtil.registerMnemonic((AbstractButton)headerCheckBox, (char)'&');
            headerCheckBox.addItemListener(new ItemListener((JCheckBox)headerCheckBox){
                final /* synthetic */ JCheckBox val$headerCheckBox;
                {
                    this.val$headerCheckBox = jCheckBox;
                }

                @Override
                public void itemStateChanged(ItemEvent e) {
                    MyCreateClassDialog.this.myHeaderOnly = this.val$headerCheckBox.isSelected();
                    if (MyCreateClassDialog.this.myKindCombo != null) {
                        MyCreateClassDialog.this.reloadExtensions();
                    }
                    MyCreateClassDialog.this.validateOkAction();
                }
            });
            OCNewCppClassAction.this.addAuxAction(new Runnable(){

                @Override
                public void run() {
                    UsageTrigger.trigger("cidr.newFile.cppClass");
                    if (MyCreateClassDialog.this.myHeaderOnly) {
                        UsageTrigger.trigger("cidr.newFile.cppClass.headerOnly");
                    }
                }
            });
            formBuilder.addComponent((JComponent)headerCheckBox);
        }

        @Override
        @NotNull
        protected String getPresentableName(@NotNull OCCodeStyleSettings.FileExtensionPair pair) {
            return this.myHeaderOnly ? "." + pair.myHeaderExt : super.getPresentableName(pair);
        }
    }
}

