/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.lang.OCLanguageKind;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class OCLanguageKindProvider {
    public static final ExtensionPointName<OCLanguageKindProvider> EP_NAME = ExtensionPointName.create((String)"cidr.lang.languageKindProvider");
    private static volatile List<OCLanguageKind> ourCache = null;

    protected abstract List<OCLanguageKind> getLanguageKinds();

    public static List<OCLanguageKind> getAllLanguageKinds() {
        if (ourCache != null) {
            return ourCache;
        }
        ArrayList result = ContainerUtil.newArrayList();
        for (OCLanguageKindProvider provider : (OCLanguageKindProvider[])EP_NAME.getExtensions()) {
            result.addAll(provider.getLanguageKinds());
        }
        if (ourCache == null) {
            ourCache = Collections.unmodifiableList(result);
        }
        return ourCache;
    }
}

