/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.lang;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.util.PlatformUtils;
import com.jetbrains.cidr.lang.OCLanguageKind;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public enum CLanguageKind implements OCLanguageKind
{
    C("C", "c"),
    OBJ_C("Objective-C", "m"),
    CPP("C++", "cpp"),
    OBJ_CPP("Objective-C++", "mm");

    public static final Key<CLanguageKind> MAX_LANGUAGE_KIND_KEY;
    private final String myDefaultSourceExtension;
    private final String myDisplayName;

    private CLanguageKind(String name, String extension) {
        this.myDefaultSourceExtension = extension;
        this.myDisplayName = name;
    }

    @NotNull
    public static CLanguageKind maxLanguage(@Nullable Project project2) {
        CLanguageKind predefined;
        CLanguageKind cLanguageKind = predefined = project2 != null ? (CLanguageKind)project2.getUserData(MAX_LANGUAGE_KIND_KEY) : null;
        if (predefined != null) {
            return predefined;
        }
        return PlatformUtils.isAppCode() ? OBJ_CPP : CPP;
    }

    @NotNull
    public static CLanguageKind min(@NotNull CLanguageKind a, @NotNull CLanguageKind b) {
        if (a == b) {
            return a;
        }
        if (a == C || b == C) {
            return C;
        }
        if (a == OBJ_C && b == CPP) {
            return C;
        }
        if (b == OBJ_C && a == CPP) {
            return C;
        }
        if (a == OBJ_C && b == OBJ_CPP) {
            return OBJ_C;
        }
        if (b == OBJ_C && a == OBJ_CPP) {
            return OBJ_C;
        }
        if (a == CPP && b == OBJ_CPP) {
            return CPP;
        }
        if (b == CPP && a == OBJ_CPP) {
            return CPP;
        }
        return a;
    }

    @Nullable
    public static CLanguageKind fromCompilerSetting(@Nullable String setting) {
        if ("objective-c".equals(setting)) {
            return OBJ_C;
        }
        if ("objective-c++".equals(setting)) {
            return OBJ_CPP;
        }
        if ("c".equals(setting)) {
            return C;
        }
        if ("c++".equals(setting)) {
            return CPP;
        }
        return null;
    }

    @Override
    public boolean isCpp() {
        return this == CPP || this == OBJ_CPP;
    }

    @Override
    public boolean isObjC() {
        return this == OBJ_C || this == OBJ_CPP;
    }

    @Override
    public boolean conforms(@NotNull OCLanguageKind requiredKind) {
        return !(!this.isObjC() && requiredKind.isObjC() || !this.isCpp() && requiredKind.isCpp());
    }

    @Override
    @NotNull
    public String getDefaultSourceExtension() {
        return this.myDefaultSourceExtension;
    }

    @Override
    @NotNull
    public String getDisplayName() {
        return this.myDisplayName;
    }

    @Override
    public boolean supportsPrecompiledHeaders() {
        return true;
    }

    static {
        MAX_LANGUAGE_KIND_KEY = Key.create((String)"MAX_LANGUAGE_KIND_KEY");
    }
}

