/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.sm.runner.OutputToGeneralTestEventsConverter;
import com.intellij.execution.testframework.sm.runner.SMTestLocator;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.testing.CidrOutputToGeneralTestEventsConverter;
import com.jetbrains.cidr.execution.testing.CidrTestEventProcessor;
import com.jetbrains.cidr.execution.testing.OCAbstractTestConsoleProperties;
import com.jetbrains.cidr.execution.testing.OCGoogleTestLocationProvider;
import java.text.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jetbrains.buildServer.messages.serviceMessages.ServiceMessageVisitor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCGoogleTestConsoleProperties
extends OCAbstractTestConsoleProperties {
    private static final Pattern TEST_PATTERN = Pattern.compile("\\[\\s*(OK|RUN|FAILED)\\s*]\\s*(.*?)(\\s+\\((\\d+) ms\\))?\n");
    private static final Pattern SUITE_PATTERN = Pattern.compile("\\[----------] \\d+ tests? from (.*?)(\\s+\\(\\d+ ms total\\))?\n");
    private static final Pattern NAME_PATTERN = Pattern.compile("(\\w+)(/(\\d+))?(\\.(\\w+))?(/(\\d+))?((, where TypeParam = (.*))|(, where GetParam\\(\\) = .*))?");
    private static final Pattern INSTANTIATION_PATTERN = Pattern.compile("(\\w+)/(.*)");
    private static final Pattern GLOBAL_ENVIRONMENT_PATTERN = Pattern.compile("\\[----------] Global test environment (set-up|tear-down)");
    private static final Pattern STARTING_PATTERN = Pattern.compile("\\[==========] Running \\d+ tests? from \\d+ test cases?\\.");
    private static final String FILTER_NOTE_PREFIX = "Note: Google Test filter = ";
    private static final String ZERO_TESTS_FINISHED_PREFIX = "[==========] 0 tests from 0 test cases ran.";
    private static final Pattern FAILURE_PATTERN = Pattern.compile("(.+?):(\\d+): Failure\n");

    public OCGoogleTestConsoleProperties(@NotNull RunConfiguration config, @NotNull Executor executor, @NotNull ExecutionTarget target) {
        super(config, "Google Test", executor, target);
    }

    @Override
    public SMTestLocator getTestLocator() {
        return OCGoogleTestLocationProvider.INSTANCE;
    }

    @Override
    public OutputToGeneralTestEventsConverter createTestEventsConverter(@NotNull String testFrameworkName, @NotNull TestConsoleProperties consoleProperties) {
        return new CidrOutputToGeneralTestEventsConverter(testFrameworkName, consoleProperties){
            private boolean myTornDown;
            @Nullable
            private String myPotentiallyFinishedInstantiation;
            @Nullable
            private String myOpenType;
            {
                this.myTornDown = false;
                this.myPotentiallyFinishedInstantiation = null;
                this.myOpenType = null;
                this.myEventProcessor = new CidrTestEventProcessor("gtest");
            }

            @Override
            protected boolean processServiceMessages(String text, Key outputType, ServiceMessageVisitor visitor) throws ParseException {
                this.logOutput(text, outputType);
                this.attachTestFramework(outputType, visitor);
                if (outputType == ProcessOutputTypes.STDOUT) {
                    if (this.myTornDown || STARTING_PATTERN.matcher(text).find() || text.startsWith(OCGoogleTestConsoleProperties.FILTER_NOTE_PREFIX)) {
                        return true;
                    }
                    if (text.startsWith(OCGoogleTestConsoleProperties.ZERO_TESTS_FINISHED_PREFIX)) {
                        this.myTornDown = true;
                        return true;
                    }
                    Matcher m = GLOBAL_ENVIRONMENT_PATTERN.matcher(text);
                    if (m.find()) {
                        this.myTornDown = m.group(1).equals("tear-down");
                        this.reopenInstantiationIfAppropriate(outputType, visitor, null, null, null);
                        this.reopenSuiteIfAppropriate(outputType, visitor, null, null);
                        return true;
                    }
                    m = TEST_PATTERN.matcher(text);
                    if (m.matches()) {
                        String presentationName;
                        String state = m.group(1);
                        String duration = StringUtil.notNullize((String)m.group(4));
                        TestInfo testInfo = this.parseInfo(m.group(2));
                        if (testInfo == null) {
                            return false;
                        }
                        String string = presentationName = testInfo.isValueParameterized ? testInfo.param : testInfo.name;
                        if ("RUN".equals(state)) {
                            this.myRunningTest = presentationName;
                            String location = testInfo.instantiationLocation();
                            if (testInfo.isValueParameterized) {
                                location = location + "." + testInfo.name;
                            }
                            this.reopenSuiteIfAppropriate(outputType, visitor, testInfo.isValueParameterized ? testInfo.name : null, location);
                            this.myPotentiallyFinishedSuite = null;
                            this.doProcessMessages(outputType, visitor, this.myEventProcessor.testStarted(testInfo.testLocation(), presentationName));
                        } else {
                            boolean failed = "FAILED".equals(state);
                            this.processCollectedAssertionOutput(outputType, visitor, presentationName, failed);
                            this.doProcessMessages(outputType, visitor, this.myEventProcessor.testFinished(presentationName, duration, !failed));
                            if (testInfo.isValueParameterized) {
                                this.myPotentiallyFinishedSuite = testInfo.name;
                            }
                            this.myRunningTest = null;
                        }
                        return true;
                    }
                    m = SUITE_PATTERN.matcher(text);
                    if (m.matches()) {
                        boolean finished = StringUtil.isNotEmpty((String)m.group(2));
                        TestInfo testInfo = this.parseInfo(m.group(1));
                        if (testInfo == null) {
                            return false;
                        }
                        if (finished) {
                            if (this.myOpenType != null) {
                                this.suiteFinished(outputType, visitor, this.myOpenType);
                                this.myOpenType = null;
                            }
                            this.reopenSuiteIfAppropriate(outputType, visitor, null, null);
                            if (testInfo.instantiation != null) {
                                this.myPotentiallyFinishedInstantiation = testInfo.instantiation;
                            }
                            this.myPotentiallyFinishedSuite = testInfo.suite;
                        } else {
                            this.reopenInstantiationIfAppropriate(outputType, visitor, testInfo.instantiation, testInfo.instantiationLocation(), testInfo.suite);
                            if (testInfo.isTyped) {
                                this.myOpenType = testInfo.param + " - " + testInfo.type;
                                this.suiteStarted(outputType, visitor, this.myOpenType, testInfo.instantiationLocation() + "=" + testInfo.param);
                            }
                        }
                        return true;
                    }
                    Boolean res = this.processAssertion(outputType, visitor, text, FAILURE_PATTERN);
                    if (res != null) {
                        return res;
                    }
                    if (this.myPotentiallyFinishedSuite != null && this.myRunningTest == null && "\n".equals(text)) {
                        return true;
                    }
                } else {
                    this.checkForTermination(text, outputType, visitor);
                }
                return false;
            }

            @Override
            protected void processCollectedAssertionOutput(Key outputType, ServiceMessageVisitor visitor, @NotNull String testName, boolean failed) throws ParseException {
                if (this.myAssertionOutput.length() > 0) {
                    String assertionText = this.myAssertionOutput.toString();
                    if (failed) {
                        this.fireOnErrorMsg("", assertionText, false);
                    } else {
                        this.doProcessMessages(outputType, visitor, this.myEventProcessor.testErrOut(testName, assertionText));
                    }
                    this.myAssertionOutput.setLength(0);
                }
            }

            @Nullable
            private TestInfo parseInfo(String text) {
                TestInfo testInfo = new TestInfo();
                Matcher m = NAME_PATTERN.matcher(text);
                if (!m.matches()) {
                    boolean ok = false;
                    m = INSTANTIATION_PATTERN.matcher(text);
                    if (m.find()) {
                        testInfo.instantiation = m.group(1);
                        m = NAME_PATTERN.matcher(m.group(2));
                        ok = m.matches();
                    }
                    if (!ok) {
                        return null;
                    }
                }
                testInfo.suite = m.group(1);
                testInfo.name = m.group(5);
                testInfo.param = m.group(7);
                if (testInfo.param == null) {
                    testInfo.param = m.group(3);
                    testInfo.isTyped = testInfo.param != null;
                } else {
                    testInfo.isValueParameterized = testInfo.instantiation != null;
                }
                testInfo.type = m.group(10);
                return testInfo;
            }

            private void reopenInstantiationIfAppropriate(Key outputType, ServiceMessageVisitor visitor, @Nullable String instantiation, String location, @Nullable String suiteName) throws ParseException {
                boolean open2;
                boolean sameSuite = suiteName == null || suiteName.equals(this.myPotentiallyFinishedSuite);
                boolean bl = open2 = instantiation != null && (!instantiation.equals(this.myPotentiallyFinishedInstantiation) || !sameSuite);
                if (this.myPotentiallyFinishedInstantiation != null && (open2 || instantiation == null)) {
                    this.suiteFinished(outputType, visitor, this.myPotentiallyFinishedInstantiation);
                }
                if (suiteName != null) {
                    this.reopenSuiteIfAppropriate(outputType, visitor, suiteName, suiteName);
                }
                if (open2) {
                    this.suiteStarted(outputType, visitor, instantiation, location);
                }
                this.myPotentiallyFinishedInstantiation = null;
            }

            @Override
            protected void suiteStarted(Key outputType, ServiceMessageVisitor visitor, String name, String location) throws ParseException {
                this.doProcessMessages(outputType, visitor, this.myEventProcessor.suiteStarted(name, location));
            }

            @Override
            protected void suiteFinished(Key outputType, ServiceMessageVisitor visitor, String name) throws ParseException {
                this.doProcessMessages(outputType, visitor, this.myEventProcessor.suiteFinished(name));
            }

            class TestInfo {
                private String instantiation;
                private String suite;
                private String name;
                private String param;
                private String type;
                private boolean isTyped;
                private boolean isValueParameterized;

                TestInfo() {
                }

                public String instantiationLocation() {
                    String res = this.suite;
                    if (this.instantiation != null) {
                        res = this.instantiation + "/" + res;
                    }
                    return res;
                }

                public String testLocation() {
                    String res = this.instantiationLocation() + "." + this.name;
                    if (this.param != null) {
                        res = res + "=" + this.param;
                    }
                    if (this.isTyped) {
                        res = res + "?typed";
                    }
                    return res;
                }
            }
        };
    }

    @Override
    @NotNull
    protected Pattern getAssertionPattern() {
        return FAILURE_PATTERN;
    }
}

