/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.lang.OCLog;
import java.util.Collections;
import java.util.SortedSet;
import org.jetbrains.annotations.NotNull;

public class CidrTestScope {
    private final String mySeparator;
    private final SortedSet<CidrTestScopeElement> myElements = ContainerUtil.newTreeSet();
    private final String myPreRenderedScope;

    public CidrTestScope(@NotNull String preRenderedScope) {
        this.mySeparator = null;
        this.myPreRenderedScope = preRenderedScope;
    }

    public CidrTestScope(char separator) {
        this.mySeparator = String.valueOf(separator);
        this.myPreRenderedScope = null;
    }

    public CidrTestScope() {
        this(',');
    }

    public CidrTestScope(@NotNull CidrTestScopeElement element) {
        this();
        this.myElements.add(element);
    }

    public void add(CidrTestScopeElement element) {
        OCLog.LOG.assertTrue(this.myPreRenderedScope == null);
        this.myElements.add(element);
    }

    public SortedSet<CidrTestScopeElement> getElements() {
        OCLog.LOG.assertTrue(this.myPreRenderedScope == null);
        return Collections.unmodifiableSortedSet(this.myElements);
    }

    public String toString() {
        return this.myPreRenderedScope != null ? this.myPreRenderedScope : StringUtil.join(this.myElements, (String)this.mySeparator);
    }
}

