/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.Location;
import com.intellij.execution.actions.ConfigurationContext;
import com.intellij.execution.actions.RunConfigurationProducer;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerTestTreeView;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.BuildTargetAndConfigurationData;
import com.jetbrains.cidr.execution.BuildTargetData;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTargetWithConfigurations;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.ExecutableData;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import com.jetbrains.cidr.lang.search.scopes.OCSearchScope;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestRunConfigurationProducer<BC extends CidrBuildConfiguration, TARGET extends CidrBuildTargetWithConfigurations<BC>, CONFIGURATION extends CidrRunConfiguration<BC, TARGET>, TEST_OBJECT>
extends RunConfigurationProducer<CONFIGURATION> {
    protected CidrTestRunConfigurationProducer(@NotNull ConfigurationType configurationType) {
        super(configurationType);
    }

    protected boolean setupConfigurationFromContext(@NotNull CONFIGURATION configuration, @NotNull ConfigurationContext context, @NotNull Ref<PsiElement> sourceElement) {
        List<TEST_OBJECT> objects = this.findTestObjects(context);
        if (objects.isEmpty()) {
            return false;
        }
        Scope scope = this.determineScope((TEST_OBJECT)objects);
        if (scope == null) {
            return false;
        }
        TEST_OBJECT testObj = objects.get(0);
        this.setupTestTarget(configuration, this.getTargetFromTest(testObj));
        this.setupConfiguration(configuration, scope);
        sourceElement.set((Object)this.getElement(testObj));
        return true;
    }

    protected void setupTestTarget(@NotNull CONFIGURATION newConfigurationWithTemplateDefaults, @NotNull List<TARGET> targetsWithContext) {
        if (targetsWithContext.isEmpty()) {
            return;
        }
        CidrBuildTargetWithConfigurations target = null;
        CidrBuildConfigurationHelper helper = ((CidrRunConfiguration)newConfigurationWithTemplateDefaults).getHelper();
        BuildTargetAndConfigurationData btc = this.extractTargetAndConfigurationFromCurrentSelection(newConfigurationWithTemplateDefaults.getProject(), helper, targetsWithContext);
        if (btc == null) {
            btc = helper.findSimilarValidInTargets(((CidrRunConfiguration)newConfigurationWithTemplateDefaults).getTargetAndConfigurationData(), targetsWithContext);
        }
        if (btc != null && btc.target != null) {
            target = (CidrBuildTargetWithConfigurations)this.findTarget(targetsWithContext, btc.target);
        }
        if (target == null) {
            btc = null;
            target = (CidrBuildTargetWithConfigurations)targetsWithContext.get(0);
        }
        assert (target != null);
        BuildTargetData buildTargetData = new BuildTargetData(target);
        this.setExecutableData(newConfigurationWithTemplateDefaults, new ExecutableData(buildTargetData));
        if (btc == null) {
            BC buildConfiguration = this.getDefaultConfiguration(newConfigurationWithTemplateDefaults, target);
            btc = new BuildTargetAndConfigurationData(buildTargetData, buildConfiguration == null ? null : buildConfiguration.getName());
        }
        ((CidrRunConfiguration)newConfigurationWithTemplateDefaults).setTargetAndConfigurationData(btc);
    }

    @Nullable
    protected abstract BuildTargetAndConfigurationData extractTargetAndConfigurationFromCurrentSelection(@NotNull Project var1, @NotNull CidrBuildConfigurationHelper<BC, TARGET> var2, @NotNull List<TARGET> var3);

    protected abstract void setExecutableData(@NotNull CONFIGURATION var1, @NotNull ExecutableData var2);

    @Nullable
    protected abstract BC getDefaultConfiguration(@NotNull CONFIGURATION var1, @NotNull TARGET var2);

    @Nullable
    protected abstract TARGET findTarget(@NotNull List<TARGET> var1, @NotNull BuildTargetData var2);

    @NotNull
    protected abstract PsiElement getElement(@NotNull TEST_OBJECT var1);

    @NotNull
    protected abstract List<TARGET> getTargetFromTest(@NotNull TEST_OBJECT var1);

    @Nullable
    protected abstract Scope determineScope(@NotNull List<TEST_OBJECT> var1);

    @Nullable
    protected Scope determineScope(@NotNull List<TEST_OBJECT> objects, String separator) {
        return this.foldScope(ContainerUtil.mapNotNull(objects, (Function)new Function<TEST_OBJECT, Scope>(){

            public Scope fun(@NotNull TEST_OBJECT e) {
                return CidrTestRunConfigurationProducer.this.determineScope(e);
            }
        }), separator);
    }

    @Nullable
    protected Scope determineScope(@NotNull ConfigurationContext context) {
        return this.determineScope((TEST_OBJECT)this.findTestObjects(context));
    }

    @Nullable
    protected abstract Scope determineScope(@NotNull TEST_OBJECT var1);

    @NotNull
    protected List<TEST_OBJECT> findTestObjects(@NotNull ConfigurationContext context) {
        return ContainerUtil.mapNotNull(this.getLocations(context), (Function)new Function<Location, TEST_OBJECT>(){

            public TEST_OBJECT fun(@NotNull Location e) {
                return CidrTestRunConfigurationProducer.this.findTestObject(e);
            }
        });
    }

    @Nullable
    protected abstract TEST_OBJECT findTestObject(@NotNull Location var1);

    public boolean isConfigurationFromContext(CONFIGURATION configuration, ConfigurationContext context) {
        Scope scope = this.determineScope(context);
        if (scope == null) {
            return false;
        }
        CidrTestRunConfigurationData delegate = this.getDelegate(configuration);
        if (delegate == null) {
            return false;
        }
        return Comparing.equal((String)delegate.getTestClass(), (String)scope.suite) && Comparing.equal((String)delegate.getTestMethod(), (String)scope.test) && Comparing.equal((String)delegate.getTestPattern(), (String)scope.pattern) && Comparing.equal((Object)((Object)delegate.getTestMode()), (Object)((Object)scope.mode));
    }

    @Contract(value="null -> null")
    @Nullable
    private CidrTestRunConfigurationData getDelegate(CONFIGURATION configuration) {
        return configuration instanceof CidrTestRunConfiguration ? ((CidrTestRunConfiguration)configuration).getTestData() : null;
    }

    protected void setupConfiguration(CONFIGURATION configuration, Scope scope) {
        CidrTestRunConfigurationData delegate = this.getDelegate(configuration);
        if (delegate == null) {
            return;
        }
        delegate.setTestClass(scope.suite);
        delegate.setTestMethod(scope.test);
        delegate.setTestPattern(scope.pattern);
        delegate.setTestMode(scope.mode);
        configuration.setName(scope.name == null ? delegate.suggestedName(((CidrRunConfiguration)configuration).suggestNameForTarget()) : scope.name);
    }

    @NotNull
    protected List<Location> getLocations(final @NotNull ConfigurationContext context) {
        Object[] paths;
        final SMTRunnerTestTreeView treeView = (SMTRunnerTestTreeView)((Object)SMTRunnerTestTreeView.SM_TEST_RUNNER_VIEW.getData(context.getDataContext()));
        if (treeView != null && (paths = treeView.getSelectionPaths()) != null && paths.length > 1) {
            final GlobalSearchScope scope = OCSearchScope.getProjectSourcesScope(context.getProject());
            return ContainerUtil.mapNotNull((Object[])paths, (Function)new Function<TreePath, Location>(){

                public Location fun(TreePath path) {
                    if (treeView.isPathSelected(path.getParentPath())) {
                        return null;
                    }
                    SMTestProxy test = treeView.getSelectedTest(path);
                    return test == null ? null : test.getLocation(context.getProject(), scope);
                }
            });
        }
        Location location = context.getLocation();
        if (location == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(location);
    }

    @Nullable
    protected Scope foldScope(@NotNull List<Scope> elements, String separator) {
        if (elements.isEmpty()) {
            return null;
        }
        if (elements.size() == 1) {
            return elements.get(0);
        }
        final Ref firstName = new Ref();
        List res = ContainerUtil.map(elements, (Function)new Function<Scope, String>(){

            public String fun(Scope scope) {
                firstName.setIfNull((Object)CidrTestRunConfigurationProducer.this.getScopeName(scope));
                return scope.mode == CidrTestRunConfigurationData.Mode.PATTERN ? scope.pattern : CidrTestRunConfigurationProducer.this.createScopeElement(scope).toString();
            }
        });
        if (res.isEmpty()) {
            return null;
        }
        String name = (String)firstName.get();
        if (res.size() > 1) {
            name = name + String.format(" and %d more", res.size() - 1);
        }
        return new Scope(null, null, name, StringUtil.join(new LinkedHashSet(res), (String)separator));
    }

    protected abstract CidrTestScopeElement createScopeElement(Scope var1);

    private String getScopeName(Scope scope) {
        if (scope.name != null) {
            return scope.name;
        }
        if (scope.test == null) {
            return scope.suite;
        }
        return this.formatTestName(scope);
    }

    protected abstract String formatTestName(Scope var1);

    protected static class Scope {
        protected final String suite;
        protected final String test;
        protected final String pattern;
        protected final String name;
        protected final CidrTestRunConfigurationData.Mode mode;

        public Scope(String suite, String test, String name, String pattern) {
            this.suite = suite;
            this.test = test;
            this.pattern = pattern;
            this.name = name;
            this.mode = pattern == null ? CidrTestRunConfigurationData.Mode.SUITE_TEST : CidrTestRunConfigurationData.Mode.PATTERN;
        }
    }
}

