/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.ExecutionBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.markup.HighlighterTargetArea;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Function;
import com.intellij.util.ui.AsyncProcessIcon;
import com.intellij.util.ui.GridBag;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.MergingUpdateQueue;
import com.intellij.util.ui.update.Update;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.CidrBuildConfiguration;
import com.jetbrains.cidr.execution.CidrBuildConfigurationHelper;
import com.jetbrains.cidr.execution.CidrBuildTargetWithConfigurations;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.CidrRunConfigurationSettingsEditor;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.ui.OCTextFieldWithSymbolAutoCompletion;
import java.awt.Component;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxModel;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestRunConfigurationEditor<CONFIGURATION extends CidrRunConfiguration, BC extends CidrBuildConfiguration, TARGET extends CidrBuildTargetWithConfigurations<BC>, BCH extends CidrBuildConfigurationHelper<BC, TARGET>>
extends CidrRunConfigurationSettingsEditor<CONFIGURATION, BC, TARGET, BCH> {
    protected OCTextFieldWithSymbolAutoCompletion myClassField;
    protected EditorTextField myPatternField;
    private AsyncProcessIcon myProcessIcon;
    private JLabel myMethodComboLabel;
    private JLabel myClassFieldLabel;
    private JLabel myPatternFieldLabel;
    private JLabel myAllClassesTipLabel;
    private JRadioButton myRbPattern;
    protected CidrRunConfigurationSettingsEditor.MyComboBox myMethodCombo;
    private Set<String> myClassMethods = Collections.emptySet();
    private boolean myIsDisposed = false;

    public CidrTestRunConfigurationEditor(@NotNull Project project2, @NotNull BCH configHelper) {
        super(project2, configHelper);
    }

    @Override
    protected void createEditorInner(JPanel p, GridBag g) {
        this.createTestKindRadioButtons(p, g);
        this.myClassFieldLabel = new JLabel(this.getSuiteNameMessage() + ":");
        JPanel childPanel = new JPanel(new GridBagLayout());
        p.add((Component)childPanel, g.nextLine().next().insets(0, 0, 0, 0));
        GridBag childGrid = new GridBag().setDefaultFill(1);
        childPanel.add((Component)this.myClassFieldLabel, childGrid.nextLine().next().weightx(0.9));
        this.myProcessIcon = new AsyncProcessIcon("TestCompletion");
        this.myProcessIcon.setVisible(false);
        childPanel.add((Component)this.myProcessIcon, childGrid.next().anchor(22).weightx(0.1));
        this.myClassField = OCTextFieldWithSymbolAutoCompletion.create(this.myProject, this.isCompletionTopLevelOnly(), this.getClassCompletionNameMapper(), this.getClassCompletionCondition(), new OCTextFieldWithSymbolAutoCompletion.ProcessListener(){

            @Override
            public void onStarted() {
                CidrTestRunConfigurationEditor.this.myProcessIcon.setVisible(true);
            }

            @Override
            public void onFinished() {
                CidrTestRunConfigurationEditor.this.myProcessIcon.setVisible(false);
            }
        });
        p.add((Component)((Object)this.myClassField), g.next().coverLine().insets(0, 0, 0, 0));
        this.myClassFieldLabel.setLabelFor((Component)((Object)this.myClassField));
        this.myAllClassesTipLabel = new JBLabel(this.getAllSuitesTipMessage(), UIUtil.ComponentStyle.SMALL, UIUtil.FontColor.BRIGHTER);
        p.add((Component)this.myAllClassesTipLabel, g.nextLine().next().next().coverLine().insets(new Insets(-1, 10, 4, 0)));
        Insets i = new Insets(-1, -1, 12, -1);
        this.myMethodComboLabel = new JLabel(this.getTestNameMessage() + ":");
        p.add((Component)this.myMethodComboLabel, g.nextLine().next().insets(i));
        this.myMethodCombo = CidrTestRunConfigurationEditor.createCombo();
        p.add((Component)((Object)this.myMethodCombo), g.next().coverLine().insets(i));
        this.myMethodComboLabel.setLabelFor((Component)((Object)this.myMethodCombo));
        this.myClassField.setPlaceholder(this.getAllSuitesMessage());
        this.myMethodCombo.setRenderer(new MyTestsRenderer());
        final MergingUpdateQueue queue = new MergingUpdateQueue("UpdateMethods", 500, false, (JComponent)p, (Disposable)this, (JComponent)p, true);
        this.myClassField.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                boolean classSpecified = CidrTestRunConfigurationEditor.this.getTestClassText() != null;
                CidrTestRunConfigurationEditor.this.myMethodComboLabel.setEnabled(classSpecified);
                CidrTestRunConfigurationEditor.this.myMethodCombo.setEnabled(classSpecified);
                queue.cancelAllUpdates();
                queue.queue(new Update("go!"){

                    public void run() {
                        CidrTestRunConfigurationEditor.this.updateClassAndMethodControls();
                    }
                });
            }
        });
        this.myPatternFieldLabel = new JLabel(CidrBundle.message("ocunit.configuration.pattern", new Object[0]) + ":");
        p.add((Component)this.myPatternFieldLabel, g.nextLine().next());
        this.myPatternField = new EditorTextField();
        p.add((Component)((Object)this.myPatternField), g.next().coverLine());
        this.myPatternField.setVisible(false);
        this.myPatternField.setPreferredWidth(150);
        this.myPatternFieldLabel.setLabelFor((Component)((Object)this.myPatternField));
        this.myPatternFieldLabel.setVisible(false);
        super.createEditorInner(p, g);
    }

    protected void disposeEditor() {
        this.myIsDisposed = true;
        this.myClassField.cancelRunningTasks();
        super.disposeEditor();
    }

    protected boolean isCompletionTopLevelOnly() {
        return true;
    }

    @Nullable
    protected Function<OCSymbol, String> getClassCompletionNameMapper() {
        return null;
    }

    @Nullable
    protected abstract Condition<OCSymbol> getClassCompletionCondition();

    private void createTestKindRadioButtons(JPanel p, GridBag g) {
        JBLabel typeLabel = new JBLabel(ExecutionBundle.message((String)"junit.configuration.configure.junit.test.kind.label", (Object[])new Object[0]));
        p.add((Component)typeLabel, g.nextLine().next());
        ButtonGroup bg = new ButtonGroup();
        JRadioButton myRbSuiteTest = new JRadioButton();
        myRbSuiteTest.setText(this.getSuiteNameMessage() + " / " + this.getTestNameMessage());
        myRbSuiteTest.setSelected(true);
        this.myRbPattern = new JRadioButton();
        this.myRbPattern.setText(CidrBundle.message("ocunit.configuration.pattern", new Object[0]));
        bg.add(myRbSuiteTest);
        bg.add(this.myRbPattern);
        p.add((Component)myRbSuiteTest, g.next().weightx(0.0));
        p.add((Component)this.myRbPattern, g.next().weightx(0.0).insets(new Insets(0, 0, 4, 0)));
        ActionListener listener2 = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CidrTestRunConfigurationEditor.this.changeTestKind();
            }
        };
        myRbSuiteTest.addActionListener(listener2);
        this.myRbPattern.addActionListener(listener2);
    }

    private void changeTestKind() {
        boolean pattern = this.myRbPattern.isSelected();
        this.myClassField.setVisible(!pattern);
        this.myClassFieldLabel.setVisible(!pattern);
        this.myAllClassesTipLabel.setVisible(!pattern);
        this.myMethodCombo.setVisible(!pattern);
        this.myMethodComboLabel.setVisible(!pattern);
        this.myPatternField.setVisible(pattern);
        this.myPatternFieldLabel.setVisible(pattern);
    }

    private void updateClassField() {
        Editor editor = this.myClassField.getEditor();
        if (editor == null) {
            return;
        }
        MarkupModel markup = editor.getMarkupModel();
        markup.removeAllHighlighters();
        String classes = this.getTestClassText();
        if (classes == null) {
            return;
        }
        if (!this.isValidClassName()) {
            markup.addRangeHighlighter(0, this.myClassField.getDocument().getText().length(), 5000, SimpleTextAttributes.ERROR_ATTRIBUTES.toTextAttributes(), HighlighterTargetArea.EXACT_RANGE);
        }
    }

    protected abstract boolean isValidClassName();

    private void updateMethodCombo() {
        this.updateMethodCombo((String)this.myMethodCombo.getSelectedItem());
    }

    private void updateMethodCombo(@Nullable String selectedItem) {
        if (this.getTestClassText() == null) {
            selectedItem = null;
        }
        this.myClassMethods = this.collectClassMethods();
        ArrayList<String> items = new ArrayList<String>(this.myClassMethods);
        items.add("");
        if (selectedItem != null && !items.contains(selectedItem)) {
            items.add(selectedItem);
        }
        Collections.sort(items);
        if (selectedItem == null && !items.isEmpty()) {
            selectedItem = items.get(0);
        }
        this.myMethodCombo.setModel((ComboBoxModel)new CollectionComboBoxModel(items, (Object)""));
        this.myMethodCombo.setSelectedItem(selectedItem);
    }

    @NotNull
    protected abstract Set<String> collectClassMethods();

    @Override
    protected void resetEditorFrom(@NotNull CONFIGURATION selected) {
        super.resetEditorFrom(selected);
        assert (selected instanceof CidrTestRunConfiguration);
        CidrTestRunConfigurationData delegate = ((CidrTestRunConfiguration)selected).getTestData();
        this.myClassField.setText(StringUtil.notNullize((String)delegate.getTestClass()));
        this.updateMethodCombo(StringUtil.notNullize((String)delegate.getTestMethod()));
        this.myPatternField.setText(StringUtil.notNullize((String)delegate.getTestPattern()));
        this.myRbPattern.setSelected(delegate.getTestMode() == CidrTestRunConfigurationData.Mode.PATTERN);
        this.changeTestKind();
    }

    @Override
    protected void applyEditorTo(CONFIGURATION selected) throws ConfigurationException {
        super.applyEditorTo(selected);
        assert (selected instanceof CidrTestRunConfiguration);
        CidrTestRunConfigurationData delegate = ((CidrTestRunConfiguration)selected).getTestData();
        CidrTestRunConfigurationData.Mode mode = this.myRbPattern.isSelected() ? CidrTestRunConfigurationData.Mode.PATTERN : CidrTestRunConfigurationData.Mode.SUITE_TEST;
        delegate.setTestClass(mode == CidrTestRunConfigurationData.Mode.SUITE_TEST ? this.getTestClassText() : null);
        delegate.setTestMethod(mode == CidrTestRunConfigurationData.Mode.SUITE_TEST ? this.getTestMethodText() : null);
        delegate.setTestPattern(mode == CidrTestRunConfigurationData.Mode.PATTERN ? StringUtil.nullize((String)this.myPatternField.getText().trim()) : null);
        delegate.setTestMode(mode);
    }

    @Nullable
    protected String getTestClassText() {
        return StringUtil.nullize((String)this.myClassField.getText().trim());
    }

    @Nullable
    private String getTestMethodText() {
        return StringUtil.nullize((String)((String)this.myMethodCombo.getSelectedItem()));
    }

    protected void updateClassAndMethodControls() {
        if (this.myIsDisposed) {
            return;
        }
        this.updateClassField();
        this.updateMethodCombo();
    }

    OCTextFieldWithSymbolAutoCompletion getClassField() {
        return this.myClassField;
    }

    protected abstract String getAllSuitesMessage();

    protected abstract String getAllSuitesTipMessage();

    protected abstract String getTestNameMessage();

    protected abstract String getSuiteNameMessage();

    protected abstract String getAllTestsMessage();

    private class MyTestsRenderer
    extends CidrRunConfigurationSettingsEditor.MyBaseRenderer {
        public MyTestsRenderer() {
            super(CidrTestRunConfigurationEditor.this.hasTargetsInSeveralProjects());
        }

        @Override
        protected void customizeCellRenderer(SimpleColoredComponent component, JList list, Object value, int index, boolean selected, boolean hasFocus) {
            if (value instanceof String) {
                String methodName = (String)value;
                if (methodName.isEmpty()) {
                    component.append(CidrTestRunConfigurationEditor.this.getAllTestsMessage(), this.grayed(selected));
                } else if (!CidrTestRunConfigurationEditor.this.myClassMethods.contains(methodName)) {
                    this.appendNotFound(methodName, selected);
                } else {
                    component.append(methodName);
                }
            }
        }
    }
}

