/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.CidrBundle;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestRunConfigurationData
implements JDOMExternalizable,
Cloneable {
    @Nullable
    protected String myTestClass;
    @Nullable
    protected String myTestMethod;
    @Nullable
    protected String myTestPattern;
    @NotNull
    protected Mode myTestMode = Mode.SUITE_TEST;
    @NotNull
    protected Project myProject;

    public abstract void checkData() throws RuntimeConfigurationException;

    public CidrTestRunConfigurationData(@NotNull Project project2) {
        this.myProject = project2;
    }

    @Nullable
    public String getTestClass() {
        return this.myTestClass;
    }

    public void setTestClass(@Nullable String testClass) {
        this.myTestClass = StringUtil.nullize((String)testClass, (boolean)true);
    }

    @Nullable
    public String getTestMethod() {
        return this.myTestMethod;
    }

    public void setTestMethod(@Nullable String testMethod) {
        this.myTestMethod = StringUtil.nullize((String)testMethod, (boolean)true);
    }

    @Nullable
    public String getTestPattern() {
        return this.myTestPattern;
    }

    public void setTestPattern(@Nullable String testPattern) {
        this.myTestPattern = testPattern;
    }

    @NotNull
    public Mode getTestMode() {
        return this.myTestMode;
    }

    public void setTestMode(@NotNull Mode mode) {
        this.myTestMode = mode;
    }

    @NotNull
    public String suggestedName(@Nullable String fallbackName) {
        if (this.myTestClass != null && this.myTestMethod != null) {
            return this.formatTestMethod();
        }
        if (this.myTestMode == Mode.PATTERN) {
            return "Pattern";
        }
        String scopeName = this.myTestClass != null ? this.myTestClass : fallbackName;
        return scopeName == null ? CidrBundle.message("ocunit.defaultName.allTests", new Object[0]) : CidrBundle.message("ocunit.defaultName.allTestsIn", scopeName);
    }

    @NotNull
    protected abstract String formatTestMethod();

    @Nullable
    public abstract String getTestingFrameworkName();

    public void readExternal(Element element) throws InvalidDataException {
        this.setTestClass(element.getAttributeValue("TEST_CLASS"));
        this.setTestMethod(element.getAttributeValue("TEST_METHOD"));
        this.setTestPattern(element.getAttributeValue("TEST_PATTERN"));
        String modeValue = element.getAttributeValue("TEST_MODE");
        this.setTestMode(modeValue == null || modeValue.equals("SUITE_TEST") ? Mode.SUITE_TEST : Mode.PATTERN);
    }

    public void writeExternal(Element element) throws WriteExternalException {
        switch (this.myTestMode) {
            case SUITE_TEST: {
                if (this.myTestClass == null) break;
                element.setAttribute("TEST_CLASS", this.myTestClass);
                if (this.myTestMethod == null) break;
                element.setAttribute("TEST_METHOD", this.myTestMethod);
                break;
            }
            case PATTERN: {
                if (this.myTestPattern == null) break;
                element.setAttribute("TEST_PATTERN", this.myTestPattern);
            }
        }
        element.setAttribute("TEST_MODE", this.myTestMode.name());
    }

    public CidrTestRunConfigurationData clone() {
        try {
            CidrTestRunConfigurationData result = (CidrTestRunConfigurationData)super.clone();
            result.myTestClass = this.myTestClass;
            result.myTestMethod = this.myTestMethod;
            result.myTestPattern = this.myTestPattern;
            result.myTestMode = this.myTestMode;
            result.myProject = this.myProject;
            return result;
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
    }

    public static enum Mode {
        SUITE_TEST,
        PATTERN;

    }
}

