/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.testframework.sm.ServiceMessageBuilder;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrTestEventProcessor {
    @NotNull
    private String myLocationProtocol;

    public CidrTestEventProcessor(@NotNull String locationProtocol) {
        this.myLocationProtocol = locationProtocol;
    }

    @NotNull
    public List<ServiceMessageBuilder> suiteStarted(@NotNull String name) {
        return this.suiteStarted(name, name);
    }

    @NotNull
    public List<ServiceMessageBuilder> suiteStarted(@NotNull String name, @NotNull String location) {
        return this.doSuiteStarted(name, location);
    }

    @NotNull
    protected List<ServiceMessageBuilder> doSuiteStarted(@NotNull String name, @NotNull String location) {
        return Collections.singletonList(this.setLocation(ServiceMessageBuilder.testSuiteStarted(name), location));
    }

    @NotNull
    protected List<ServiceMessageBuilder> suiteFinished(@NotNull String name) {
        return Collections.singletonList(ServiceMessageBuilder.testSuiteFinished(name));
    }

    @NotNull
    public List<ServiceMessageBuilder> testStarted(@NotNull String suiteAndMethodName, @NotNull String testName) {
        return this.doTestStarted(testName, suiteAndMethodName);
    }

    @NotNull
    protected List<ServiceMessageBuilder> doTestStarted(@NotNull String testName, @NotNull String location) {
        return Collections.singletonList(this.setLocation(ServiceMessageBuilder.testStarted(testName), location));
    }

    @NotNull
    public List<ServiceMessageBuilder> testFinished(@NotNull String testName, @NotNull String duration, boolean success) {
        return this.doTestFinished(testName, duration, success, false);
    }

    @NotNull
    protected List<ServiceMessageBuilder> doTestFinished(@NotNull String testName, @NotNull String duration, boolean success, boolean ignored) {
        ServiceMessageBuilder statusMessage = null;
        if (!success) {
            statusMessage = ServiceMessageBuilder.testFailed(testName);
        } else if (ignored) {
            statusMessage = ServiceMessageBuilder.testIgnored(testName);
        }
        ServiceMessageBuilder finishMessage = ServiceMessageBuilder.testFinished(testName).addAttribute("duration", duration);
        if (statusMessage == null) {
            return Collections.singletonList(finishMessage);
        }
        statusMessage.addAttribute("message", "");
        return Arrays.asList(statusMessage, finishMessage);
    }

    @NotNull
    protected List<ServiceMessageBuilder> testErrOut(@NotNull String testName, @NotNull String output) {
        return Collections.singletonList(ServiceMessageBuilder.testStdErr(testName).addAttribute("out", output));
    }

    @NotNull
    private ServiceMessageBuilder setLocation(ServiceMessageBuilder builder, String location) {
        return builder.addAttribute("locationHint", this.myLocationProtocol + "://" + location);
    }

    @Nullable
    public Matcher hideOutputMatcher(@NotNull String text) {
        return null;
    }
}

