/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.Executor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.execution.ui.ExecutionConsole;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.CidrCommandLineState;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrLauncher;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrTestCommandLineState
extends CidrCommandLineState {
    @NotNull
    private final Executor myExecutor;
    @NotNull
    protected final CidrRunConfiguration myConfiguration;
    @Nullable
    protected final CidrTestScope myFailedTests;

    public CidrTestCommandLineState(@NotNull CidrRunConfiguration configuration, @NotNull CidrLauncher launcher, @NotNull ExecutionEnvironment env, @NotNull Executor executor, @Nullable CidrTestScope failedTests) {
        super(env, launcher);
        this.myConfiguration = configuration;
        this.myExecutor = executor;
        this.myFailedTests = failedTests;
    }

    @NotNull
    public Executor getExecutor() {
        return this.myExecutor;
    }

    @NotNull
    public CidrRunConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    @NotNull
    public CidrRerunFailedTestsAction createRerunFailedTestsAction(@NotNull ExecutionConsole console) {
        final SMTRunnerConsoleView consoleView = (SMTRunnerConsoleView)console;
        CidrRerunFailedTestsAction rerunFailedTestsAction = this.doCreateRerunFailedTestsAction(consoleView);
        rerunFailedTestsAction.init(consoleView.getProperties());
        rerunFailedTestsAction.setModelProvider(new Getter<TestFrameworkRunningModel>(){

            public TestFrameworkRunningModel get() {
                return consoleView.getResultsViewer();
            }
        });
        return rerunFailedTestsAction;
    }

    @NotNull
    public CidrTestScope testScope() {
        CidrTestRunConfigurationData delegate = ((CidrTestRunConfiguration)((Object)this.myConfiguration)).getTestData();
        String pattern = StringUtil.notNullize((String)delegate.getTestPattern());
        String scope = delegate.getTestMode() == CidrTestRunConfigurationData.Mode.PATTERN && !pattern.isEmpty() ? pattern : this.createTestScopeElement(delegate.getTestClass(), delegate.getTestMethod()).toString();
        return new CidrTestScope(scope);
    }

    @NotNull
    protected abstract CidrRerunFailedTestsAction doCreateRerunFailedTestsAction(SMTRunnerConsoleView var1);

    @NotNull
    protected abstract CidrTestScopeElement createTestScopeElement(@Nullable String var1, @Nullable String var2);
}

