/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.configurations.RuntimeConfigurationError;
import com.intellij.execution.configurations.RuntimeConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.CidrBundle;
import com.jetbrains.cidr.execution.testing.CidrTestRunConfigurationData;
import com.jetbrains.cidr.execution.testing.CidrTestUtil;
import com.jetbrains.cidr.lang.symbols.cpp.OCStructSymbol;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CidrGoogleTestRunConfigurationData
extends CidrTestRunConfigurationData {
    public static String GOOGLE_TEST = CidrBundle.message("gtest.google.test", new Object[0]);
    public static Key GOOGLE_TEST_LIGHTWEIGHT_VALIDATION = Key.create((String)"GOOGLE_TEST_LIGHTWEIGHT_VALIDATION");

    public CidrGoogleTestRunConfigurationData(@NotNull Project project2) {
        super(project2);
    }

    @Override
    @NotNull
    protected String formatTestMethod() {
        return this.myTestClass + "." + this.myTestMethod;
    }

    @Override
    @NotNull
    public String getTestingFrameworkName() {
        return "GoogleTest";
    }

    @Override
    public void checkData() throws RuntimeConfigurationException {
        String typedTestClassName;
        if (this.myTestMode == CidrTestRunConfigurationData.Mode.PATTERN || this.myTestClass == null || this.myProject.getUserData(GOOGLE_TEST_LIGHTWEIGHT_VALIDATION) != null) {
            return;
        }
        Collection<OCStructSymbol> suiteSymbols = CidrTestUtil.findGoogleTestSymbolsForSuiteRandomly(this.myProject, this.myTestClass, this.myTestMethod == null);
        if (suiteSymbols.isEmpty()) {
            throw new RuntimeConfigurationError(CidrBundle.message("gtest.suiteNotFound", this.myTestClass));
        }
        if (this.myTestMethod == null) {
            return;
        }
        final String testClassName = this.myTestClass + "_" + this.myTestMethod + "_Test";
        boolean methodFound = ContainerUtil.exists(suiteSymbols, (Condition)new Condition<OCStructSymbol>(typedTestClassName = "::gtest_case_" + this.myTestClass + "_::" + this.myTestMethod){
            final /* synthetic */ String val$typedTestClassName;
            {
                this.val$typedTestClassName = string2;
            }

            public boolean value(OCStructSymbol symbol) {
                return testClassName.equals(symbol.getName()) || symbol.getType().getCanonicalName().endsWith(this.val$typedTestClassName);
            }
        });
        if (!methodFound) {
            throw new RuntimeConfigurationError(CidrBundle.message("gtest.testNotFound", this.formatTestMethod()));
        }
    }
}

