/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.testing;

import com.intellij.execution.Executor;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.testframework.sm.runner.ui.SMTRunnerConsoleView;
import com.intellij.openapi.ui.ComponentContainer;
import com.intellij.openapi.util.text.StringUtil;
import com.jetbrains.cidr.execution.CidrRunConfiguration;
import com.jetbrains.cidr.execution.testing.CidrGoogleTestRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrLauncher;
import com.jetbrains.cidr.execution.testing.CidrRerunFailedTestsAction;
import com.jetbrains.cidr.execution.testing.CidrTestCommandLineState;
import com.jetbrains.cidr.execution.testing.CidrTestScope;
import com.jetbrains.cidr.execution.testing.CidrTestScopeElement;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrGoogleTestCommandLineState
extends CidrTestCommandLineState {
    public CidrGoogleTestCommandLineState(@NotNull CidrRunConfiguration configuration, @NotNull CidrLauncher launcher, @Nullable CidrTestScope failedTests, @NotNull ExecutionEnvironment env, @NotNull Executor executor) {
        super(configuration, launcher, env, executor, failedTests);
    }

    @Override
    @NotNull
    public CidrTestScope testScope() {
        return this.myFailedTests == null ? super.testScope() : this.myFailedTests;
    }

    @Override
    @NotNull
    protected CidrRerunFailedTestsAction doCreateRerunFailedTestsAction(SMTRunnerConsoleView consoleView) {
        return new CidrGoogleTestRerunFailedTestsAction((ComponentContainer)consoleView);
    }

    @Override
    @NotNull
    protected CidrTestScopeElement createTestScopeElement(@Nullable String testClass, @Nullable String testMethod) {
        return new OCGoogleTestScopeElement(testClass, testMethod, null, null);
    }

    public static class OCGoogleTestScopeElement
    extends CidrTestScopeElement {
        private final String myInstantiation;
        private final String myParam;

        public OCGoogleTestScopeElement(@Nullable String clazz, @Nullable String method, @Nullable String instantiation, @Nullable String param) {
            super(clazz, method);
            this.myInstantiation = instantiation;
            this.myParam = param;
        }

        @Override
        public String toString() {
            String method = StringUtil.notNullize((String)this.myTestMethod, (String)"*");
            String clazz = StringUtil.notNullize((String)this.myTestClass, (String)"*");
            String param = StringUtil.notNullize((String)this.myParam, (String)"*");
            if (this.myInstantiation != null) {
                return String.format("%s/%s.%s/%s:%s/%s/%s.%s", this.myInstantiation, clazz, method, param, this.myInstantiation, clazz, param, method);
            }
            if (this.myTestClass == null) {
                return "*";
            }
            return String.format("%s.%s:%s/%s.%s:*/%s.%s/*:*/%s/*.%s", clazz, method, clazz, param, method, clazz, method, clazz, method);
        }
    }
}

