/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.ipcUtils;

import com.google.protobuf.GeneratedMessage;
import com.intellij.execution.ExecutionFinishedException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.containers.Queue;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Model;
import com.jetbrains.cidr.execution.ipcUtils.ProtobufTimeoutException;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProtobufServer<T extends GeneratedMessage> {
    private static final Logger LOG = CidrDebuggerLog.LOG;
    private static final Model.Initialized_Message INITIALIZED_MESSAGE = Model.Initialized_Message.getDefaultInstance();
    private static final AtomicInteger ourCount = new AtomicInteger(0);
    private final int myPort;
    private long myDefaultTimeout = 30000L;
    @NotNull
    private final QueueProcessor<GeneratedMessage> myInboxProcessor;
    @NotNull
    private final QueueProcessor<Pair<GeneratedMessage, Consumer<GeneratedMessage>>> myOutboxProcessor;
    private final Queue<Pair<Consumer, Class>> myResponseHandlers = new Queue(100);
    private final Object mySocketLock = new Object();
    private final List<Semaphore> myToRelease = new ArrayList<Semaphore>();
    private final int myUid = ourCount.incrementAndGet();
    private final long myInitializationTime = System.currentTimeMillis();
    private SocketChannel mySocketChannel;
    private ServerSocketChannel myServerSocket;
    private volatile boolean myCancelAcceptAttempts;
    private ProtobufParser<T> myResponseParser;

    public int getPort() {
        return this.myPort;
    }

    private void readerThread(SocketChannel stream) throws IOException {
        try {
            int read;
            ByteBuffer buffer = ProtobufServer.alloc(66560);
            while ((read = stream.read(buffer)) != -1) {
                if (buffer.position() == 0) continue;
                int begin = 0;
                int end = buffer.position();
                buffer.rewind();
                int size = 0;
                while (buffer.position() < end && end - buffer.position() >= 4) {
                    size = buffer.getInt();
                    if (end - buffer.position() < size) break;
                    byte[] array = new byte[size];
                    buffer.get(array);
                    T compositeResponse = this.myResponseParser.parse(array);
                    this.debug("res:" + compositeResponse);
                    GeneratedMessage message = ProtobufServer.unpackComposite(compositeResponse, this.myResponseParser);
                    this.myInboxProcessor.add((Object)message);
                    begin = buffer.position();
                }
                int remaining = end - begin;
                buffer.position(begin);
                byte[] remainingBytes = new byte[remaining];
                buffer.get(remainingBytes);
                if (size > buffer.capacity()) {
                    buffer = ProtobufServer.alloc(size + 4);
                }
                buffer.rewind();
                buffer.put(remainingBytes);
            }
        }
        catch (ClosedChannelException closedChannelException) {
            // empty catch block
        }
    }

    private static ByteBuffer alloc(int size) {
        ByteBuffer buffer = ByteBuffer.allocate(size);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        return buffer;
    }

    public void setDefaultTimeout(long defaultTimeout) {
        this.myDefaultTimeout = defaultTimeout;
    }

    @NotNull
    private static <T extends GeneratedMessage> GeneratedMessage unpackComposite(@NotNull GeneratedMessage compositeResponse, ProtobufParser<T> responseParser) {
        if (!responseParser.decompose(compositeResponse)) {
            return compositeResponse;
        }
        Map allFields = compositeResponse.getAllFields();
        Collection values = allFields.values();
        assert (values.size() == 1) : "More than 1 message packed in one composite response";
        GeneratedMessage next = (GeneratedMessage)values.iterator().next();
        return ProtobufServer.unpackComposite(next, responseParser);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doSendMessage(@NotNull GeneratedMessage generatedMessage) {
        Object object = this.mySocketLock;
        synchronized (object) {
            if (this.mySocketChannel == null) {
                return false;
            }
            byte[] bytes = generatedMessage.toByteArray();
            ByteBuffer buf = ProtobufServer.alloc(bytes.length + 4);
            buf.putInt(bytes.length);
            buf.put(bytes);
            buf.rewind();
            this.debug("req(" + (bytes.length + 4) + "): " + generatedMessage);
            try {
                this.mySocketChannel.write(buf);
            }
            catch (IOException e) {
                return false;
            }
            return true;
        }
    }

    private void debug(String message) {
        long time = System.currentTimeMillis() - this.myInitializationTime;
        LOG.debug("[protobuf client " + this.myUid + "] " + time + " " + message);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int startReaderThread() throws IOException {
        Object object = this.mySocketLock;
        synchronized (object) {
            this.myServerSocket = ServerSocketChannel.open();
            this.myServerSocket.configureBlocking(false);
            InetAddress inetAddress = SystemInfo.isWindows ? InetAddress.getByAddress(new byte[]{127, 0, 0, 1}) : InetAddress.getByName("localhost");
            this.myServerSocket.socket().bind(new InetSocketAddress(inetAddress, 0));
            int port = this.myServerSocket.socket().getLocalPort();
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    try {
                        SocketChannel socket;
                        Object object = ProtobufServer.this.mySocketLock;
                        synchronized (object) {
                            while (ProtobufServer.this.mySocketChannel == null) {
                                if (ProtobufServer.this.myCancelAcceptAttempts) {
                                    return;
                                }
                                ProtobufServer.this.mySocketChannel = ProtobufServer.this.myServerSocket.accept();
                                try {
                                    Thread.sleep(5L);
                                }
                                catch (InterruptedException e) {
                                    return;
                                }
                            }
                            socket = ProtobufServer.this.mySocketChannel;
                        }
                        ProtobufServer.this.myInboxProcessor.add((Object)INITIALIZED_MESSAGE);
                        ProtobufServer.this.readerThread(socket);
                    }
                    catch (IOException e) {
                        ProtobufServer.this.handleIOException(e);
                    }
                }
            });
            return port;
        }
    }

    protected void handleIOException(IOException e) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void tearDown() {
        this.releaseAll();
        this.myCancelAcceptAttempts = true;
        Object object = this.mySocketLock;
        synchronized (object) {
            try {
                if (this.mySocketChannel != null) {
                    this.mySocketChannel.close();
                }
                if (this.myServerSocket != null) {
                    this.myServerSocket.close();
                }
            }
            catch (IOException iOException) {
            }
            finally {
                this.mySocketChannel = null;
                this.myServerSocket = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void releaseAll() {
        this.myInboxProcessor.clear();
        this.myOutboxProcessor.clear();
        List<Semaphore> list = this.myToRelease;
        synchronized (list) {
            for (Semaphore semaphore : this.myToRelease) {
                semaphore.release();
            }
        }
    }

    public ProtobufServer(final @NotNull Consumer<GeneratedMessage> inboxConsumer, ProtobufParser<T> responseParser) throws IOException {
        this.myResponseParser = responseParser;
        this.myInboxProcessor = new QueueProcessor((Consumer)new Consumer<GeneratedMessage>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void consume(GeneratedMessage generatedMessage) {
                Queue queue = ProtobufServer.this.myResponseHandlers;
                synchronized (queue) {
                    Pair responseHandler;
                    Pair pair = responseHandler = ProtobufServer.this.myResponseHandlers.isEmpty() ? null : (Pair)ProtobufServer.this.myResponseHandlers.peekFirst();
                    if (responseHandler != null && responseHandler.second == generatedMessage.getClass()) {
                        ((Consumer)responseHandler.first).consume((Object)generatedMessage);
                        ProtobufServer.this.myResponseHandlers.pullFirst();
                        return;
                    }
                }
                inboxConsumer.consume((Object)generatedMessage);
            }
        }, Conditions.alwaysFalse());
        this.myOutboxProcessor = new QueueProcessor((Consumer)new Consumer<Pair<GeneratedMessage, Consumer<GeneratedMessage>>>(){

            public void consume(Pair<GeneratedMessage, Consumer<GeneratedMessage>> pair) {
                boolean result = ProtobufServer.this.doSendMessage((GeneratedMessage)pair.first);
                if (pair.second != null) {
                    ((Consumer)pair.second).consume(result ? (GeneratedMessage)pair.first : null);
                }
            }
        }, Conditions.alwaysFalse());
        this.myPort = this.startReaderThread();
    }

    public <T extends GeneratedMessage> void sendMessageAndWaitUntilSent(GeneratedMessage request, @Nullable Class<T> responseClass, @Nullable Consumer<T> responseHandler) throws ProtobufTimeoutException {
        this.sendMessageAndWaitUntilSent(request, responseClass, responseHandler, this.myDefaultTimeout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends GeneratedMessage> void sendMessageAndWaitUntilSent(GeneratedMessage request, @Nullable Class<T> responseClass, @Nullable Consumer<T> responseHandler, long msTimeout) throws ProtobufTimeoutException {
        final Semaphore semaphore = new Semaphore(0);
        List<Semaphore> list = this.myToRelease;
        synchronized (list) {
            this.myToRelease.add(semaphore);
        }
        this.sendMessage(request, responseClass, responseHandler, new Consumer<GeneratedMessage>(){

            public void consume(GeneratedMessage generatedMessage) {
                semaphore.release();
            }
        });
        try {
            if (!semaphore.tryAcquire(msTimeout, TimeUnit.MILLISECONDS)) {
                throw new ProtobufTimeoutException();
            }
        }
        catch (InterruptedException interruptedException) {
            List<Semaphore> list2 = this.myToRelease;
            synchronized (list2) {
                this.myToRelease.remove(semaphore);
            }
        }
        finally {
            list = this.myToRelease;
            synchronized (list) {
                this.myToRelease.remove(semaphore);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ResponseType extends GeneratedMessage> void sendMessage(@NotNull GeneratedMessage message, @Nullable Class<ResponseType> responseClass, @Nullable Consumer<ResponseType> responseHandler, @Nullable Consumer<GeneratedMessage> sendHandler) {
        if (responseClass != null && responseHandler != null) {
            Queue<Pair<Consumer, Class>> queue = this.myResponseHandlers;
            synchronized (queue) {
                this.myResponseHandlers.addLast((Object)new Pair(responseHandler, responseClass));
            }
        }
        this.myOutboxProcessor.add((Object)Pair.create((Object)message, sendHandler));
    }

    public <ResponseType extends GeneratedMessage> void sendMessage(@NotNull GeneratedMessage message, @Nullable Class<ResponseType> responseClass, @Nullable Consumer<ResponseType> responseHandler) {
        this.sendMessage(message, responseClass, responseHandler, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <ResponseType extends GeneratedMessage> void sendMessageAndWaitForReply(@NotNull GeneratedMessage message, @NotNull Class<ResponseType> responseClass, final @NotNull Consumer<ResponseType> responseHandler, long msTimeout) throws ProtobufTimeoutException, ExecutionFinishedException {
        final Semaphore semaphore = new Semaphore(0);
        List<Semaphore> list = this.myToRelease;
        synchronized (list) {
            this.myToRelease.add(semaphore);
        }
        final boolean[] abandoned = new boolean[]{false};
        final boolean[] failedToSend = new boolean[]{false};
        Object object = this.myResponseHandlers;
        synchronized (object) {
            this.myResponseHandlers.addLast((Object)new Pair((Object)new Consumer<ResponseType>(){

                public void consume(ResponseType t) {
                    if (!abandoned[0]) {
                        responseHandler.consume(t);
                    }
                    semaphore.release();
                }
            }, responseClass));
        }
        this.myOutboxProcessor.add((Object)new Pair((Object)message, (Object)new Consumer<GeneratedMessage>(){

            public void consume(GeneratedMessage generatedMessage) {
                if (generatedMessage == null) {
                    failedToSend[0] = true;
                    semaphore.release();
                }
            }
        }));
        try {
            if (msTimeout > 0L) {
                if (!semaphore.tryAcquire(msTimeout, TimeUnit.MILLISECONDS)) {
                    abandoned[0] = true;
                    throw new ProtobufTimeoutException();
                }
            } else {
                semaphore.acquire();
            }
        }
        catch (InterruptedException e) {
            abandoned[0] = true;
        }
        finally {
            List<Semaphore> list2 = this.myToRelease;
            synchronized (list2) {
                this.myToRelease.remove(semaphore);
            }
        }
        if (failedToSend[0]) {
            throw new ExecutionFinishedException();
        }
    }

    public <T extends GeneratedMessage> void sendMessageAndWaitForReply(@NotNull GeneratedMessage message, @NotNull Class<T> responseClass, @NotNull Consumer<T> responseHandler) throws ProtobufTimeoutException, ExecutionFinishedException {
        this.sendMessageAndWaitForReply(message, responseClass, responseHandler, 0L);
    }

    public static interface ProtobufParser<T extends GeneratedMessage> {
        public T parse(byte[] var1) throws IOException;

        public boolean decompose(GeneratedMessage var1);
    }
}

