/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XDebuggerTreeNodeHyperlink;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.DBUserException;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrElementValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CachedDebuggerResult;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.TypeRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRendererExtension;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ValueRenderer {
    @NotNull
    protected final CidrPhysicalValue myValue;
    @NotNull
    private final TypeRenderer myTypeRenderer;
    @NotNull
    private final CachedDebuggerResult<String> myValueCache = new CachedDebuggerResult();
    @NotNull
    private CachedDebuggerResult<Integer> myChildrenCountCache = new CachedDebuggerResult();
    private int myRemainingChildrenCount = -1;
    private int myAlreadyDisplayedChildrenCount = 0;

    public ValueRenderer(@NotNull CidrPhysicalValue value) {
        this.myValue = value;
        this.myTypeRenderer = TypeRenderer.createRenderer(value);
    }

    public ValueRenderer(@NotNull CidrPhysicalValue value, @NotNull TypeRenderer typeRenderer) {
        this.myValue = value;
        this.myTypeRenderer = typeRenderer;
    }

    @NotNull
    public CidrPhysicalValue getValue() {
        return this.myValue;
    }

    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrPhysicalValue child, boolean lvalue) {
        boolean isPointer = this.myValue.getVar().isPointer();
        boolean isSwift = this.myValue.isSwift();
        if (!isSwift && isPointer) {
            return this.getChildEvaluationExpression(child, "->", this.myValue);
        }
        if (!isSwift && this.myValue instanceof CidrElementValue) {
            CidrElementValue value = (CidrElementValue)this.myValue;
            if (value.getIndex() == 0) {
                return this.getChildEvaluationExpression(child, "->", value.getContainer());
            }
        } else if (this.myValue instanceof CidrMemberValue) {
            CidrPhysicalValue parent = ((CidrMemberValue)this.myValue).getParent();
            if (this.isSuperNode()) {
                return parent.getPreparedRenderer().getChildEvaluationExpression(child, lvalue);
            }
        }
        return this.getChildEvaluationExpression(child, ".", this.myValue);
    }

    private boolean isSuperNode() {
        LLValue var = this.myValue.getVar();
        return var.getType().equals(var.getName());
    }

    protected LLValue messageSendToSelf(String selectorAndArgs, EvaluationContext context) throws ExecutionException, DBCannotEvaluateException {
        return this.messageSendToSelf(selectorAndArgs, "id", context);
    }

    protected LLValue messageSendToSelf(String selectorAndArgs, String returnType, EvaluationContext context) throws ExecutionException, DBCannotEvaluateException {
        return context.messageSend(this.myValue.getVar(), selectorAndArgs, returnType);
    }

    @Nullable
    public Icon getIcon(boolean hasChildren) {
        return hasChildren ? AllIcons.Debugger.Value : AllIcons.Debugger.Db_primitive;
    }

    @NotNull
    public StringBuilder getConsoleDescription(@NotNull EvaluationContext context) throws ExecutionException {
        StringBuilder builder = new StringBuilder();
        try {
            boolean hasChildren;
            builder.append("(").append(this.myValue.getType()).append(") ").append(this.computeValue(context));
            if (this.shouldPrintChildrenConsoleDescription() && (hasChildren = this.computeHasChildren(context))) {
                builder.append("\n");
                this.printChildrenConsoleDescription(context, builder);
            }
        }
        catch (DBUserException e) {
            ValueRenderer.appendConsoleError(builder, this.toString());
        }
        return builder;
    }

    protected boolean shouldPrintChildrenConsoleDescription() {
        return !this.getValue().isNSObject();
    }

    private void printChildrenConsoleDescription(EvaluationContext context, StringBuilder builder) throws ExecutionException, DBUserException {
        builder.append("{\n");
        ConsoleDescriptionNode container = new ConsoleDescriptionNode(builder, context);
        try {
            this.computeChildren(context, container);
        }
        catch (ExecutionRuntimeException e) {
            throw e.cause;
        }
        finally {
            builder.append("}");
        }
    }

    private static void appendConsoleError(StringBuilder builder, @NotNull String errorMessage) {
        builder.append("error: ").append(errorMessage);
    }

    @NotNull
    public String getDisplayType() {
        return this.myTypeRenderer.getDisplayType();
    }

    protected String getChildEvaluationExpression(CidrPhysicalValue child, String s, CidrPhysicalValue parent) {
        ValueRendererExtension extension = ValueRendererExtension.getExtension(parent.getFrame().getFrame().getLanguage());
        if (extension != null) {
            return extension.getChildEvaluationExpression(child, s, parent);
        }
        return "((" + parent.getType() + ")(" + parent.getEvaluationExpression() + "))" + s + child.getVar().getName();
    }

    @NotNull
    public String computeValue(final @NotNull EvaluationContext context) throws ExecutionException, DBUserException {
        return this.myValueCache.getResult(new CachedDebuggerResult.Calculator<String>(){

            @Override
            @NotNull
            public String calculate() throws ExecutionException, DBUserException {
                LLValue var = ValueRenderer.this.myValue.getVar();
                String result = var.isNilPointer() ? "nil" : ValueRenderer.this.doComputeValue(context);
                return result.equals("{...}") ? "" : result;
            }
        });
    }

    @NotNull
    protected String doComputeValue(@NotNull EvaluationContext context) throws ExecutionException, DBUserException {
        return this.myValue.getPresentationVar().getReadableValue();
    }

    public boolean computeHasChildren(@NotNull EvaluationContext context) throws ExecutionException, DBUserException {
        return this.computeChildrenCount(context, 1) != 0;
    }

    protected int computeChildrenCount(@NotNull EvaluationContext context) throws ExecutionException, DBUserException {
        return this.computeChildrenCount(context, Integer.MAX_VALUE);
    }

    private int computeChildrenCount(final @NotNull EvaluationContext context, final int max) throws ExecutionException, DBUserException {
        if (this.myRemainingChildrenCount != 0) {
            this.myChildrenCountCache = new CachedDebuggerResult();
        }
        return this.myChildrenCountCache.getResult(new CachedDebuggerResult.Calculator<Integer>(){

            @Override
            @NotNull
            public Integer calculate() throws ExecutionException, DBUserException {
                return ValueRenderer.this.myValue.getVar().isNilPointer() ? 0 : ValueRenderer.this.doComputeChildrenCount(context, max);
            }
        });
    }

    protected int doComputeChildrenCount(@NotNull EvaluationContext context) throws ExecutionException, DBUserException {
        return this.doComputeChildrenCount(context, Integer.MAX_VALUE);
    }

    private int doComputeChildrenCount(@NotNull EvaluationContext context, int max) throws ExecutionException, DBUserException {
        return context.getChildrenCount(this.myValue.getPresentationVar(), max);
    }

    public void computeChildren(@NotNull EvaluationContext context, @NotNull XCompositeNode container) throws ExecutionException, DBUserException {
        if (!this.computeHasChildren(context)) {
            container.addChildren(XValueChildrenList.EMPTY, true);
            return;
        }
        this.doComputeChildren(context, container);
    }

    protected int getBatchSize() {
        return 50;
    }

    protected void doComputeChildren(@NotNull EvaluationContext context, @NotNull XCompositeNode container) throws ExecutionException, DBUserException {
        int batchSize = this.getBatchSize();
        int count = this.computeChildrenCount(context, this.myAlreadyDisplayedChildrenCount + batchSize + 1);
        if (count <= this.myAlreadyDisplayedChildrenCount) {
            return;
        }
        CidrValue.addMemberValues(context.getVariableChildrenRange(this.myValue.getPresentationVar(), this.myAlreadyDisplayedChildrenCount, batchSize), this.myValue, container, this.areChildrenModifiable());
        this.myAlreadyDisplayedChildrenCount = Math.min(this.myAlreadyDisplayedChildrenCount + batchSize, count);
        this.myRemainingChildrenCount = count - this.myAlreadyDisplayedChildrenCount;
        if (this.myRemainingChildrenCount > 0) {
            container.tooManyChildren(-1);
        }
    }

    protected boolean areChildrenModifiable() {
        return false;
    }

    private static class ConsoleDescriptionNode
    implements XCompositeNode {
        private final StringBuilder myBuilder;
        private final EvaluationContext myContext;

        public ConsoleDescriptionNode(StringBuilder builder, EvaluationContext context) {
            this.myBuilder = builder;
            this.myContext = context;
        }

        public void addChildren(@NotNull XValueChildrenList children2, boolean last) {
            for (int i = 0; i < children2.size(); ++i) {
                String name = children2.getName(i);
                this.myBuilder.append("\t").append(name).append(" = ");
                try {
                    String shiftedChildren = ((CidrValue)children2.getValue(i)).getConsoleDescription(this.myContext).replace("\n", "\n\t");
                    this.myBuilder.append(shiftedChildren);
                }
                catch (DBUserException e) {
                    this.setErrorMessage(e.getMessage());
                }
                catch (ExecutionException e) {
                    throw new ExecutionRuntimeException(e);
                }
                this.myBuilder.append("\n");
            }
        }

        public void tooManyChildren(int remaining) {
            this.myBuilder.append("\t...");
            if (remaining > 0) {
                this.myBuilder.append(remaining).append(" more\n");
            }
        }

        public void setErrorMessage(@NotNull String errorMessage) {
            ValueRenderer.appendConsoleError(this.myBuilder, errorMessage);
        }

        public void setErrorMessage(@NotNull String errorMessage, @Nullable XDebuggerTreeNodeHyperlink link) {
            this.setErrorMessage(errorMessage);
        }

        public void setMessage(@NotNull String message, @Nullable Icon icon, @NotNull SimpleTextAttributes attributes, @Nullable XDebuggerTreeNodeHyperlink link) {
        }

        public boolean isObsolete() {
            return false;
        }

        public void setAlreadySorted(boolean alreadySorted) {
        }
    }

    static class ExecutionRuntimeException
    extends RuntimeException {
        ExecutionException cause;

        ExecutionRuntimeException(ExecutionException exception) {
            this.cause = exception;
        }
    }
}

