/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import org.jetbrains.annotations.NotNull;

public class TypeRenderer {
    @NotNull
    protected CidrPhysicalValue myValue;

    public TypeRenderer(@NotNull CidrPhysicalValue value) {
        this.myValue = value;
    }

    @NotNull
    public String getDisplayType() {
        return this.myValue.getVar().getBestType();
    }

    @NotNull
    public static TypeRenderer createRenderer(@NotNull CidrPhysicalValue value) {
        return new TypeRenderer(value);
    }

    @NotNull
    public static TypeRenderer createTemplateRenderer(@NotNull CidrPhysicalValue value) {
        return new TemplateTypeRenderer(value);
    }

    @NotNull
    public static TypeRenderer createSelectorRenderer(@NotNull CidrPhysicalValue value) {
        return new SelectorTypeRenderer(value);
    }

    private static class SelectorTypeRenderer
    extends TypeRenderer {
        public SelectorTypeRenderer(@NotNull CidrPhysicalValue value) {
            super(value);
        }

        @Override
        @NotNull
        public String getDisplayType() {
            return "SEL";
        }
    }

    private static class TemplateTypeRenderer
    extends TypeRenderer {
        private static final int TEMPLATE_TYPE_REDUCE_LEVEL = 1;

        public TemplateTypeRenderer(@NotNull CidrPhysicalValue value) {
            super(value);
        }

        @Override
        @NotNull
        public String getDisplayType() {
            String type = this.myValue.getVar().getBestType();
            StringBuilder result = new StringBuilder();
            int count = 0;
            for (int i = 0; i < type.length(); ++i) {
                char c = type.charAt(i);
                if (c == '<') {
                    ++count;
                }
                if (count <= 1) {
                    result.append(c);
                }
                if (c != '>') continue;
                --count;
            }
            return count == 0 ? result.toString() : type;
        }
    }
}

