/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Key;
import com.jetbrains.cidr.execution.debugger.backend.DBUserException;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.TypeRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class StructValueRenderer
extends ValueRenderer {
    private static final Key<Boolean> IS_STRUCT = Key.create((String)"IS_STRUCT");
    private final boolean mySupportsVariableChildReferencing;

    public StructValueRenderer(@NotNull CidrPhysicalValue value, boolean supportsVariableChildReferencing) {
        super(value, TypeRenderer.createTemplateRenderer(value));
        this.mySupportsVariableChildReferencing = supportsVariableChildReferencing;
    }

    @Nullable
    public static ValueRenderer createIfStruct(@NotNull CidrPhysicalValue value, boolean supportsVariableChildReferencing, EvaluationContext context) throws ExecutionException {
        try {
            String type = value.getType();
            Boolean isStruct = context.getCachedTypeInfo(type, IS_STRUCT);
            if (isStruct == null) {
                isStruct = value.getTypesHelper().isStructType(value, context);
                context.putCachedTypeInfo(type, IS_STRUCT, isStruct);
            }
            return isStruct != false ? new StructValueRenderer(value, supportsVariableChildReferencing) : null;
        }
        catch (DBUserException e) {
            return null;
        }
    }

    @Override
    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrPhysicalValue child, boolean lvalue) {
        if (lvalue) {
            if (!this.mySupportsVariableChildReferencing) {
                String parentExpression = this.myValue.getEvaluationExpression(true);
                return parentExpression + "." + child.getVar().getName();
            }
            return super.getChildEvaluationExpression(child, false);
        }
        return super.getChildEvaluationExpression(child, false);
    }

    @Override
    protected String getChildEvaluationExpression(CidrPhysicalValue child, String s, CidrPhysicalValue parent) {
        if (!this.mySupportsVariableChildReferencing && !parent.isSwift()) {
            String primeParentExpression = parent.getEvaluationExpression();
            String parentExpression = "((struct " + parent.getType() + ")(" + primeParentExpression + "))";
            return parentExpression + s + child.getVar().getName();
        }
        return super.getChildEvaluationExpression(child, s, parent);
    }

    @Override
    protected boolean areChildrenModifiable() {
        return true;
    }
}

