/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.jetbrains.cidr.execution.debugger.backend.DBUserException;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.TypeRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SelectorValueRenderer
extends ValueRenderer {
    public SelectorValueRenderer(@NotNull CidrPhysicalValue value) {
        super(value, TypeRenderer.createSelectorRenderer(value));
    }

    @Nullable
    public static ValueRenderer createIfSelector(@NotNull CidrPhysicalValue value, @NotNull LLValue var) {
        String type;
        SelectorValueRenderer result = null;
        if (var.isValidPointer() && SelectorValueRenderer.isSelectorType(type = var.getBestType())) {
            result = new SelectorValueRenderer(value);
        }
        return result;
    }

    @Override
    @NotNull
    protected String doComputeValue(@NotNull EvaluationContext context) throws ExecutionException, DBUserException {
        return context.getSelectorName(this.myValue.getVar());
    }

    public static boolean isSelectorType(@NotNull String type) {
        return type.endsWith("objc_selector *") || type.equals("SEL");
    }
}

