/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.jetbrains.cidr.execution.debugger.backend.DBUserException;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrElementValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ContainerValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PointerValueRenderer
extends ContainerValueRenderer {
    private static final Pattern SWIFT_POINTER_PATTERN = Pattern.compile("Swift\\.((COpaque)|(Unsafe)|(UnsafeMutable))Pointer(<.*>)?");

    public PointerValueRenderer(@NotNull CidrPhysicalValue value) {
        super(value);
    }

    @Nullable
    public static ValueRenderer createIfPointer(@NotNull CidrPhysicalValue value, @NotNull LLValue var) {
        if (!var.isValidPointer() || var.isPointerReference() || var.getTypeClass() == LLValue.TypeClass.FUNCTION || SWIFT_POINTER_PATTERN.matcher(var.getBestType()).matches() || var.getBestType().equals("Builtin.RawPointer") || value.isNSObject() || value.getTypesHelper().isCPPThisPsi(value)) {
            return null;
        }
        return new PointerValueRenderer(value);
    }

    @Override
    protected int doComputeChildrenCount(@NotNull EvaluationContext context) {
        if ("void *".equals(this.myValue.getVar().getBestType())) {
            return 0;
        }
        return 1;
    }

    @Override
    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrPhysicalValue child, boolean lvalue) {
        int index = ((CidrElementValue)child).getIndex();
        return index == 0 ? "(*(" + this.myValue.getEvaluationExpression(lvalue) + "))" : this.evaluationExpressionForChildAtIndex(index, lvalue);
    }

    @Override
    protected boolean shouldPrintChildrenConsoleDescription() {
        return false;
    }

    @Override
    protected void doComputeChildren(@NotNull EvaluationContext context, @NotNull XCompositeNode container) throws ExecutionException, DBUserException {
        int batchSize = this.getCurrentIndex() == 0 ? 1 : (this.getCurrentIndex() == 1 ? this.getBatchSize() - 1 : this.getBatchSize());
        List<LLValue> arraySlice = context.arraySlice(this.myValue.getVar(), this.getCurrentIndex(), batchSize);
        ArrayList<CidrValue> values = new ArrayList<CidrValue>();
        for (LLValue value : arraySlice) {
            values.add(this.nextElementValue(value));
        }
        CidrValue.addAllTo(values, container);
        container.tooManyChildren(-1);
    }

    private String evaluationExpressionForChildAtIndex(int index, boolean lvalue) {
        if (lvalue) {
            return "((" + this.myValue.getEvaluationExpression(true) + ") + " + index + ")";
        }
        return "(" + this.myValue.getEvaluationExpression() + ")[" + index + "]";
    }
}

