/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.jetbrains.cidr.execution.debugger.backend.DBUserException;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NSObjectValueRenderer
extends ValueRenderer {
    public static final Pattern NS_STRING_TYPES_IMPL = Pattern.compile("(const __CFString \\*)|(CFStringRef)");

    @Nullable
    public static NSObjectValueRenderer createIfObject(@NotNull CidrPhysicalValue value, @NotNull LLValue var) {
        if (var.isValidPointer() && (value.isNSObject() || NS_STRING_TYPES_IMPL.matcher(var.getType()).matches())) {
            return new NSObjectValueRenderer(value);
        }
        return null;
    }

    protected NSObjectValueRenderer(@NotNull CidrPhysicalValue value) {
        super(value);
    }

    @Override
    @NotNull
    protected String doComputeValue(@NotNull EvaluationContext evaluationContext) throws ExecutionException, DBUserException {
        LLValue var = this.myValue.getPresentationVar();
        return "\"" + evaluationContext.objectDescription(var) + "\"";
    }

    @Override
    protected boolean areChildrenModifiable() {
        return true;
    }
}

