/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XValueModifier;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.DBUserException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValueModifier;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import java.util.Collection;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NSManagedObjectValueRenderer
extends ValueRenderer {
    private static final Key<Boolean> IS_NS_MANAGED_OBJECT = Key.create((String)"IS_NS_MANAGED_OBJECT");
    private volatile LLValue myEntityCache;
    protected final String myClassName;

    @Nullable
    public static ValueRenderer create(CidrPhysicalValue value, EvaluationContext context) throws ExecutionException {
        if (((Object)((Object)value)).getClass() == IVarValue.class) {
            return new IVarValueRenderer((IVarValue)value);
        }
        if (value.isSwift()) {
            return null;
        }
        try {
            return new NSManagedObjectValueRenderer(value, context);
        }
        catch (NotApplicableException e) {
            return null;
        }
        catch (DBUserException e) {
            return null;
        }
    }

    protected NSManagedObjectValueRenderer(@NotNull CidrPhysicalValue value, EvaluationContext context) throws ExecutionException, DBUserException, NotApplicableException {
        super(value);
        String type = this.myValue.getVar().getBestType();
        if (!this.myValue.isNSObject() && !this.myValue.isSwiftOptional()) {
            throw new NotApplicableException();
        }
        Boolean isNSManagedObject = context.getCachedTypeInfo(type, IS_NS_MANAGED_OBJECT);
        if (isNSManagedObject == null) {
            isNSManagedObject = context.isKindOfClass("NSManagedObject", this.getValue());
            context.putCachedTypeInfo(type, IS_NS_MANAGED_OBJECT, isNSManagedObject);
        }
        if (!isNSManagedObject.booleanValue()) {
            throw new NotApplicableException();
        }
        this.myClassName = this.determineClassName(context);
    }

    @NotNull
    protected String determineClassName(@NotNull EvaluationContext context) throws ExecutionException, DBCannotEvaluateException {
        return context.stringFromNSString(context.messageSend(this.getEntity(context), "managedObjectClassName"));
    }

    @Override
    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrPhysicalValue child, boolean lvalue) {
        if (lvalue) {
            if (child instanceof KeyedValue) {
                return "(id)[" + this.myValue.getEvaluationExpression() + " valueForKey:@\"" + child.getName() + "\"]";
            }
            return "(" + this.myValue.getEvaluationExpression(true) + ")->" + child.getName();
        }
        if (child instanceof KeyedValue) {
            return "(id)[" + this.myValue.getEvaluationExpression() + " " + child.getName() + "]";
        }
        return "((" + this.myClassName + " *)(" + this.myValue.getEvaluationExpression() + "))->" + child.getName();
    }

    @Override
    @NotNull
    public String getDisplayType() {
        return this.myClassName + " *";
    }

    @Override
    public Icon getIcon(boolean hasChildren) {
        return AllIcons.Debugger.Db_db_object;
    }

    @Override
    @NotNull
    protected String doComputeValue(@NotNull EvaluationContext context) throws ExecutionException, DBUserException {
        LLValue entity = this.getEntity(context);
        String entityName = context.stringFromNSString(context.messageSend(entity, "name"));
        String objectID = context.objectDescription(context.messageSend(this.messageSendToSelf("objectID", context), "URIRepresentation"));
        return "entity: " + entityName + (this.messageSendToSelf("isFault", "unsigned char", context).isTrue() ? "(Fault) " : " ") + objectID;
    }

    @NotNull
    private LLValue getEntity(EvaluationContext context) throws ExecutionException, DBCannotEvaluateException {
        return this.myEntityCache != null ? this.myEntityCache : (this.myEntityCache = this.messageSendToSelf("entity", context));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doComputeChildren(@NotNull EvaluationContext context, @NotNull XCompositeNode container) throws ExecutionException, DBUserException {
        LLValue key;
        LLValue entity = this.getEntity(context);
        LLValue attrDict = context.messageSend(entity, "attributesByName");
        LLValue attrKeys = context.messageSend(attrDict, "keyEnumerator");
        final String managedObjectClassName = this.myClassName;
        SmartList values = new SmartList();
        while ((key = context.messageSend(attrKeys, "nextObject")).isTrue()) {
            LLValue attrVal = this.messageSendToSelf("valueForKey:" + key.getPointer(), context);
            String name = context.stringFromNSString(key);
            attrVal.setName(name);
            values.add(new KeyedValue(attrVal, managedObjectClassName));
        }
        LLValue relDict = context.messageSend(entity, "relationshipsByName");
        LLValue relKeys = context.messageSend(relDict, "keyEnumerator");
        while ((key = context.messageSend(relKeys, "nextObject")).isTrue()) {
            LLValue relVal = this.messageSendToSelf("valueForKey:" + key.getPointer(), context);
            String name = context.stringFromNSString(key);
            relVal.setName(name);
            values.add(new KeyedValue(relVal, managedObjectClassName));
        }
        try {
            if (!this.isManagedObject(managedObjectClassName)) {
                LLValue intermediate;
                LLValue typed = context.evaluate(this.valueCastedToManagedObject());
                List<LLValue> children2 = context.getVariableChildren(typed);
                if (!children2.isEmpty() && typed.getType().equals(managedObjectClassName + "_" + managedObjectClassName + "_ *") && (intermediate = (LLValue)((Object)ContainerUtil.find(children2, (Condition)new Condition<LLValue>(){

                    public boolean value(LLValue child) {
                        return child.getName().equals(managedObjectClassName);
                    }
                }))) != null) {
                    children2 = context.getVariableChildren(intermediate);
                }
                for (LLValue child : children2) {
                    if (this.isManagedObject(child.getName())) continue;
                    values.add(new IVarValue(child, managedObjectClassName));
                }
            }
        }
        finally {
            CidrValue.addAllTo((Collection<CidrValue>)values, container);
        }
    }

    protected String valueCastedToManagedObject() throws DBCannotEvaluateException {
        return EvaluationContext.cast(this.myValue.getVar().getPointer(), this.myClassName + "*");
    }

    protected boolean isManagedObject(@NotNull String className) {
        return className.equals("NSManagedObject");
    }

    @NotNull
    protected LLValue invokeSetValue(@NotNull Pair<LLValue, String> valuePair, @NotNull EvaluationContext evaluationContext, @NotNull LLValue parentVar, @NotNull String keyName) throws ExecutionException, DBCannotEvaluateException {
        return evaluationContext.messageSend(parentVar, " setValue:((id)" + evaluationContext.convertToRValue(parentVar, valuePair) + ") forKey:@\"" + keyName + "\"");
    }

    private static class IVarValueRenderer
    extends ValueRenderer {
        private IVarValueRenderer(@NotNull IVarValue value) {
            super(value);
        }

        @Override
        protected boolean areChildrenModifiable() {
            return true;
        }
    }

    protected static class NotApplicableException
    extends Exception {
        protected NotApplicableException() {
        }
    }

    private class KeyedValueModifier
    extends CidrValueModifier {
        public KeyedValueModifier(CidrStackFrame frame, KeyedValue value) {
            super(frame, value);
        }

        @Override
        protected void setValue(@NotNull String origExpr, @NotNull Pair<LLValue, String> valuePair, @NotNull XValueModifier.XModificationCallback callback, @NotNull DebuggerDriver driver) throws DBCannotEvaluateException, ExecutionException {
            EvaluationContext evaluationContext = this.getFrame().getProcess().getRendererFactory().createEvaluationContext(driver, null, this.getFrame());
            try {
                LLValue parentVar = ((KeyedValue)this.getValue()).getParent().getVar();
                LLValue result = NSManagedObjectValueRenderer.this.invokeSetValue(valuePair, evaluationContext, parentVar, this.getValue().getName());
                if (result.isNilPointer()) {
                    callback.errorOccurred(CidrDebuggerBundle.message("debug.assign.error.cannotAssignExpression", origExpr, this.getValue().getName()));
                    CidrDebuggerLog.LOG.debug("Cannot assign \"" + (String)valuePair.getSecond() + "\" to " + this.getValue().getName());
                    return;
                }
                callback.valueModified();
            }
            catch (ExecutionException e) {
                callback.errorOccurred(CidrDebuggerBundle.message("debug.assign.error.cannotAssignExpression", origExpr, this.getValue().getName()));
                CidrDebuggerLog.LOG.debug(e.getMessage());
            }
        }
    }

    private class KeyedValue
    extends IVarValue {
        public KeyedValue(LLValue attrVal, String className) {
            super(attrVal, className);
        }

        @Override
        public XValueModifier getModifier() {
            return new KeyedValueModifier(this.getFrame(), this);
        }
    }

    private class IVarValue
    extends CidrMemberValue {
        private final String myClassName;

        public IVarValue(LLValue attrVal, String className) {
            super(attrVal, NSManagedObjectValueRenderer.this.myValue, true);
            this.myClassName = className;
        }

        @Override
        protected XSourcePosition doComputePosition(@NotNull XSourcePosition position) {
            return NSManagedObjectValueRenderer.this.isManagedObject(this.myClassName) ? null : this.getTypesHelper().resolveProperty(this, this.myClassName);
        }
    }
}

