/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Key;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectVariablesException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.DBUserException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrElementValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.EnumerableCollectionValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class NSCollectionValueRenderer
extends EnumerableCollectionValueRenderer {
    private static final Key<Boolean> IS_NS_COLLECTION = Key.create((String)"IS_NS_COLLECTION");
    private boolean isDictionary;
    private boolean isSet;
    private LLValue myEnumerator;
    private static final Set<String> KNOWN_TYPES = ContainerUtil.newHashSet((Object[])new String[]{"CFArrayRef", "CoreFoundation.CFArrayRef", "Foundation.NSArray", "CFDictionaryRef", "CoreFoundation.CFDictionaryRef", "Foundation.NSDictionary", "CFSetRef", "CoreFoundation.CFSetRef", "Foundation.NSSet"});

    public NSCollectionValueRenderer(@NotNull CidrPhysicalValue value) {
        super(value);
    }

    @Nullable
    public static ValueRenderer createIfNSCollection(@NotNull EvaluationContext context, @NotNull CidrPhysicalValue value, @NotNull LLValue var) throws ExecutionException {
        if (!var.isValidPointer()) {
            return null;
        }
        String type = CidrDebuggerTypesHelper.unwrapSwiftOptionalTypeIfNecessary(var.getBestType());
        if (!value.isNSObject() && !KNOWN_TYPES.contains(type)) {
            return null;
        }
        Boolean isNSCollection = context.getCachedTypeInfo(type, IS_NS_COLLECTION);
        if (isNSCollection == null) {
            try {
                String id = EvaluationContext.cast(var.getPointer(), "id");
                String expr = context.castIDToNumber("[" + id + " respondsToSelector: @selector(count)]", "int") + " && " + context.castIDToNumber("[" + id + " respondsToSelector: @selector(objectEnumerator)]", "int");
                LLValue hasCountOrEnumerator = context.evaluate(context.castIDToNumber(expr, "int"), DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS);
                isNSCollection = hasCountOrEnumerator.isTrue();
                context.putCachedTypeInfo(type, IS_NS_COLLECTION, isNSCollection);
            }
            catch (DBUserException e) {
                isNSCollection = false;
            }
        }
        return isNSCollection != false ? new NSCollectionValueRenderer(value) : null;
    }

    @Override
    protected int doComputeChildrenCount(@NotNull EvaluationContext context) throws DBCannotCollectVariablesException, ExecutionException, DBCannotEvaluateException {
        return (int)this.messageSendToSelf("count", "unsigned int", context).intValue();
    }

    @Override
    @Nullable
    protected CidrValue nextChild(@NotNull EvaluationContext context) throws ExecutionException, DBCannotEvaluateException {
        CidrValue child;
        if (!this.myEnumerator.isValidPointer()) {
            return null;
        }
        LLValue next = context.messageSend(this.myEnumerator, "nextObject");
        if (this.isDictionary) {
            LLValue object = this.messageSendToSelf("objectForKey:" + EvaluationContext.cast(next.getPointer(), "id"), context);
            child = this.nextMapElementValue(next, object);
        } else {
            child = this.nextElementValue(next);
        }
        return child;
    }

    @Override
    protected void willExpand(@NotNull EvaluationContext context) throws ExecutionException, DBCannotCollectVariablesException, DBCannotEvaluateException {
        this.isDictionary = this.messageSendToSelf("respondsToSelector:@selector(keyEnumerator)", "unsigned char", context).isTrue();
        if (this.isDictionary) {
            this.myEnumerator = context.messageSend(this.myValue.getVar(), "keyEnumerator");
        } else {
            this.isSet = this.messageSendToSelf("isKindOfClass:[NSSet class]", "unsigned char", context).isTrue();
            this.myEnumerator = context.messageSend(this.myValue.getVar(), "objectEnumerator");
        }
    }

    @Override
    protected boolean shouldPrintChildrenConsoleDescription() {
        return true;
    }

    @Override
    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrPhysicalValue child, boolean lvalue) {
        int childIndex = ((CidrElementValue)child).getIndex();
        StringBuilder sb = new StringBuilder();
        String propertyName = null;
        if (this.isSet) {
            propertyName = "allObjects";
        } else if (this.isDictionary) {
            String string = propertyName = "key".equals(child.getName()) ? "allKeys" : "allValues";
        }
        if (this.myValue.isSwift()) {
            String type = CidrDebuggerTypesHelper.unwrapSwiftOptionalTypeIfNecessary(this.myValue.getType());
            String castToType = null;
            if (type.startsWith("CoreFoundation.CF")) {
                castToType = type.replace("CoreFoundation.CF", "NS").replace("Ref", "");
            }
            if (castToType != null) {
                sb.append('(');
            }
            sb.append(this.myValue.getEvaluationExpression());
            if (this.myValue.isSwiftOptional()) {
                sb.append('!');
            }
            if (castToType != null) {
                sb.append(" as ").append(castToType).append(')');
            }
            if (propertyName != null) {
                sb.append('.').append(propertyName);
            }
            return sb.append("[").append(childIndex).append(']').toString();
        }
        sb.append('[');
        String referenceExpression = EvaluationContext.cast(this.myValue.getEvaluationExpression(), "id");
        if (propertyName != null) {
            sb.append('[').append(referenceExpression).append(' ').append(propertyName).append(']');
        } else {
            sb.append(referenceExpression);
        }
        return sb.append(" objectAtIndex:").append(childIndex).append(']').toString();
    }
}

