/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.jetbrains.cidr.execution.debugger.backend.DBUserException;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CollectionValueRenderer;
import java.util.ArrayList;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class EnumerableCollectionValueRenderer
extends CollectionValueRenderer {
    private boolean myInitialized;

    public EnumerableCollectionValueRenderer(@NotNull CidrPhysicalValue value) {
        super(value);
    }

    @Override
    protected final void doComputeChildren(@NotNull EvaluationContext context, @NotNull XCompositeNode container) throws ExecutionException, DBUserException {
        boolean tooMany;
        ArrayList<CidrValue> children2;
        int count;
        block7: {
            if (!this.myInitialized) {
                this.willExpand(context);
                this.myInitialized = true;
            }
            count = this.computeChildrenCount(context);
            children2 = new ArrayList<CidrValue>(this.getBatchSize());
            tooMany = false;
            do {
                if (container.isObsolete()) {
                    return;
                }
                CidrValue child = this.nextChild(context);
                if (child == null) break block7;
                children2.add(child);
                if (this.isCounted() && this.getCurrentIndex() == count) break block7;
            } while (this.getCurrentIndex() % this.getBatchSize() != 0);
            tooMany = true;
        }
        CidrValue.addAllTo(children2, container);
        if (this.isCounted()) {
            int remaining = count - this.getCurrentIndex();
            if (remaining > 0) {
                container.tooManyChildren(remaining);
            }
        } else if (tooMany) {
            container.tooManyChildren(-1);
        }
    }

    protected boolean isCounted() {
        return true;
    }

    @Nullable
    protected abstract CidrValue nextChild(@NotNull EvaluationContext var1) throws ExecutionException, DBUserException;

    protected void willExpand(@NotNull EvaluationContext context) throws ExecutionException, DBUserException {
    }
}

