/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.xdebugger.frame.XCompositeNode;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDictionaryEntryValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrElementValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public abstract class ContainerValueRenderer
extends ValueRenderer {
    private int myCurrentIndex = 0;

    public ContainerValueRenderer(@NotNull CidrPhysicalValue value) {
        super(value);
    }

    protected String getCountDisplayString(int count) {
        return "count = " + count;
    }

    protected void addElementsTo(List<LLValue> children2, XCompositeNode container, boolean modifiable) {
        ArrayList<CidrValue> values = new ArrayList<CidrValue>(children2.size());
        for (LLValue each : children2) {
            values.add(this.nextElementValue(each, modifiable));
        }
        CidrValue.addAllTo(values, container);
    }

    protected final CidrElementValue createElementValue(@NotNull LLValue var, int index, boolean modifiable) {
        return new CidrElementValue(var, "[" + index + "]", this.myValue, index, modifiable);
    }

    protected final CidrElementValue nextElementValue(@NotNull LLValue var) {
        return this.nextElementValue(var, false);
    }

    protected final CidrElementValue nextElementValue(@NotNull LLValue var, boolean modifiable) {
        return this.createElementValue(var, this.myCurrentIndex++, modifiable);
    }

    protected final CidrDictionaryEntryValue createMapElementValue(LLValue key, LLValue value, int index) {
        return new CidrDictionaryEntryValue("[" + index + "]", this.myValue, key, value, index);
    }

    protected final CidrDictionaryEntryValue nextMapElementValue(LLValue key, LLValue value) {
        return this.createMapElementValue(key, value, this.myCurrentIndex++);
    }

    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrDictionaryEntryValue entry, boolean lvalue) {
        return this.getChildEvaluationExpression(entry.getObject(), lvalue);
    }

    protected int getCurrentIndex() {
        return this.myCurrentIndex;
    }
}

