/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.jetbrains.cidr.execution.debugger.backend.DBUserException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CachedDebuggerResult<T> {
    private volatile T myResult = null;
    private volatile ExecutionException myExecutionException = null;
    private volatile DBUserException myUserException = null;

    @Nullable
    public T getResultIfAvailable() {
        return this.myResult;
    }

    @NotNull
    public T getResult(Calculator<T> calculator) throws ExecutionException, DBUserException {
        if (this.myExecutionException != null) {
            throw this.myExecutionException;
        }
        if (this.myUserException != null) {
            throw this.myUserException;
        }
        T result = this.myResult;
        if (result == null) {
            try {
                this.myResult = result = calculator.calculate();
            }
            catch (DBUserException e) {
                this.myUserException = e;
                throw e;
            }
            catch (ExecutionException e) {
                this.myExecutionException = e;
                throw e;
            }
        }
        return result;
    }

    public static interface Calculator<T> {
        @NotNull
        public T calculate() throws ExecutionException, DBUserException;
    }
}

