/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation.renderers;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectVariablesException;
import com.jetbrains.cidr.execution.debugger.backend.DBUserException;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrElementValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ContainerValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CArrayValueRenderer
extends ContainerValueRenderer {
    public static final String ERROR_READING_VARIABLE = "<error reading variable>";
    private static final Pattern VALUE_PATTERN = Pattern.compile("(\\-?\\d+) *([LuU]?)'(.*)('|" + Pattern.quote("<error reading variable>") + ")");
    private final int mySize;
    private final boolean myPrintDisplayString;
    private boolean myIsCString = false;

    public CArrayValueRenderer(@NotNull CidrPhysicalValue value, int size, boolean printDisplayString) {
        super(value);
        this.mySize = size;
        this.myPrintDisplayString = printDisplayString;
        if (!this.myPrintDisplayString) {
            this.myIsCString = this.myValue.getTypesHelper().isCStringType(this.myValue);
        }
    }

    @Nullable
    public static ValueRenderer createIfCArray(CidrPhysicalValue value, LLValue var, boolean printArrayDisplayString) {
        CArrayValueRenderer result = null;
        List arraySize = StringUtil.findMatches((String)var.getBestType(), (Pattern)Pattern.compile(".*\\[(\\d*)\\]"));
        if (arraySize.size() > 0) {
            try {
                String s = (String)arraySize.get(0);
                result = new CArrayValueRenderer(value, s.length() != 0 ? (int)Long.parseLong(s) : 0, printArrayDisplayString);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    @Override
    @NotNull
    protected String doComputeValue(@NotNull EvaluationContext context) throws ExecutionException, DBUserException {
        if (this.myPrintDisplayString) {
            return this.myValue.getVar().getReadableValue();
        }
        if (this.myIsCString) {
            List<LLValue> toAdd = context.getVariableChildrenRange(this.myValue.getVar(), 0, this.getBatchSize());
            String str = new String();
            String prefix = "";
            for (LLValue value : toAdd) {
                context.checkExpiration();
                String readableValue = value.getReadableValue();
                Matcher matcher = VALUE_PATTERN.matcher(readableValue);
                if (!matcher.matches()) {
                    CidrDebuggerLog.LOG.error("failed to parse character: " + readableValue);
                    break;
                }
                int intValue = Integer.parseInt(matcher.group(1));
                if (intValue == 0) break;
                prefix = matcher.group(2);
                String character = matcher.group(3);
                String end = matcher.group(4);
                if (intValue < 0 && "u".equals(prefix)) {
                    intValue += 65536;
                }
                if (ERROR_READING_VARIABLE.equals(end)) {
                    if (intValue < 0 && prefix.isEmpty()) {
                        intValue += 256;
                    }
                    character = intValue >= 32 && intValue <= 126 ? Character.toString((char)intValue) : (prefix.isEmpty() ? String.format("\\%03o", intValue) : String.format("\\x%x", intValue));
                }
                if (("L".equals(prefix) || "u".equals(prefix) || "U".equals(prefix)) && Character.isDefined(intValue)) {
                    character = String.copyValueOf(Character.toChars(intValue));
                }
                str = str + character;
            }
            return prefix + "\"" + str + "\"";
        }
        return "";
    }

    @Override
    protected int computeChildrenCount(@NotNull EvaluationContext context) {
        return this.mySize;
    }

    @Override
    @NotNull
    public String getChildEvaluationExpression(@NotNull CidrPhysicalValue child, boolean lvalue) {
        return "(" + this.myValue.getEvaluationExpression() + ")[" + ((CidrElementValue)child).getIndex() + "]";
    }

    @Override
    protected void doComputeChildren(@NotNull EvaluationContext context, @NotNull XCompositeNode container) throws ExecutionException, DBCannotCollectVariablesException {
        List<LLValue> toAdd = context.getVariableChildrenRange(this.myValue.getVar(), this.getCurrentIndex(), this.getBatchSize());
        this.addElementsTo(toAdd, container, true);
        int remaining = this.mySize - this.getCurrentIndex();
        if (remaining > 0) {
            container.tooManyChildren(remaining);
        }
    }
}

