/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Expirable;
import com.intellij.util.PlatformUtils;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CustomValueRendererFactory;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CArrayValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CFTypeValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ClassValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.InvalidValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.NSCollectionValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.NSManagedObjectValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.NSObjectValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.PointerValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.SelectorValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.StructValueRenderer;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ValueRendererFactory {
    @NotNull
    public ValueRenderer createValueRenderer(@NotNull EvaluationContext evaluationContext, @NotNull CidrPhysicalValue value) throws ExecutionException {
        ValueRenderer result;
        LLValue var = value.getVar();
        if (!var.isValid()) {
            return new InvalidValueRenderer(value);
        }
        CidrDebuggerSettings settings = CidrDebuggerSettings.getInstance();
        boolean isRenderersEnabled = !PlatformUtils.isCLion() && settings.RENDERERS_ENABLED;
        CustomValueRendererFactory[] customFactories = (CustomValueRendererFactory[])CustomValueRendererFactory.EP_NAME.getExtensions();
        if (isRenderersEnabled) {
            for (CustomValueRendererFactory factory : customFactories) {
                result = factory.createRendererLeading(settings, value, var, evaluationContext);
                if (result == null) continue;
                return result;
            }
            if (settings.COCOA_RENDERERS_ENABLED && this.supportsCocoa() && (result = this.createOCRenderers(evaluationContext, value, settings.CORE_DATA_RENDERERS_ENABLED)) != null) {
                return result;
            }
            for (CustomValueRendererFactory factory : customFactories) {
                result = factory.createRendererTrailing(settings, value, var, evaluationContext);
                if (result == null) continue;
                return result;
            }
        }
        if ((result = this.createCRenderers(evaluationContext, value)) != null) {
            return result;
        }
        return new ValueRenderer(value);
    }

    @Nullable
    protected ValueRenderer createOCRenderers(@NotNull EvaluationContext evaluationContext, @NotNull CidrPhysicalValue value, boolean createCoreDataRenderers) throws ExecutionException {
        LLValue var = value.getVar();
        ValueRenderer result = CFTypeValueRenderer.createIfCFType(value, var);
        if (result != null) {
            return result;
        }
        result = NSCollectionValueRenderer.createIfNSCollection(evaluationContext, value, var);
        if (result != null) {
            return result;
        }
        result = ClassValueRenderer.createIfClass(value, var);
        if (result != null) {
            return result;
        }
        if (createCoreDataRenderers && (result = NSManagedObjectValueRenderer.create(value, evaluationContext)) != null) {
            return result;
        }
        result = SelectorValueRenderer.createIfSelector(value, var);
        if (result != null) {
            return result;
        }
        return NSObjectValueRenderer.createIfObject(value, var);
    }

    @Nullable
    protected ValueRenderer createCRenderers(@NotNull EvaluationContext evaluationContext, @NotNull CidrPhysicalValue value) throws ExecutionException {
        LLValue var = value.getVar();
        ValueRenderer result = CArrayValueRenderer.createIfCArray(value, var, this.printArrayDisplayString());
        if (result != null) {
            return result;
        }
        result = PointerValueRenderer.createIfPointer(value, var);
        if (result != null) {
            return result;
        }
        result = StructValueRenderer.createIfStruct(value, this.supportsVariableChildReferencing(), evaluationContext);
        return result;
    }

    public abstract EvaluationContext createEvaluationContext(@NotNull DebuggerDriver var1, @Nullable Expirable var2, @NotNull CidrStackFrame var3);

    protected boolean supportsCocoa() {
        return false;
    }

    protected boolean printArrayDisplayString() {
        return false;
    }

    protected boolean supportsVariableChildReferencing() {
        return true;
    }

    @Deprecated
    public boolean supportsArrayEvaluation() {
        return false;
    }

    @Deprecated
    public boolean isCodeFragmentEvaluationSupported() {
        return false;
    }
}

