/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Pair;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueModifier;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrEvaluatorHelper;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import org.jetbrains.annotations.NotNull;

public class CidrValueModifier
extends XValueModifier {
    @NotNull
    protected final CidrStackFrame myFrame;
    @NotNull
    private final CidrPhysicalValue myValue;

    public CidrValueModifier(@NotNull CidrStackFrame frame, @NotNull CidrPhysicalValue value) {
        this.myFrame = frame;
        this.myValue = value;
    }

    public void setValue(final @NotNull String expr, final @NotNull XValueModifier.XModificationCallback callback) {
        this.myFrame.getProcess().postCommand(new CidrDebugProcess.DebuggerCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                try {
                    Pair<LLValue, String> valuePair = CidrEvaluatorHelper.getInstance().convertAndEvaluate(CidrValueModifier.this.myFrame.getProcess(), driver, XExpressionImpl.fromText(expr), CidrValueModifier.this.myFrame.getSourcePosition(), CidrValueModifier.this.myFrame.getFrameNumber(), CidrValueModifier.this.myFrame.getThreadId());
                    CidrValueModifier.this.setValue(expr, valuePair, callback, driver);
                }
                catch (DBCannotEvaluateException e) {
                    callback.errorOccurred(CidrDebuggerBundle.message("debug.assign.error.cannotAssignExpression", expr, CidrValueModifier.this.myValue.getName()) + ":\n" + e.getMessage());
                    CidrDebuggerLog.LOG.info(e.getMessage());
                }
            }
        });
    }

    @NotNull
    public CidrStackFrame getFrame() {
        return this.myFrame;
    }

    @NotNull
    public CidrPhysicalValue getValue() {
        return this.myValue;
    }

    protected void setValue(final @NotNull String origExpr, @NotNull Pair<LLValue, String> valuePair, final @NotNull XValueModifier.XModificationCallback callback, @NotNull DebuggerDriver driver) throws DBCannotEvaluateException, ExecutionException {
        EvaluationContext context = this.getFrame().getProcess().getRendererFactory().createEvaluationContext(driver, null, this.getFrame());
        final String qualName = this.myValue.getEvaluationExpression(true);
        CidrEvaluator evaluator = this.myFrame.getEvaluator();
        if (evaluator == null) {
            callback.errorOccurred(CidrDebuggerBundle.message("debug.assign.error.cannotAssignExpression", origExpr, qualName));
            CidrDebuggerLog.LOG.info(this.myFrame.toString() + " has null evaluator");
            return;
        }
        String rValueStr = context.convertToRValue(this.myValue.getVar(), valuePair);
        evaluator.evaluate(qualName + "=" + rValueStr, new XDebuggerEvaluator.XEvaluationCallback(){

            public void evaluated(@NotNull XValue result) {
                callback.valueModified();
            }

            public void errorOccurred(@NotNull String errorMessage) {
                callback.errorOccurred(CidrDebuggerBundle.message("debug.assign.error.cannotAssignExpression", origExpr, qualName) + ":\n" + errorMessage);
                CidrDebuggerLog.LOG.info(errorMessage);
            }
        }, this.myFrame.getSourcePosition());
    }
}

