/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Expirable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.util.SmartList;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.ImmediateFullValueEvaluator;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XFullValueEvaluator;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XNavigatable;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.ui.XDebuggerUIConstants;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DBUserException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrErrorValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrLocalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.ValueRendererFactory;
import com.jetbrains.cidr.execution.debugger.evaluation.XValueNodeExpirable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrValue
extends XNamedValue
implements UserDataHolderEx {
    public static Key<Boolean> DO_NOT_SHOW_ADDRESSES = Key.create((String)"DO_NOT_SHOW_ADDRESSES");
    @NotNull
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();
    @NotNull
    private final CidrDebugProcess myProcess;
    @Nullable
    private final XSourcePosition myPosition;
    @NotNull
    private final CidrStackFrame myFrame;
    @NotNull
    protected final ValueRendererFactory myRenderersFactory;
    @NotNull
    private List<String> myPresentationErrors = Collections.synchronizedList(new ArrayList());

    public CidrValue(@NotNull String displayName, @NotNull CidrDebugProcess process, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame) {
        super(displayName);
        this.myProcess = process;
        this.myPosition = position;
        this.myFrame = frame;
        this.myRenderersFactory = this.getProcess().getRendererFactory();
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        this.myUserDataHolder.putUserData(key, value);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        return (T)this.myUserDataHolder.putUserDataIfAbsent(key, value);
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        return this.myUserDataHolder.replace(key, oldValue, newValue);
    }

    @NotNull
    public CidrStackFrame getFrame() {
        return this.myFrame;
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return this.myPosition;
    }

    @NotNull
    public String getEvaluationExpression() {
        return this.getEvaluationExpression(false);
    }

    @NotNull
    public String getEvaluationExpression(boolean lvalue) {
        return this.getName();
    }

    @NotNull
    public CidrDebugProcess getProcess() {
        return this.myProcess;
    }

    public void computeSourcePosition(@NotNull XNavigatable navigatable) {
        XSourcePosition position = this.getSourcePosition();
        navigatable.setSourcePosition(position == null ? null : this.doComputePosition(position));
    }

    @Nullable
    protected abstract XSourcePosition doComputePosition(@NotNull XSourcePosition var1);

    public final void computePresentation(final @NotNull XValueNode node, @NotNull XValuePlace place) {
        this.myProcess.postCommand(new CidrDebugProcess.DebuggerImplicitCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                if (node.isObsolete()) {
                    return;
                }
                boolean hasChildren = false;
                try {
                    String value;
                    String type;
                    Icon icon;
                    EvaluationContext context = CidrValue.this.getContext(driver, new XValueNodeExpirable((Obsolescent)node));
                    try {
                        hasChildren = CidrValue.this.doComputeHasChildren(context);
                        icon = CidrValue.this.doComputeIcon(context, hasChildren);
                    }
                    catch (DBUserException e) {
                        icon = XDebuggerUIConstants.ERROR_MESSAGE_ICON;
                        CidrValue.this.myPresentationErrors.add(e.getMessage());
                        hasChildren = true;
                    }
                    try {
                        type = CidrValue.this.doComputeType(context);
                        value = CidrValue.this.doComputeValue(context);
                    }
                    catch (DBUserException e) {
                        CidrErrorValue.doComputePresentation(node, e.getMessage(), hasChildren);
                        return;
                    }
                    if (value.length() > 1000) {
                        node.setFullValueEvaluator((XFullValueEvaluator)new ImmediateFullValueEvaluator(value));
                        value = value.substring(0, 1000);
                    }
                    node.setPresentation(icon, type, value, hasChildren);
                }
                catch (ExecutionException e) {
                    CidrErrorValue.doComputePresentation(node, e.getMessage(), hasChildren);
                    throw e;
                }
            }
        });
    }

    protected abstract boolean doComputeHasChildren(@NotNull EvaluationContext var1) throws ExecutionException, DBUserException;

    @Nullable
    protected abstract Icon doComputeIcon(@NotNull EvaluationContext var1, boolean var2) throws ExecutionException, DBUserException;

    @Nullable
    protected abstract String doComputeType(@NotNull EvaluationContext var1) throws ExecutionException, DBUserException;

    @NotNull
    protected abstract String doComputeValue(@NotNull EvaluationContext var1) throws ExecutionException, DBUserException;

    public final void computeChildren(@NotNull XCompositeNode node) {
        if (!this.myPresentationErrors.isEmpty()) {
            node.addChildren(CidrValue.createErrorChildren(this.myPresentationErrors), false);
        }
        this.computeValueChildren(node);
    }

    @NotNull
    protected static XValueChildrenList createErrorChildren(@NotNull List<String> errors) {
        XValueChildrenList errorNodesList = new XValueChildrenList();
        for (String each : errors) {
            errorNodesList.add((XNamedValue)new CidrErrorValue(each));
        }
        return errorNodesList;
    }

    protected abstract void computeValueChildren(@NotNull XCompositeNode var1);

    public static void addMemberValues(@NotNull Collection<LLValue> vars, @NotNull CidrPhysicalValue parent, @NotNull XCompositeNode toNode, boolean modifiable) {
        if (toNode.isObsolete()) {
            return;
        }
        SmartList values = new SmartList();
        for (LLValue each : vars) {
            values.add(new CidrMemberValue(each, parent, modifiable));
        }
        CidrValue.addAllTo((Collection<CidrValue>)values, toNode);
    }

    public static void addLocalValues(@NotNull Collection<LLValue> vars, @NotNull CidrDebugProcess process, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame, @NotNull XCompositeNode toNode) {
        if (toNode.isObsolete()) {
            return;
        }
        SmartList values = new SmartList();
        for (LLValue each : vars) {
            values.add(new CidrLocalValue(each, process, position, frame));
        }
        CidrValue.addAllTo((Collection<CidrValue>)values, toNode);
    }

    public static void addAllTo(@NotNull Collection<CidrValue> values, @NotNull XCompositeNode toNode) {
        if (toNode.isObsolete()) {
            return;
        }
        XValueChildrenList list = values.isEmpty() ? XValueChildrenList.EMPTY : new XValueChildrenList(values.size());
        for (CidrValue each : values) {
            list.add((XNamedValue)each);
        }
        toNode.addChildren(list, true);
    }

    @NotNull
    public abstract String getConsoleDescription(@NotNull EvaluationContext var1) throws ExecutionException, DBUserException;

    public EvaluationContext getContext(@NotNull DebuggerDriver driver, @Nullable Expirable expirable) {
        return this.myRenderersFactory.createEvaluationContext(driver, expirable, this.myFrame);
    }
}

