/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.evaluation;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.xdebugger.Obsolescent;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DBUserException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import com.jetbrains.cidr.execution.debugger.evaluation.EvaluationContext;
import com.jetbrains.cidr.execution.debugger.evaluation.XValueNodeExpirable;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.CachedDebuggerResult;
import com.jetbrains.cidr.execution.debugger.evaluation.renderers.ValueRenderer;
import java.util.Collections;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CidrPhysicalValue
extends CidrValue {
    public static final Key THROW_ON_TYPE = Key.create((String)"THROW_ON_TYPE");
    public static final Key THROW_ON_ICON = Key.create((String)"THROW_ON_ICON");
    public static final Key THROW_ON_VALUE = Key.create((String)"THROW_ON_VALUE");
    public static final Key THROW_ON_HAS_CHILDREN = Key.create((String)"THROW_ON_CHILDREN_COUNT");
    public static final Key THROW_ON_CHILDREN = Key.create((String)"THROW_ON_CHILDREN");
    @NotNull
    private final LLValue myVar;
    @Nullable
    private volatile LLValue myPresentationVar;
    @NotNull
    private final CachedDebuggerResult<ValueRenderer> myRendererResult = new CachedDebuggerResult();

    public CidrPhysicalValue(@NotNull LLValue var, @NotNull CidrDebugProcess process, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame) {
        this(var, var.getName(), process, position, frame);
    }

    public CidrPhysicalValue(@NotNull LLValue var, @NotNull String displayName, @NotNull CidrDebugProcess process, @Nullable XSourcePosition position, @NotNull CidrStackFrame frame) {
        super(displayName, process, position, frame);
        this.myVar = var;
    }

    @NotNull
    public ValueRenderer getPreparedRenderer() {
        ValueRenderer result = this.myRendererResult.getResultIfAvailable();
        if (result == null) {
            CidrDebuggerLog.LOG.error("renderer is not yet available");
            return new ValueRenderer(this);
        }
        return result;
    }

    @NotNull
    public ValueRenderer getRenderer(final @NotNull EvaluationContext context) throws ExecutionException, DBUserException {
        return this.myRendererResult.getResult(new CachedDebuggerResult.Calculator<ValueRenderer>(){

            @Override
            @NotNull
            public ValueRenderer calculate() throws ExecutionException, DBUserException {
                return CidrPhysicalValue.this.myRenderersFactory.createValueRenderer(context, CidrPhysicalValue.this);
            }
        });
    }

    @Override
    @NotNull
    public String getEvaluationExpression(boolean lvalue) {
        return this.myVar.getReferenceExpression();
    }

    @NotNull
    public LLValue getVar() {
        return this.myVar;
    }

    @NotNull
    public LLValue getPresentationVar() {
        return this.myPresentationVar != null ? this.myPresentationVar : this.myVar;
    }

    public void setPresentationVar(@Nullable LLValue presentationVar) {
        this.myPresentationVar = presentationVar;
    }

    public String getType() {
        return this.myVar.getBestType();
    }

    @Override
    @Nullable
    protected String doComputeType(@NotNull EvaluationContext context) throws ExecutionException, DBUserException {
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_TYPE);
        String type = this.getRenderer(context).getDisplayType();
        if (this.myVar.isPointer() && this.getProcess().getProject().getUserData(DO_NOT_SHOW_ADDRESSES) != Boolean.TRUE) {
            type = type + " | " + this.myVar.getReadablePointer();
        }
        return type;
    }

    @Override
    @NotNull
    protected String doComputeValue(@NotNull EvaluationContext context) throws ExecutionException, DBUserException {
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_VALUE);
        return this.getRenderer(context).computeValue(context);
    }

    @Override
    protected boolean doComputeHasChildren(@NotNull EvaluationContext context) throws ExecutionException, DBUserException {
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_HAS_CHILDREN);
        return this.getRenderer(context).computeHasChildren(context);
    }

    @Override
    @Nullable
    protected Icon doComputeIcon(@NotNull EvaluationContext context, boolean hasChildren) throws ExecutionException, DBUserException {
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_ICON);
        return this.getRenderer(context).getIcon(hasChildren);
    }

    @Override
    public final void computeValueChildren(final @NotNull XCompositeNode node) {
        this.getProcess().postCommand(new CidrDebugProcess.DebuggerImplicitCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                if (node.isObsolete()) {
                    return;
                }
                try {
                    ThrowInTest.doThrow((UserDataHolder)CidrPhysicalValue.this, THROW_ON_CHILDREN);
                    EvaluationContext context = CidrPhysicalValue.this.getContext(driver, new XValueNodeExpirable((Obsolescent)node));
                    CidrPhysicalValue.this.getRenderer(context).computeChildren(context, node);
                }
                catch (DBUserException e) {
                    node.addChildren(CidrValue.createErrorChildren(Collections.singletonList(e.getMessage())), true);
                }
                catch (ExecutionException e) {
                    node.addChildren(CidrValue.createErrorChildren(Collections.singletonList(e.getMessage())), true);
                    throw e;
                }
            }
        });
    }

    @Override
    @NotNull
    public String getConsoleDescription(@NotNull EvaluationContext context) throws ExecutionException, DBUserException {
        return this.getRenderer(context).getConsoleDescription(context).toString();
    }

    @NotNull
    public CidrDebuggerTypesHelper getTypesHelper() {
        return this.getProcess().getTypesHelper();
    }

    public String toString() {
        return this.getVar().toString();
    }

    public boolean isNSObject() {
        return this.getVar().isNSObject();
    }

    public boolean isSwift() {
        return this.getFrame().getFrame().getLanguage() == DebuggerDriver.StandardDebuggerLanguage.SWIFT;
    }

    public boolean isSwiftOptional() {
        return this.isSwift() && CidrDebuggerTypesHelper.unwrapSwiftOptionalType(this.getType()) != null;
    }
}

