/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.breakpoints;

import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.breakpoints.XBreakpointProperties;
import com.intellij.xdebugger.breakpoints.XBreakpointType;
import com.intellij.xdebugger.breakpoints.ui.XBreakpointCustomPropertiesPanel;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrWatchpointPropertiesPanel;
import icons.CidrDebuggerIcons;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrWatchpointType
extends XBreakpointType<XBreakpoint<CidrWatchpointProperties>, CidrWatchpointProperties> {
    protected CidrWatchpointType() {
        super("CidrWatchpoint", "Watchpoints");
    }

    @NotNull
    public Icon getEnabledIcon() {
        return CidrDebuggerIcons.Watchpoint;
    }

    @NotNull
    public Icon getDisabledIcon() {
        return CidrDebuggerIcons.Watchpoint_disabled;
    }

    @NotNull
    public Icon getInactiveDependentIcon() {
        return CidrDebuggerIcons.Watchpoint_dependent;
    }

    @Nullable
    public CidrWatchpointProperties createProperties() {
        return null;
    }

    public XSourcePosition getSourcePosition(@NotNull XBreakpoint<CidrWatchpointProperties> breakpoint) {
        CidrWatchpointProperties properties = (CidrWatchpointProperties)breakpoint.getProperties();
        return properties != null ? properties.getSourcePosition() : null;
    }

    public String getDisplayText(XBreakpoint<CidrWatchpointProperties> breakpoint) {
        CidrWatchpointProperties properties = (CidrWatchpointProperties)breakpoint.getProperties();
        if (properties != null) {
            return properties.getLLValue().getName() + " (Access Type: \"" + (Object)((Object)properties.getAccessType()) + "\"" + (properties.getLifetime() == null ? "" : ", Life Time: \"" + (Object)((Object)properties.getLifetime()) + "\"") + ")";
        }
        return "Obsolete watchpoint, please remove";
    }

    public XBreakpointCustomPropertiesPanel<XBreakpoint<CidrWatchpointProperties>> createCustomPropertiesPanel(@NotNull Project project2) {
        return new CidrWatchpointPropertiesPanel(project2);
    }

    public static class CidrWatchpointProperties
    extends XBreakpointProperties<CidrWatchpointState> {
        private LLWatchpoint.AccessType myAccessType;
        private LLWatchpoint.Lifetime myLifetime;
        private LLValue myLLValue;
        private String myExpr;
        private XSourcePosition myOriginalPosition;
        private CidrDebugProcess myDebugProcess;
        @Nullable
        private String myError;

        public LLWatchpoint.AccessType getAccessType() {
            return this.myAccessType;
        }

        public void setAccessType(LLWatchpoint.AccessType accessType) {
            this.myAccessType = accessType;
        }

        @Nullable
        public LLWatchpoint.Lifetime getLifetime() {
            return this.myLifetime;
        }

        public void setLifetime(@Nullable LLWatchpoint.Lifetime lifetime) {
            this.myLifetime = lifetime;
        }

        public XSourcePosition getSourcePosition() {
            return this.myOriginalPosition;
        }

        public CidrWatchpointState getState() {
            return new CidrWatchpointState();
        }

        public void loadState(CidrWatchpointState state) {
        }

        public void setDebugProcess(@Nullable CidrDebugProcess debugProcess) {
            this.myDebugProcess = debugProcess;
        }

        public CidrDebugProcess getDebugProcess() {
            return this.myDebugProcess;
        }

        public void setOriginalPosition(XSourcePosition originalPosition) {
            this.myOriginalPosition = originalPosition;
        }

        @Nullable
        public String getError() {
            return this.myError;
        }

        public void setError(@Nullable String error) {
            this.myError = error;
        }

        public LLValue getLLValue() {
            return this.myLLValue;
        }

        public void setLLValue(LLValue value) {
            this.myLLValue = value;
        }

        public String getExpr() {
            return this.myExpr;
        }

        public void setExpr(String expr) {
            this.myExpr = expr;
        }

        public static class CidrWatchpointState {
        }
    }
}

