/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.lldb;

import com.google.protobuf.GeneratedMessage;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.OSProcessHandler;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.CidrExecUtil;
import com.jetbrains.cidr.execution.ExecutionResult;
import com.jetbrains.cidr.execution.GLogOutputReaders;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectFramesException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectVariablesException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotLoadVariableException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotSetBreakpointException;
import com.jetbrains.cidr.execution.debugger.backend.DBEvaluationTimedOutException;
import com.jetbrains.cidr.execution.debugger.backend.DBFatalException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriverException;
import com.jetbrains.cidr.execution.debugger.backend.lldb.ProtobufMessageFactory;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Broadcasts;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Model;
import com.jetbrains.cidr.execution.debugger.backend.lldb.auto_generated.Protocol;
import com.jetbrains.cidr.execution.debugger.backend.lldb.lang.LLDBLanguage;
import com.jetbrains.cidr.execution.ipcUtils.ProtobufServer;
import com.jetbrains.cidr.execution.ipcUtils.ProtobufTimeoutException;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLDBDriver
extends DebuggerDriver
implements Consumer<GeneratedMessage> {
    public static final Logger LOG = Logger.getInstance(LLDBDriver.class);
    private static Model.DynamicValuesPolicy DEFAULT_DYNAMIC_VALUES_POLICY = Model.DynamicValuesPolicy.DynamicValuesPolicyCanRunTarget;
    public static Key<Boolean> ENABLE_STL_RENDERERS = Key.create((String)"LLDBDriver.synthethicsEnabled");
    public static final String NO_RESULT = "<no result>";
    private static final int MAX_CHILDREN_COUNT_TO_DISPLAY = 100;
    private volatile boolean myRemote;
    @Nullable
    private volatile String myArchitectureId;
    private GeneralCommandLine myLLDBCommandLine;
    private OSProcessHandler myLLDBFrontendHandler;
    private final ExecutionResult<ProtobufServer<Protocol.CompositeResponse>> myConnectedClient = new ExecutionResult();
    private final Set<Integer> myTemporaryBreakpoints = new HashSet<Integer>();
    private ProcessInputWriter myProcessInputHandler = new ProcessInputWriter();
    private Integer myAsyncAttachingTo;
    private int myStoppedThreadIndex;
    private final DebuggerDriverConfiguration myStarter;
    private Model.DynamicValuesPolicy myDynamicValuesPolicy = DEFAULT_DYNAMIC_VALUES_POLICY;
    private boolean myValuesFilteringEnabled;
    private ProtobufServer<Protocol.CompositeResponse> myProtobufServer;
    private final GLogOutputReaders myGLogOutputReaders;
    private final AtomicReference<DBFatalException> myAsyncFatalException = new AtomicReference();
    private boolean myReadyForCommand = false;

    private void dispatchInput(String input, Model.DispatchTarget target) throws com.intellij.execution.ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.dispatchInput(input, target);
        this.getProtobufClient().sendMessage(request, Protocol.DispatchInput_Res.class, new Consumer<Protocol.DispatchInput_Res>(){

            public void consume(Protocol.DispatchInput_Res dispatchInput_res) {
            }
        }, null);
    }

    protected ProtobufServer<Protocol.CompositeResponse> getProtobufClient() throws com.intellij.execution.ExecutionException {
        this.throwAsyncFatalException();
        return this.myConnectedClient.get();
    }

    protected ProtobufServer<Protocol.CompositeResponse> getProtobufClient(long timeout) throws com.intellij.execution.ExecutionException {
        try {
            this.throwAsyncFatalException();
            return this.myConnectedClient.get(timeout, TimeUnit.SECONDS);
        }
        catch (TimeoutException e) {
            throw new DBFatalException("LLDB connection timeout", e);
        }
    }

    private void storeAsyncFatalException(DBFatalException e) {
        this.myAsyncFatalException.compareAndSet(null, e);
    }

    private void throwAsyncFatalException() throws DBFatalException {
        DBFatalException exception = this.myAsyncFatalException.get();
        if (exception != null) {
            this.myAsyncFatalException.compareAndSet(exception, null);
            throw new DBFatalException((Throwable)((Object)exception));
        }
    }

    public LLDBDriver(DebuggerDriver.Handler handler2, DebuggerDriverConfiguration starter) {
        super(handler2);
        this.myStarter = starter;
        File logdir = new File(ApplicationManager.getApplication().isUnitTestMode() ? PathManager.getSystemPath() + "/testlog" : PathManager.getLogPath());
        this.myGLogOutputReaders = new GLogOutputReaders(logdir, "LLDBFrontend"){

            @Override
            protected void onTextAvailable(@NotNull String text, @NotNull GLogOutputReaders.LogType type) {
                LOG.debug(text);
            }
        };
    }

    @Override
    public boolean supportsWatchpointLifetime() {
        return false;
    }

    @Override
    @NotNull
    public Language getConsoleLanguage() {
        return LLDBLanguage.INSTANCE;
    }

    @Override
    @NotNull
    public ProcessHandler getProcessHandler() {
        return this.myLLDBFrontendHandler;
    }

    @Override
    public boolean isInPromptMode() {
        return false;
    }

    public int getPort() {
        return this.myProtobufServer.getPort();
    }

    public Model.DynamicValuesPolicy getDynamicValuesPolicy() {
        return this.myDynamicValuesPolicy;
    }

    public void setDynamicValuesPolicy(Model.DynamicValuesPolicy dynamicValuesPolicy) {
        this.myDynamicValuesPolicy = dynamicValuesPolicy;
    }

    @Override
    public void start(@NotNull Installer installer, @Nullable String architecture) throws com.intellij.execution.ExecutionException {
        this.myInstaller = installer;
        this.myArchitectureId = architecture;
        try {
            this.myProtobufServer = new ProtobufServer<Protocol.CompositeResponse>((Consumer)this, (ProtobufServer.ProtobufParser)new ProtobufServer.ProtobufParser<Protocol.CompositeResponse>(){

                @Override
                public Protocol.CompositeResponse parse(byte[] buffer) throws IOException {
                    return Protocol.CompositeResponse.parseFrom(buffer);
                }

                @Override
                public boolean decompose(GeneratedMessage response) {
                    return response instanceof Protocol.CompositeResponse || response instanceof Broadcasts.CompositeBroadcast;
                }
            }){

                @Override
                protected void handleIOException(IOException e) {
                    CidrDebuggerLog.LOG.warn((Throwable)e);
                    if (!LLDBDriver.this.myConnectedClient.isDone()) {
                        LLDBDriver.this.myConnectedClient.setException(e);
                    } else {
                        LLDBDriver.this.storeAsyncFatalException(new DBFatalException(e));
                    }
                }
            };
        }
        catch (IOException e) {
            throw new com.intellij.execution.ExecutionException((Throwable)e);
        }
        this.myLLDBCommandLine = this.myStarter.createDriverCommandLine(this, installer);
        Map environment = this.myLLDBCommandLine.getEnvironment();
        environment.put("GLOG_log_dir", this.myGLogOutputReaders.getLogDir().getPath());
        if (LOG.isDebugEnabled()) {
            environment.put("GLOG_minloglevel", "0");
            environment.put("GLOG_logbufsecs", "0");
            environment.put("GLOG_v", "1");
            this.myGLogOutputReaders.init();
        } else {
            environment.put("GLOG_minloglevel", "2");
        }
        this.myLLDBFrontendHandler = new LLDBProcessHandler(this.myLLDBCommandLine);
        this.myLLDBFrontendHandler.setShouldDestroyProcessRecursively(false);
        this.myLLDBFrontendHandler.addProcessListener((ProcessListener)new ProcessAdapter(){
            final StringBuilder errOut = new StringBuilder();

            public void processTerminated(ProcessEvent event) {
                CidrExecUtil.checkErrorOnTermination(this.errOut, LLDBDriver.this.myConnectedClient);
                LLDBDriver.this.readOutputFully();
                LLDBDriver.this.closeOutputReaders();
                LLDBDriver.this.myProcessInputHandler.close();
                LLDBDriver.this.handleExited(event.getExitCode());
            }

            public void onTextAvailable(ProcessEvent event, Key outputType) {
                super.onTextAvailable(event, outputType);
                if (outputType == ProcessOutputTypes.STDERR) {
                    this.errOut.append(event.getText());
                }
            }
        });
    }

    @Override
    protected void readOutputFully() {
        super.readOutputFully();
        this.myGLogOutputReaders.readFully();
    }

    @Override
    protected void closeOutputReaders() {
        super.closeOutputReaders();
        this.myGLogOutputReaders.close();
    }

    @Override
    public void setValuesFilteringEnabled(boolean enabled) throws com.intellij.execution.ExecutionException {
        if (this.myValuesFilteringEnabled == enabled) {
            return;
        }
        this.myValuesFilteringEnabled = enabled;
        LLDBDriver.doSetValuesFilteringEnabled(enabled, this.getProtobufClient());
    }

    private static void doSetValuesFilteringEnabled(boolean enabled, ProtobufServer<Protocol.CompositeResponse> client) throws com.intellij.execution.ExecutionException {
        client.sendMessageAndWaitForReply(ProtobufMessageFactory.setValuesFilteringEnabled(enabled), Protocol.ValuesFilteringPolicy_Res.class, new ThrowIfNotValid("couldn't set values filtering policy"));
    }

    @Override
    public void loadForLaunch() throws com.intellij.execution.ExecutionException {
        this.myTargetCommandLine = this.myInstaller.install();
        this.sendCreateTargetRequest(ProtobufMessageFactory.createTarget(this.myInstaller.getExecutableFile().getPath(), StringUtil.notNullize((String)this.myArchitectureId)));
    }

    @Override
    public void loadForAttach() throws com.intellij.execution.ExecutionException {
        this.sendCreateTargetRequest(ProtobufMessageFactory.createTarget("", ""));
    }

    @Override
    public void loadForRemote(File deviceSupport) throws com.intellij.execution.ExecutionException {
        this.myRemote = true;
        this.myTargetCommandLine = this.myInstaller.install();
        String exePath = this.myInstaller.getExecutableFile().getPath();
        String remoteExePath = this.myTargetCommandLine.getExePath();
        CidrDebuggerLog.LOG.debug("creating remote target: exepath: " + exePath + " remotePath: " + remoteExePath + " arch: " + StringUtil.notNullize((String)this.myArchitectureId));
        this.sendCreateTargetRequest(ProtobufMessageFactory.createRemoteTarget(exePath, StringUtil.notNullize((String)this.myArchitectureId), "remote-ios", new File(deviceSupport, "Symbols"), remoteExePath));
        this.addShlibPathSubstitutions(DebuggerDriver.getShlibPathSubstitutions(this.myInstaller.getExecutableFile().getParentFile().getParent(), new File(this.myTargetCommandLine.getExePath()).getParentFile().getParent(), deviceSupport));
    }

    protected void sendCreateTargetRequest(@NotNull Protocol.CompositeRequest createTargetRequest) throws com.intellij.execution.ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't create target");
        this.getProtobufClient().sendMessageAndWaitForReply(createTargetRequest, Protocol.CreateTarget_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    @Override
    public void launch() throws com.intellij.execution.ExecutionException {
        Protocol.CompositeRequest launchReq;
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't launch process");
        assert (this.myTargetCommandLine != null) : "Not Installed";
        String debugserverSocket = this.getDebugServerSocket();
        CidrDebuggerLog.LOG.assertTrue(debugserverSocket != null || !this.myRemote);
        if (!this.myRemote) {
            File tmpDir;
            if (this.myToRedirect) {
                this.initReaders(!SystemInfo.isWindows);
            }
            String stdoutPath = this.myReaders != null ? this.myReaders.getOutFileAbsolutePath() : null;
            String stderrPath = this.myReaders != null ? this.myReaders.getErrFileAbsolutePath() : null;
            try {
                tmpDir = FileUtil.createTempDirectory((String)"process_pipe_dir", null);
            }
            catch (IOException e) {
                throw new LLDBDriverException(CidrDebuggerBundle.message("debug.lldb.cannotCreatePipe", new Object[0]));
            }
            this.myProcessInputHandler.initPipeInput(tmpDir, "process_pipe");
            launchReq = ProtobufMessageFactory.launch(this.myTargetCommandLine, new File(tmpDir, "process_pipe").getAbsolutePath(), stdoutPath, stderrPath);
        } else {
            this.myProcessInputHandler.initDispatchInput();
            launchReq = ProtobufMessageFactory.remoteLaunch(this.myInstaller.getExecutableFile().getAbsolutePath(), this.myTargetCommandLine, debugserverSocket);
        }
        this.printTargetCommandLine(this.myTargetCommandLine);
        this.getProtobufClient().sendMessageAndWaitForReply(launchReq, Protocol.Launch_Res.class, responseHandler);
        if (this.myRemote && !responseHandler.isValid() && CidrDebuggerBundle.message("debug.lldb.lockedDeviceResponse", new Object[0]).equals(responseHandler.getMessage())) {
            throw new LLDBDriverException(CidrDebuggerBundle.message("debug.lldb.lockedDeviceUserMessage", ApplicationNamesInfo.getInstance().getProductName()));
        }
        responseHandler.throwIfNeeded();
        this.handlePrompt();
    }

    @Override
    public void attachTo(int pid) throws com.intellij.execution.ExecutionException {
        this.myAsyncAttachingTo = pid;
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't attach to process");
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.attach(pid), Protocol.Attach_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
        this.handlePrompt();
    }

    @Override
    public void attachByName(String name, boolean wait) throws com.intellij.execution.ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't attach to process");
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.attachByName(name, wait), Protocol.AttachByName_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
        this.handlePrompt();
    }

    @Override
    public void detach() throws com.intellij.execution.ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't detach process");
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.detach(), Protocol.Detach_Res.class, responseHandler);
        if (!responseHandler.isValid() && !"Sending disconnect packet failed.".equals(responseHandler.getMessage())) {
            responseHandler.throwIfNeeded();
        }
        this.handleDetached();
    }

    @Override
    public boolean interrupt() throws com.intellij.execution.ExecutionException {
        final Ref result = new Ref();
        Protocol.CompositeRequest req = ProtobufMessageFactory.suspend();
        this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.Suspend_Res.class, (Consumer<Protocol.CompositeResponse>)new Consumer<Protocol.Suspend_Res>(){

            public void consume(Protocol.Suspend_Res suspend_res) {
                result.set((Object)suspend_res.getCommonResponse().getIsValid());
            }
        });
        return result.isNull() ? false : (Boolean)result.get();
    }

    @Override
    public boolean resume() throws com.intellij.execution.ExecutionException {
        final boolean[] res = new boolean[1];
        Protocol.CompositeRequest resume = ProtobufMessageFactory.resume();
        this.getProtobufClient().sendMessageAndWaitForReply(resume, Protocol.Continue_Res.class, (Consumer<Protocol.CompositeResponse>)new Consumer<Protocol.Continue_Res>(){

            public void consume(Protocol.Continue_Res continue_res) {
                res[0] = continue_res.getCommonResponse().getIsValid();
            }
        });
        return res[0];
    }

    @Override
    public void stepOver() throws com.intellij.execution.ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Error stepping over");
        Protocol.CompositeRequest request = ProtobufMessageFactory.stepOver(this.myStoppedThreadIndex);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.StepOver_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    @Override
    public void stepInto() throws com.intellij.execution.ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Error stepping into");
        Protocol.CompositeRequest request = ProtobufMessageFactory.stepInto(this.myStoppedThreadIndex);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.StepInto_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    @Override
    public void stepOut() throws com.intellij.execution.ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Error stepping out");
        Protocol.CompositeRequest request = ProtobufMessageFactory.stepOut(this.myStoppedThreadIndex);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.StepOut_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runTo(String path, int line) throws com.intellij.execution.ExecutionException {
        Set<Integer> set = this.myTemporaryBreakpoints;
        synchronized (set) {
            try {
                List<LLBreakpoint> breakpoints = this.addBreakpoint(path, line);
                for (LLBreakpoint breakpoint : breakpoints) {
                    this.myTemporaryBreakpoints.add(breakpoint.getId());
                }
            }
            catch (DBCannotSetBreakpointException e) {
                throw new com.intellij.execution.ExecutionException("Cannot set a breakpoint", (Throwable)e);
            }
            if (!this.resume()) {
                throw new com.intellij.execution.ExecutionException("Couldn't resume program");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeTemporaryBreakpoints() throws com.intellij.execution.ExecutionException {
        Set<Integer> set = this.myTemporaryBreakpoints;
        synchronized (set) {
            for (int num : this.myTemporaryBreakpoints) {
                Protocol.CompositeRequest request = LLDBDriver.createRemoveBreakpointRequest(num);
                this.getProtobufClient().sendMessage(request, Protocol.RemoveBreakpoint_Res.class, new Consumer<Protocol.RemoveBreakpoint_Res>(){

                    public void consume(Protocol.RemoveBreakpoint_Res res) {
                        if (!res.getCommonResponse().getIsValid()) {
                            CidrDebuggerLog.LOG.error("Couldn't remove breakpoint. error: " + res.getCommonResponse().getErrorMessage());
                        }
                    }
                }, null);
            }
            this.myTemporaryBreakpoints.clear();
        }
    }

    @Override
    public boolean abort() throws com.intellij.execution.ExecutionException {
        final Ref toThrow = Ref.create();
        final Ref abort = Ref.create((Object)false);
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.kill(), Protocol.Kill_Res.class, (Consumer<Protocol.CompositeResponse>)new Consumer<Protocol.Kill_Res>(){

            public void consume(Protocol.Kill_Res res) {
                Protocol.CommonResponse commonResponse = res.getCommonResponse();
                if (commonResponse.getIsValid()) {
                    abort.set((Object)true);
                } else {
                    String errorMessage = commonResponse.getErrorMessage();
                    if ("process not exist".equals(errorMessage)) {
                        abort.set((Object)false);
                    } else {
                        if (StringUtil.isEmptyOrSpaces((String)errorMessage)) {
                            errorMessage = "Failed to abort process";
                        }
                        toThrow.set((Object)new LLDBDriverException(errorMessage));
                    }
                }
            }
        });
        return (Boolean)abort.get();
    }

    @Override
    @NotNull
    public LLWatchpoint addWatchpoint(int threadId, int frameNumber, LLValue value, String expr, LLWatchpoint.Lifetime lifetime, LLWatchpoint.AccessType accessType) throws com.intellij.execution.ExecutionException, DBCannotSetBreakpointException {
        final String expression = value.getReferenceExpression();
        Protocol.CompositeRequest request = ProtobufMessageFactory.addWatchpoint(LLDBDriver.valId(value), null, accessType == LLWatchpoint.AccessType.ANY || accessType == LLWatchpoint.AccessType.READ, accessType == LLWatchpoint.AccessType.ANY || accessType == LLWatchpoint.AccessType.WRITE, true);
        final Ref result = Ref.create(null);
        final Ref toThrow = Ref.create(null);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.AddWatchpoint_Res.class, (Consumer<Protocol.CompositeResponse>)new Consumer<Protocol.AddWatchpoint_Res>(){

            public void consume(Protocol.AddWatchpoint_Res res) {
                if (!res.getCommonResponse().getIsValid()) {
                    toThrow.set((Object)new DBCannotSetBreakpointException(res.getCommonResponse().getErrorMessage()));
                } else {
                    result.set((Object)new LLWatchpoint(res.getWatchpointId(), expression));
                }
            }
        });
        if (result.isNull()) {
            throw (DBCannotSetBreakpointException)toThrow.get();
        }
        return (LLWatchpoint)result.get();
    }

    @Override
    @NotNull
    public List<LLBreakpoint> addBreakpoint(final String path, final int line, final @Nullable String condition) throws com.intellij.execution.ExecutionException {
        Protocol.CompositeRequest req = ProtobufMessageFactory.addBreakpoint(path, line + 1, condition);
        final Ref result = new Ref();
        this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.AddBreakpoint_Res.class, (Consumer<Protocol.CompositeResponse>)new Consumer<Protocol.AddBreakpoint_Res>(){

            public void consume(Protocol.AddBreakpoint_Res res) {
                result.set((Object)new LLBreakpoint(res.getId(), path, line, false, condition, null));
            }
        });
        return result.isNull() ? Collections.emptyList() : Collections.singletonList(result.get());
    }

    @Override
    @NotNull
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull DebuggerDriver.SymbolicBreakpoint symBreakpoint) throws com.intellij.execution.ExecutionException, DBCannotSetBreakpointException {
        Protocol.CompositeRequest req = ProtobufMessageFactory.addBreakpoint(symBreakpoint.getPattern(), symBreakpoint.isRegexpPattern(), symBreakpoint.getModule(), symBreakpoint.getCondition(), symBreakpoint.getThreadId());
        final Ref result = new Ref();
        this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.AddBreakpoint_Res.class, (Consumer<Protocol.CompositeResponse>)new Consumer<Protocol.AddBreakpoint_Res>(){

            public void consume(Protocol.AddBreakpoint_Res res) {
                result.set((Object)new LLSymbolicBreakpoint(res.getId()));
            }
        });
        return (LLSymbolicBreakpoint)result.get();
    }

    @Override
    public void removeCodepoints(@NotNull Collection<Integer> ids) throws com.intellij.execution.ExecutionException {
        for (Integer each : ids) {
            ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't remove breakpoint");
            Protocol.CompositeRequest req = LLDBDriver.createRemoveBreakpointRequest(each);
            this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.RemoveBreakpoint_Res.class, responseHandler);
            responseHandler.throwIfNeeded();
        }
    }

    private static Protocol.CompositeRequest createRemoveBreakpointRequest(int num) {
        return ProtobufMessageFactory.removeBreakpoint(num);
    }

    @NotNull
    protected LLFrame newLLFrame(@NotNull Model.LLDBFrame frame) {
        String sourceFilePath = frame.getFile();
        if (sourceFilePath != null) {
            sourceFilePath = FileUtil.toCanonicalPath((String)this.myStarter.convertPath(sourceFilePath), (boolean)true);
        }
        return new LLFrame(frame.getNumber(), frame.getFunction(), sourceFilePath, frame.getLine() - 1, frame.getPc(), LLDBDriver.convertLanguage(frame.getLanguage()));
    }

    @Nullable
    protected static DebuggerDriver.DebuggerLanguage convertLanguage(@Nullable Model.Language language) {
        if (language != null) {
            switch (language) {
                case LanguageC: 
                case LanguageC89: 
                case LanguageC99: 
                case LanguageC11: {
                    return DebuggerDriver.StandardDebuggerLanguage.C;
                }
                case LanguageC_plus_plus: 
                case LanguageC_plus_plus_03: 
                case LanguageC_plus_plus_11: 
                case LanguageC_plus_plus_14: {
                    return DebuggerDriver.StandardDebuggerLanguage.C_PLUS_PLUS;
                }
                case LanguageObjC: {
                    return DebuggerDriver.StandardDebuggerLanguage.OBJC;
                }
                case LanguageObjC_plus_plus: {
                    return DebuggerDriver.StandardDebuggerLanguage.OBJC_PLUS_PLUS;
                }
                case LanguageSwift: {
                    return DebuggerDriver.StandardDebuggerLanguage.SWIFT;
                }
            }
            return null;
        }
        return null;
    }

    @Nullable
    private static Model.Language convertLanguage(@Nullable DebuggerDriver.DebuggerLanguage language) throws DBCannotEvaluateException {
        if (language == null) {
            return null;
        }
        if (language instanceof DebuggerDriver.StandardDebuggerLanguage) {
            switch ((DebuggerDriver.StandardDebuggerLanguage)language) {
                case C: {
                    return Model.Language.LanguageC;
                }
                case C_PLUS_PLUS: {
                    return Model.Language.LanguageC_plus_plus;
                }
                case OBJC: {
                    return Model.Language.LanguageObjC;
                }
                case OBJC_PLUS_PLUS: {
                    return Model.Language.LanguageObjC_plus_plus;
                }
                case SWIFT: {
                    return Model.Language.LanguageSwift;
                }
            }
        }
        throw new DBCannotEvaluateException(language.toString() + " is not supported by LLDB");
    }

    @Override
    @NotNull
    public List<LLFrame> getFrames(int threadId, boolean untilValidLineEntry) throws com.intellij.execution.ExecutionException, DBCannotCollectFramesException {
        final ArrayList<LLFrame> result = new ArrayList<LLFrame>();
        Protocol.CompositeRequest request = ProtobufMessageFactory.getFrames(threadId, untilValidLineEntry);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.GetFrames_Res.class, new Consumer<Protocol.GetFrames_Res>(){

            public void consume(Protocol.GetFrames_Res getFrames_res) {
                for (Model.LLDBFrame frame : getFrames_res.getFramesList()) {
                    result.add(LLDBDriver.this.newLLFrame(frame));
                }
            }
        }, Integer.MAX_VALUE);
        return result;
    }

    @Override
    @NotNull
    public List<LLValue> getVariables(int threadId, int frameNumber) throws com.intellij.execution.ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.getLocals(threadId, frameNumber);
        final ArrayList<LLValue> result = new ArrayList<LLValue>();
        final Ref errorMessage = new Ref();
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.GetLocals_Res.class, new Consumer<Protocol.GetLocals_Res>(){

            public void consume(Protocol.GetLocals_Res res) {
                Protocol.CommonResponse commonResponse = res.getCommonResponse();
                if (!commonResponse.getIsValid()) {
                    String message = commonResponse.getErrorMessage();
                    if (message != null) {
                        errorMessage.set((Object)message);
                    }
                } else {
                    List<Model.LLDBValue> valuesList = res.getValuesList();
                    for (Model.LLDBValue lldbValue : valuesList) {
                        result.add(LLDBDriver.convertValue(lldbValue, null));
                    }
                }
            }
        }, 0L);
        if (!errorMessage.isNull() && !StringUtil.isEmpty((String)((String)errorMessage.get()))) {
            throw new com.intellij.execution.ExecutionException((String)errorMessage.get());
        }
        return result;
    }

    @NotNull
    public String getObjectDescription(LLValue value, int length) throws DBCannotEvaluateException, com.intellij.execution.ExecutionException {
        Protocol.CompositeRequest req = ProtobufMessageFactory.getObjectDescription(LLDBDriver.valId(value), length);
        final Ref description = Ref.create();
        final Ref exception = Ref.create();
        this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.GetObjectDescription_Res.class, (Consumer<Protocol.CompositeResponse>)new Consumer<Protocol.GetObjectDescription_Res>(){

            public void consume(Protocol.GetObjectDescription_Res res) {
                Protocol.CommonResponse commonResponse = res.getCommonResponse();
                if (!commonResponse.getIsValid()) {
                    exception.set((Object)new DBCannotEvaluateException(commonResponse.getErrorMessage()));
                    return;
                }
                description.set((Object)res.getDescription());
            }
        });
        if (!exception.isNull()) {
            throw (DBCannotEvaluateException)exception.get();
        }
        return (String)description.get();
    }

    @Override
    @NotNull
    public List<LLValue> getVariableChildren(LLValue var) throws com.intellij.execution.ExecutionException, DBCannotCollectVariablesException {
        return this.getVariableChildrenRange(var, 0, this.getChildrenCount(var));
    }

    @Override
    @NotNull
    public List<LLValue> getVariableChildrenRange(LLValue var, int offset, int count) throws com.intellij.execution.ExecutionException, DBCannotCollectVariablesException {
        if (this.getChildrenCount(var, 1) == 0) {
            return Collections.emptyList();
        }
        CidrDebuggerLog.LOG.assertTrue(count <= 100, (Object)("Too many children to request: " + count));
        Protocol.CompositeRequest request = ProtobufMessageFactory.getValueChildren(LLDBDriver.valId(var), offset, count);
        final Ref errorMessage = new Ref();
        final ArrayList<LLValue> result = new ArrayList<LLValue>();
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.GetValueChildren_Res.class, new Consumer<Protocol.GetValueChildren_Res>(){

            public void consume(Protocol.GetValueChildren_Res res) {
                boolean isValid = res.getCommonResponse().getIsValid();
                if (!isValid) {
                    errorMessage.set((Object)res.getCommonResponse().getErrorMessage());
                } else {
                    List<Model.LLDBValue> valuesList = res.getValuesList();
                    LLDBDriver.convertList(valuesList, result);
                }
            }
        }, 0L);
        String message = (String)errorMessage.get();
        if (message != null) {
            throw new DBCannotCollectVariablesException(message);
        }
        return result;
    }

    @Override
    public void addSymbolsFile(File dSYM, File module2) throws com.intellij.execution.ExecutionException {
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.handleConsoleCommand(-1, -1, "target module add \"" + module2.getAbsolutePath() + "\""), Protocol.HandleConsoleCommand_Res.class, new ThrowIfNotValid("couldn't add module: " + module2.getAbsolutePath()));
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.handleConsoleCommand(-1, -1, "target symbols add \"" + dSYM.getAbsolutePath() + "\""), Protocol.HandleConsoleCommand_Res.class, new ThrowIfNotValid("couldn't add dSYM: " + dSYM.getAbsolutePath()));
    }

    @Override
    public boolean isStructType(LLValue var) {
        return var.isStruct();
    }

    private static void convertList(List<Model.LLDBValue> valuesList, List<LLValue> result) {
        for (Model.LLDBValue val : valuesList) {
            LLValue value = LLDBDriver.convertValue(val, null);
            result.add(value);
        }
    }

    private static int valId(LLValue var) {
        return Integer.parseInt(var.getId());
    }

    public List<LLValue> arraySlice(LLValue var, int offset, int count) throws com.intellij.execution.ExecutionException, DBCannotEvaluateException, DBCannotCollectVariablesException {
        final Ref errorMessage = Ref.create((Object)"unknown error");
        final ArrayList<LLValue> vals = new ArrayList<LLValue>();
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.arraySlice(LLDBDriver.valId(var), offset, count), Protocol.GetArraySlice_Res.class, (Consumer<Protocol.CompositeResponse>)new Consumer<Protocol.GetArraySlice_Res>(){

            public void consume(Protocol.GetArraySlice_Res res) {
                if (!res.getCommonResponse().getIsValid()) {
                    String message = res.getCommonResponse().getErrorMessage();
                    if (message != null) {
                        errorMessage.set((Object)message);
                    }
                    return;
                }
                errorMessage.set(null);
                LLDBDriver.convertList(res.getValuesList(), vals);
            }
        });
        if (!errorMessage.isNull()) {
            throw new DBCannotCollectVariablesException((String)errorMessage.get());
        }
        return vals;
    }

    private static LLValue convertValue(Model.LLDBValue value, @Nullable String expression) {
        LLValue.TypeClass typeClass;
        boolean isNSObject = value.getIsOcObject() != 0;
        String readableValue = isNSObject ? StringUtil.notNullize((String)value.getValue()) : StringUtil.nullize((String)LLDBDriver.unescapeString(value.getSummary()));
        switch (value.getTypeClass()) {
            case TypeClassReference: {
                typeClass = LLValue.TypeClass.REFERENCE;
                break;
            }
            case TypeClassFunction: {
                typeClass = LLValue.TypeClass.FUNCTION;
                break;
            }
            case TypeClassBuiltin: {
                typeClass = LLValue.TypeClass.BUILTIN;
                break;
            }
            default: {
                typeClass = null;
            }
        }
        return new LLValue(String.valueOf(value.getId()), expression == null ? value.getName() : expression, value.getType(), null, value.getValue(), LLValue.Kind.EVALUATED, -1, isNSObject, readableValue, value.getName(), value.getTypeClass() == Model.TypeClass.TypeClassStruct, typeClass);
    }

    @Override
    @NotNull
    public LLValue evaluate(int threadId, int frameNumber, final @NotNull String expression, @Nullable DebuggerDriver.DebuggerLanguage language) throws com.intellij.execution.ExecutionException, DBCannotEvaluateException {
        Protocol.CompositeRequest req = ProtobufMessageFactory.evaluateExpression(frameNumber, threadId, expression, LLDBDriver.convertLanguage(language));
        final Ref result = new Ref();
        final Ref errorMessage = new Ref();
        try {
            this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.EvaluateExpression_Res.class, new Consumer<Protocol.EvaluateExpression_Res>(){

                public void consume(Protocol.EvaluateExpression_Res res) {
                    if (res.getCommonResponse().getIsValid()) {
                        if (res.hasResult()) {
                            Model.LLDBValue lldbValue = res.getResult();
                            LLValue value = LLDBDriver.convertValue(lldbValue, expression);
                            result.set((Object)value);
                        } else {
                            errorMessage.set((Object)LLDBDriver.NO_RESULT);
                        }
                    } else {
                        String error = res.getCommonResponse().getErrorMessage();
                        errorMessage.set((Object)(error != null ? error : "Unknown evaluation error"));
                    }
                }
            }, 0L);
        }
        catch (ProtobufTimeoutException e) {
            throw new DBEvaluationTimedOutException(expression);
        }
        if (!errorMessage.isNull()) {
            String message = (String)errorMessage.get();
            if (NO_RESULT.equals(message)) {
                String id = "_dummy_result__variable_";
                return new LLValue(id, "result", "void", null, "void", LLValue.Kind.EVALUATED, 0, false, null, id, false, null);
            }
            Pattern p = Pattern.compile("error: (.*)\nerror: \\d+ error[s]? parsing expression\n");
            Matcher matcher = p.matcher(message);
            if (matcher.find()) {
                message = matcher.group(1);
            }
            throw new DBCannotEvaluateException(message);
        }
        if (result.isNull()) {
            throw new com.intellij.execution.ExecutionException("Unknown evaluation error");
        }
        return (LLValue)((Object)result.get());
    }

    @Override
    @NotNull
    public DebuggerDriver.ShellCommandResult executeShellCommand(@NotNull String executable, @Nullable List<String> params, @Nullable String workingDir, int timeoutSecs) throws com.intellij.execution.ExecutionException {
        final Ref result = new Ref();
        final Ref errorMessage = new Ref();
        LinkedList<String> args = new LinkedList<String>();
        args.add(executable);
        if (params != null) {
            args.addAll(params);
        }
        String command = StringUtil.join(args, (Function)new Function<String, String>(){

            public String fun(String s) {
                return StringUtil.escapeCharCharacters((String)s);
            }
        }, (String)" ");
        this.getProtobufClient().sendMessageAndWaitForReply(ProtobufMessageFactory.executeShellCommand(command, workingDir, timeoutSecs), Protocol.ExecuteShellCommand_Res.class, new Consumer<Protocol.ExecuteShellCommand_Res>(){

            public void consume(Protocol.ExecuteShellCommand_Res res) {
                Protocol.CommonResponse commonResponse = res.getCommonResponse();
                if (!commonResponse.getIsValid()) {
                    String message = commonResponse.getErrorMessage();
                    errorMessage.set((Object)(message != null && !StringUtil.isEmpty((String)message) ? message : "Invalid shell command response"));
                } else {
                    result.set((Object)new DebuggerDriver.ShellCommandResult(res.getOutput(), res.getStatus(), res.getSignal()));
                }
            }
        }, (timeoutSecs + 10) * 1000);
        if (!errorMessage.isNull()) {
            throw new com.intellij.execution.ExecutionException((String)errorMessage.get());
        }
        return (DebuggerDriver.ShellCommandResult)result.get();
    }

    @Override
    public void executeConsoleCommand(String command) throws com.intellij.execution.ExecutionException {
        this.executeConsoleCommand(-1, -1, command);
    }

    @Override
    public void executeConsoleCommand(int threadId, int frameNumber, String command) throws com.intellij.execution.ExecutionException {
        if (this.myReadyForCommand) {
            this.doHandleConsoleCommand(threadId, frameNumber, command);
        } else {
            this.dispatchInput(command, Model.DispatchTarget.DispatchTargetDebugger);
        }
    }

    private void doHandleConsoleCommand(int threadId, int frameNumber, String command) throws com.intellij.execution.ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.handleConsoleCommand(threadId, frameNumber, command);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.HandleConsoleCommand_Res.class, (Consumer<Protocol.CompositeResponse>)new Consumer<Protocol.HandleConsoleCommand_Res>(){

            public void consume(Protocol.HandleConsoleCommand_Res res) {
                if (res.hasOut()) {
                    LLDBDriver.this.handleGDBOutput(res.getOut());
                }
                if (res.hasErr()) {
                    LLDBDriver.this.handleGDBOutput(res.getErr());
                }
            }
        });
    }

    @Override
    public void handleCompletion(String command, int pos, final List<String> completions) throws com.intellij.execution.ExecutionException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.handleCompletion(command, pos);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.HandleCompletion_Res.class, (Consumer<Protocol.CompositeResponse>)new Consumer<Protocol.HandleCompletion_Res>(){

            public void consume(Protocol.HandleCompletion_Res res) {
                completions.addAll(res.getCompletionList());
            }
        });
    }

    @Override
    public void handleSignal(String signalName, boolean stop2, boolean pass, boolean notify) throws com.intellij.execution.ExecutionException {
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't handle signal");
        Protocol.CompositeRequest handleSignalReq = ProtobufMessageFactory.handleSignal(signalName, stop2, pass, notify);
        this.getProtobufClient().sendMessageAndWaitForReply(handleSignalReq, Protocol.HandleSignal_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    @Override
    protected String getPromptText() {
        return "lldb";
    }

    @Override
    public OutputStream getProcessInput() {
        return this.myProcessInputHandler;
    }

    @Override
    public void removeWatchpoint(List<Integer> ids) throws com.intellij.execution.ExecutionException {
        int num = ids.get(0);
        ThrowIfNotValid responseHandler = new ThrowIfNotValid("Couldn't remove watchpoint");
        Protocol.CompositeRequest req = ProtobufMessageFactory.removeWatchpoint(num);
        this.getProtobufClient().sendMessageAndWaitForReply(req, Protocol.RemoveWatchpoint_Res.class, responseHandler);
        responseHandler.throwIfNeeded();
    }

    @Override
    public int getChildrenCount(LLValue var, int max) throws com.intellij.execution.ExecutionException, DBCannotCollectVariablesException {
        if (var.getChildrenCount() >= max) {
            return max;
        }
        Protocol.CompositeRequest request = ProtobufMessageFactory.getChildrenCount(LLDBDriver.valId(var), max);
        final Ref errorMessage = new Ref();
        final Ref result = Ref.create((Object)0);
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.GetChildrenCount_Res.class, new Consumer<Protocol.GetChildrenCount_Res>(){

            public void consume(Protocol.GetChildrenCount_Res res) {
                boolean isValid = res.getCommonResponse().getIsValid();
                if (!isValid) {
                    errorMessage.set((Object)res.getCommonResponse().getErrorMessage());
                } else {
                    result.set((Object)res.getCount());
                }
            }
        }, 0L);
        if (!errorMessage.isNull()) {
            throw new DBCannotCollectVariablesException((String)errorMessage.get());
        }
        var.setChildrenCount((Integer)result.get());
        return (Integer)result.get();
    }

    private void addShlibPathSubstitutions(String pathSubsts) throws com.intellij.execution.ExecutionException {
        this.myProtobufServer.sendMessageAndWaitForReply(ProtobufMessageFactory.handleConsoleCommand(-1, -1, "target modules search-paths add " + pathSubsts), Protocol.HandleConsoleCommand_Res.class, new ThrowIfNotValid(CidrDebuggerBundle.message("debug.command.error.cannotAddModulesSearchPaths", new Object[0])), Integer.MAX_VALUE);
    }

    public long getValueAddress(@NotNull LLValue var) throws com.intellij.execution.ExecutionException, DBCannotLoadVariableException {
        Protocol.CompositeRequest request = ProtobufMessageFactory.getValueAddress(LLDBDriver.valId(var));
        final Ref errorMessage = new Ref();
        final Ref result = Ref.create();
        this.getProtobufClient().sendMessageAndWaitForReply(request, Protocol.GetValueAddress_Res.class, new Consumer<Protocol.GetValueAddress_Res>(){

            public void consume(Protocol.GetValueAddress_Res res) {
                boolean isValid = res.getCommonResponse().getIsValid();
                if (!isValid) {
                    errorMessage.set((Object)res.getCommonResponse().getErrorMessage());
                } else {
                    result.set((Object)res.getAddress());
                }
            }
        }, 0L);
        if (!errorMessage.isNull()) {
            throw new DBCannotLoadVariableException((String)errorMessage.get());
        }
        return (Long)result.get();
    }

    private void haveConnection() {
        try {
            this.myProtobufServer.sendMessage(ProtobufMessageFactory.setDynamicValuesPolicy(this.myDynamicValuesPolicy), Protocol.DynamicValuesPolicy_Res.class, new ThrowIfNotValid<Protocol.DynamicValuesPolicy_Res>("couldn't set dynamic values policy"){

                @Override
                public void consume(Protocol.DynamicValuesPolicy_Res message) {
                    super.consume(message);
                    LLDBDriver.this.myProtobufServer.sendMessage(ProtobufMessageFactory.handleConsoleCommand(-1, -1, "settings set target.prefer-dynamic-value no-dynamic-values"), Protocol.HandleConsoleCommand_Res.class, new ThrowIfNotValid<Protocol.HandleConsoleCommand_Res>("couldn't set dynamic values policy"){

                        @Override
                        public void consume(Protocol.HandleConsoleCommand_Res message) {
                            super.consume(message);
                            LLDBDriver.this.myProtobufServer.sendMessage(ProtobufMessageFactory.setValuesFilteringEnabled(CidrDebuggerSettings.getInstance().VALUES_FILTER_ENABLED), Protocol.ValuesFilteringPolicy_Res.class, new ThrowIfNotValid<Protocol.ValuesFilteringPolicy_Res>("couldn't set values filtering policy"){

                                @Override
                                public void consume(Protocol.ValuesFilteringPolicy_Res message) {
                                    super.consume(message);
                                    Consumer<Protocol.HandleConsoleCommand_Res> completion = new Consumer<Protocol.HandleConsoleCommand_Res>(){

                                        public void consume(Protocol.HandleConsoleCommand_Res res) {
                                            LLDBDriver.this.myConnectedClient.set(LLDBDriver.this.myProtobufServer);
                                        }
                                    };
                                    if (LLDBDriver.this.myLLDBCommandLine.getUserData(ENABLE_STL_RENDERERS) == Boolean.TRUE) {
                                        LLDBDriver.this.myProtobufServer.sendMessage(ProtobufMessageFactory.handleConsoleCommand(-1, -1, "script import lldb_formatters.jetbrains_stl_formatters"), Protocol.HandleConsoleCommand_Res.class, new Consumer<Protocol.HandleConsoleCommand_Res>((Consumer)completion){
                                            final /* synthetic */ Consumer val$completion;
                                            {
                                                this.val$completion = consumer;
                                            }

                                            public void consume(Protocol.HandleConsoleCommand_Res res) {
                                                if (CidrDebuggerLog.LOG.isDebugEnabled()) {
                                                    String logPath = PathManager.getLogPath() + "/lldb.log";
                                                    LLDBDriver.this.myProtobufServer.sendMessage(ProtobufMessageFactory.handleConsoleCommand(-1, -1, "log enable -f " + logPath + " lldb default"), Protocol.HandleConsoleCommand_Res.class, this.val$completion);
                                                } else {
                                                    this.val$completion.consume(null);
                                                }
                                            }
                                        });
                                    } else {
                                        completion.consume(null);
                                    }
                                }
                            });
                        }
                    });
                }
            });
        }
        catch (Exception e) {
            this.myConnectedClient.setException(e);
        }
    }

    protected void handleModulesLoaded(final List<String> modules) {
        this.myHandlerProcessor.add((Object)new Runnable(){

            @Override
            public void run() {
                LLDBDriver.this.myHandler.handleModulesLoaded(modules);
            }
        });
    }

    public void consume(GeneratedMessage generatedMessage) {
        if (generatedMessage instanceof Model.Initialized_Message) {
            this.haveConnection();
        } else if (generatedMessage instanceof Broadcasts.ProcessExited_Broadcast) {
            this.readOutputFully();
            Broadcasts.ProcessExited_Broadcast exit = (Broadcasts.ProcessExited_Broadcast)generatedMessage;
            int exitCode = exit.getExitCode();
            this.handleTargetFinished(exitCode, exit.hasExitDescription() ? exit.getExitDescription() : null);
        } else if (generatedMessage instanceof Broadcasts.ProcessRunning_Broadcast) {
            Integer attachedTo = this.myAsyncAttachingTo;
            this.myAsyncAttachingTo = null;
            if (attachedTo != null) {
                this.handleAttached(attachedTo);
            }
            this.handleRunning();
        } else if (generatedMessage instanceof Broadcasts.ProcessInterrupted_Broadcast) {
            this.readOutputFully();
            try {
                this.removeTemporaryBreakpoints();
            }
            catch (com.intellij.execution.ExecutionException attachedTo) {
                // empty catch block
            }
            Model.ProcessInterruptionInfo interruptionInfo = ((Broadcasts.ProcessInterrupted_Broadcast)generatedMessage).getInterruptionInfo();
            int selectedThreadID = interruptionInfo.getSelectedThread();
            ArrayList<LLThread> threads = new ArrayList<LLThread>();
            List<Model.LLDBThread> threadsList = interruptionInfo.getThreadsList();
            int selectedThreadNum = -1;
            for (Model.LLDBThread lldbThread : threadsList) {
                String name = lldbThread.hasName() ? lldbThread.getName() : null;
                threads.add(new LLThread(lldbThread.getId(), null, lldbThread.getQueue(), name));
                if (lldbThread.getId() != selectedThreadID) continue;
                selectedThreadNum = threads.size() - 1;
            }
            this.myStoppedThreadIndex = -1;
            int size = threadsList.size();
            block10: for (int i = 0; i < size && this.myStoppedThreadIndex == -1; ++i) {
                Model.LLDBThread lldbThread = threadsList.get(i);
                Model.ThreadStopReasonData stopReasonData = lldbThread.getStopReasonData();
                if (stopReasonData == null) continue;
                Model.ThreadStopReason stopReason = stopReasonData.getStopReason();
                switch (stopReason) {
                    case ThreadStopReasonBreakpoint: {
                        if (stopReasonData.getBreakpointsStopInfoCount() <= 0) continue block10;
                        Model.BreakpointStopInfo breakpointsStopInfo = stopReasonData.getBreakpointsStopInfo(0);
                        this.myStoppedThreadIndex = i;
                        this.handleBreakpoint(breakpointsStopInfo.getBreakpointId(), threads, i);
                        continue block10;
                    }
                    case ThreadStopReasonWatchpoint: {
                        if (stopReasonData.getWatchpointsStopInfoCount() <= 0) continue block10;
                        Model.WatchpointStopInfo breakpointsStopInfo = stopReasonData.getWatchpointsStopInfo(0);
                        this.myStoppedThreadIndex = i;
                        this.handleWatchpoint(breakpointsStopInfo.getWatchpointId(), threads, i);
                        continue block10;
                    }
                    case ThreadStopReasonSignal: {
                        this.myStoppedThreadIndex = i;
                        int signal = stopReasonData.getSignal();
                        String signalName = stopReasonData.getSignalName();
                        if (LLDBDriver.isTargetTerminationSignal(signal)) {
                            this.handleTargetTerminated();
                            return;
                        }
                        this.handleSignal(threads, i, !signalName.isEmpty() ? signalName : String.valueOf(signal), stopReasonData.getStopDescription());
                        continue block10;
                    }
                    case ThreadStopReasonException: {
                        this.myStoppedThreadIndex = i;
                        this.handleException(threads, i, stopReasonData.getStopDescription());
                        continue block10;
                    }
                    case ThreadStopReasonExec: 
                    case ThreadStopReasonTrace: 
                    case ThreadStopReasonPlanComplete: 
                    case ThreadStopReasonThreadExiting: {
                        this.myStoppedThreadIndex = i;
                        this.handleInterrupted(threads, i);
                        continue block10;
                    }
                }
            }
            if (this.myStoppedThreadIndex == -1) {
                CidrDebuggerLog.LOG.assertTrue(selectedThreadNum != -1, (Object)("selectedThreadNum == -1 for message:\n" + generatedMessage));
                this.myStoppedThreadIndex = selectedThreadNum;
                this.handleInterrupted(threads, selectedThreadNum);
            }
        } else if (generatedMessage instanceof Broadcasts.ChangePrompt_Broadcast) {
            this.handlePrompt(((Broadcasts.ChangePrompt_Broadcast)generatedMessage).getPrompt());
        } else if (generatedMessage instanceof Broadcasts.ReadyForCommands_Broadcast) {
            this.handleReadyForCommands(((Broadcasts.ReadyForCommands_Broadcast)generatedMessage).getReady() != 0);
        } else if (generatedMessage instanceof Broadcasts.CommandsInterpreter_Broadcast) {
            this.handleGDBOutput(((Broadcasts.CommandsInterpreter_Broadcast)generatedMessage).getMessage());
        } else if (generatedMessage instanceof Broadcasts.TargetProcessOutput_Broadcast) {
            Broadcasts.TargetProcessOutput_Broadcast outputBroadcast = (Broadcasts.TargetProcessOutput_Broadcast)generatedMessage;
            this.handleTargetOutput(outputBroadcast.getText(), LLDBDriver.outputType2ProcessOutputKey(outputBroadcast.getOutputType()));
        } else if (generatedMessage instanceof Broadcasts.LogMessage_Broadcast) {
            String message = ((Broadcasts.LogMessage_Broadcast)generatedMessage).getMessage();
            CidrDebuggerLog.LOG.info(message);
        } else if (generatedMessage instanceof Broadcasts.ModulesLoaded_Broadcast) {
            this.handleModulesLoaded(((Broadcasts.ModulesLoaded_Broadcast)generatedMessage).getModulesList());
        }
    }

    private static Key outputType2ProcessOutputKey(Model.OutputType outputType) {
        return outputType == Model.OutputType.OutputTypeStdout ? ProcessOutputTypes.STDOUT : ProcessOutputTypes.STDERR;
    }

    private void handleReadyForCommands(boolean ready) {
        this.myReadyForCommand = ready;
        this.handlePrompt(ready ? "(" + this.getPromptText() + ")" : ">");
    }

    private class LLDBProcessHandler
    extends OSProcessHandler {
        public LLDBProcessHandler(GeneralCommandLine commandLine) throws com.intellij.execution.ExecutionException {
            super(commandLine);
        }

        protected boolean useNonBlockingRead() {
            return false;
        }

        protected void doDestroyProcess() {
            if (LLDBDriver.this.myConnectedClient.isDone()) {
                try {
                    ((ProtobufServer)LLDBDriver.this.myConnectedClient.get()).sendMessage(ProtobufMessageFactory.exit(), null, null);
                }
                catch (com.intellij.execution.ExecutionException executionException) {
                    // empty catch block
                }
            }
            LLDBDriver.this.myProtobufServer.tearDown();
            try {
                this.executeOnPooledThread(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            LLDBProcessHandler.this.getProcess().waitFor();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }).get(4L, TimeUnit.SECONDS);
            }
            catch (TimeoutException timeoutException) {
            }
            catch (InterruptedException interruptedException) {
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
            super.doDestroyProcess();
        }
    }

    public class ProcessInputWriter
    extends OutputStream {
        private final Object myCloseOpLock = new Object();
        private File myInputFileDir;
        private volatile boolean closed;
        private volatile boolean pipeInput;
        private volatile OutputStream myOutputStream;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void initPipeInput(final @NotNull File inputFileDir, final @NotNull String inputFileName) {
            this.pipeInput = true;
            this.closed = false;
            Object object = this.myCloseOpLock;
            synchronized (object) {
                this.myInputFileDir = inputFileDir;
            }
            ApplicationManager.getApplication().executeOnPooledThread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    File inputFile = new File(inputFileDir, inputFileName);
                    while (!ProcessInputWriter.this.closed && !inputFile.exists()) {
                        try {
                            Thread.sleep(100L);
                        }
                        catch (InterruptedException e) {
                            LOG.warn((Throwable)e);
                            break;
                        }
                    }
                    if (ProcessInputWriter.this.closed) {
                        return;
                    }
                    Object object = ProcessInputWriter.this.myCloseOpLock;
                    synchronized (object) {
                        if (inputFile.exists()) {
                            try {
                                ProcessInputWriter.this.myOutputStream = new FileOutputStream(inputFile);
                            }
                            catch (IOException e) {
                                LOG.warn((Throwable)e);
                            }
                        }
                    }
                }
            });
        }

        public void initDispatchInput() {
            this.pipeInput = false;
        }

        @Override
        public void write(int i) throws IOException {
            LOG.error("Shouldn't be here");
        }

        @Override
        public void write(@NotNull byte[] bytes, int i, int i1) throws IOException {
            if (this.pipeInput) {
                if (!this.closed && this.myOutputStream != null) {
                    this.myOutputStream.write(bytes, i, i1);
                }
            } else {
                try {
                    String input = new String(bytes, i, i1, LLDBDriver.this.myLLDBCommandLine.getCharset());
                    LLDBDriver.this.dispatchInput(input, Model.DispatchTarget.DispatchTargetProcess);
                }
                catch (com.intellij.execution.ExecutionException e) {
                    throw new IOException(e);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        File getInputFileDir() {
            Object object = this.myCloseOpLock;
            synchronized (object) {
                return this.myInputFileDir;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            if (!this.pipeInput) {
                return;
            }
            this.closed = true;
            Object object = this.myCloseOpLock;
            synchronized (object) {
                if (this.myOutputStream != null) {
                    try {
                        this.myOutputStream.close();
                    }
                    catch (IOException e) {
                        LOG.warn((Throwable)e);
                    }
                    if (this.myInputFileDir.exists()) {
                        FileUtil.delete((File)this.myInputFileDir);
                    }
                }
            }
        }
    }

    protected static class ThrowIfNotValid<T extends GeneratedMessage>
    implements Consumer<T> {
        private String myMessage;
        private boolean myIsValid = false;

        public ThrowIfNotValid(String mes) {
            this.myMessage = mes;
        }

        public void consume(T message) {
            Map allFields = message.getAllFields();
            for (Object val : allFields.values()) {
                String errorMessage;
                if (!(val instanceof Protocol.CommonResponse)) continue;
                Protocol.CommonResponse commonResponse = (Protocol.CommonResponse)val;
                this.myIsValid = commonResponse.getIsValid();
                if (this.myIsValid || !commonResponse.hasErrorMessage() || StringUtil.isEmptyOrSpaces((String)(errorMessage = commonResponse.getErrorMessage()))) continue;
                this.myMessage = errorMessage;
            }
        }

        public void throwIfNeeded() throws LLDBDriverException {
            if (!this.myIsValid) {
                throw new LLDBDriverException(this.myMessage);
            }
        }

        public String getMessage() {
            return this.myMessage;
        }

        public boolean isValid() {
            return this.myIsValid;
        }
    }
}

