/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.SLRUMap;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBResponse;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.Nullable;

public class GDBVarsCache {
    private final Map<String, List<Boolean>> myAliveVars = new HashMap();
    private final Map<String, List<Boolean>> myReservedVars = new HashMap();
    private final SLRUMap<Pair<String, Integer>, GDBResponse.Record> myVarsCache;

    public GDBVarsCache(final Delegate delegate) {
        this.myVarsCache = new SLRUMap<Pair<String, Integer>, GDBResponse.Record>(200, 500){

            protected void onDropFromCache(Pair<String, Integer> key, GDBResponse.Record value) {
                if (delegate != null) {
                    delegate.onDrop(value);
                }
                List alive = (List)GDBVarsCache.this.myAliveVars.get(key.first);
                List reserved = (List)GDBVarsCache.this.myReservedVars.get(key.first);
                alive.set((Integer)key.second, false);
                if (reserved != null) {
                    int i = (Integer)key.second;
                    if (reserved.size() > i) {
                        reserved.set(i, false);
                    }
                }
                super.onDropFromCache(key, (Object)value);
            }
        };
    }

    void putIntoCache(String expression, GDBResponse.Record result) {
        List<Boolean> alive = this.myAliveVars.get(expression);
        List<Boolean> reserved = this.myReservedVars.get(expression);
        if (alive != null) {
            assert (reserved != null && reserved.size() == alive.size());
            for (int i = 0; i < alive.size(); ++i) {
                if (alive.get(i).booleanValue()) continue;
                this.myVarsCache.put((Object)new Pair((Object)expression, (Object)i), (Object)result);
                alive.set(i, true);
                reserved.set(i, true);
                return;
            }
        }
        if (alive == null) {
            alive = new ArrayList<Boolean>();
        }
        if (reserved == null) {
            reserved = new ArrayList<Boolean>();
        }
        alive.add(true);
        reserved.add(true);
        this.myVarsCache.put((Object)new Pair((Object)expression, (Object)(alive.size() - 1)), (Object)result);
        this.myAliveVars.put(expression, alive);
        this.myReservedVars.put(expression, reserved);
    }

    @Nullable
    GDBResponse.Record getFromCache(String expression) {
        List<Boolean> alive = this.myAliveVars.get(expression);
        List<Boolean> reserved = this.myReservedVars.get(expression);
        if (alive != null) {
            assert (reserved != null && reserved.size() == alive.size());
            for (int i = 0; i < alive.size(); ++i) {
                if (!alive.get(i).booleanValue() || reserved.get(i).booleanValue()) continue;
                GDBResponse.Record result = (GDBResponse.Record)this.myVarsCache.get((Object)new Pair((Object)expression, (Object)i));
                if (result != null) {
                    reserved.set(i, true);
                }
                return result;
            }
        }
        return null;
    }

    void freeVariablesToReuse() {
        for (String exp : this.myReservedVars.keySet()) {
            List<Boolean> reserved = this.myReservedVars.get(exp);
            for (int i = 0; i < reserved.size(); ++i) {
                reserved.set(i, false);
            }
        }
    }

    public static interface Delegate {
        public void onDrop(GDBResponse.Record var1);
    }
}

