/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend.gdb;

import com.intellij.openapi.util.Couple;
import com.intellij.openapi.util.Pair;
import com.intellij.util.containers.HashMap;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBResponse;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GDBTuple;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbBaseVisitor;
import com.jetbrains.cidr.execution.debugger.backend.gdb.GdbParser;
import java.util.List;
import org.antlr.v4.runtime.misc.NotNull;

public class GDBResponseVisitor
extends GdbBaseVisitor<GDBResponse> {
    private static final HashMap<String, GDBResponse.ResultRecord.Type> resultTypeMap = new HashMap();

    public GDBResponse getResponse(String varName, GDBResponse.ResultRecord val) {
        GDBTuple r = new GDBTuple();
        if (val.getType() == GDBResponse.ResultRecord.Type.str_value) {
            r.add(Couple.of((Object)varName, (Object)((Pair)val.getResultList().get((int)0)).first));
        } else if (val.getType() == GDBResponse.ResultRecord.Type.tuple_value) {
            r.add(Pair.create((Object)varName, (Object)val.getResultList()));
        } else if (val.getType() == GDBResponse.ResultRecord.Type.list_value) {
            assert (val.getResultList().size() == 1);
            r.add(Pair.create((Object)varName, (Object)((GDBTuple)val.getResultList().get(0))));
        } else assert (false);
        return new GDBResponse.ResultRecord(GDBResponse.ResultRecord.Category.result, GDBResponse.ResultRecord.Type.result, r);
    }

    @Override
    public GDBResponse visitResult(@NotNull GdbParser.ResultContext ctx) {
        GDBResponse.ResultRecord val = (GDBResponse.ResultRecord)this.visitValue(ctx.value());
        return this.getResponse(ctx.variable().getText(), val);
    }

    @Override
    public GDBResponse visitMultiple_bkpt_result(@NotNull GdbParser.Multiple_bkpt_resultContext ctx) {
        assert (ctx.value().size() > 0);
        GDBResponse.ResultRecord val = (GDBResponse.ResultRecord)this.visitValue(ctx.value(0));
        return this.getResponse("bkpt", val);
    }

    @Override
    public GDBResponse visitCnst(@NotNull GdbParser.CnstContext ctx) {
        GDBTuple r = new GDBTuple();
        r.add(Couple.of((Object)GDBResponseVisitor.getUnquotedString(ctx.c_string(), true), null));
        return new GDBResponse.ResultRecord(GDBResponse.ResultRecord.Category.result, GDBResponse.ResultRecord.Type.str_value, r);
    }

    @Override
    public GDBResponse visitTuple(@NotNull GdbParser.TupleContext ctx) {
        GDBTuple results = new GDBTuple();
        int i = 0;
        while (ctx.result(i) != null) {
            GdbParser.ResultContext rctx = ctx.result(i);
            GDBResponse.ResultRecord res = (GDBResponse.ResultRecord)this.visitResult(rctx);
            assert (res.getResultList().size() == 1);
            results.add(res.getResultList().get(0));
            ++i;
        }
        return new GDBResponse.ResultRecord(GDBResponse.ResultRecord.Category.result, GDBResponse.ResultRecord.Type.tuple_value, results);
    }

    @Override
    public GDBResponse visitList(@NotNull GdbParser.ListContext ctx) {
        GDBTuple result = new GDBTuple();
        GDBTuple list = new GDBTuple();
        for (GdbParser.List_itemContext each : ctx.list_item()) {
            GDBResponse.ResultRecord res;
            if (each.result() != null) {
                res = (GDBResponse.ResultRecord)this.visitResult(each.result());
                assert (res.getResultList().size() == 1);
                list.add(res.getResultList().get(0));
                continue;
            }
            res = (GDBResponse.ResultRecord)this.visitValue(each.value());
            if (res.getType() == GDBResponse.ResultRecord.Type.str_value) {
                list.add(((Couple)res.getResultList().get((int)0)).first);
                continue;
            }
            if (res.getType() == GDBResponse.ResultRecord.Type.tuple_value) {
                list.add(res.getResultList());
                continue;
            }
            if (res.getType() == GDBResponse.ResultRecord.Type.list_value) {
                assert (res.getResultList().size() == 1);
                list.add(res.getResultList().get(0));
                continue;
            }
            assert (false);
        }
        result.add(list);
        return new GDBResponse.ResultRecord(GDBResponse.ResultRecord.Category.result, GDBResponse.ResultRecord.Type.list_value, result);
    }

    @Override
    public GDBResponse visitBreakResult(@NotNull GdbParser.BreakResultContext ctx) {
        String typeStr = "done";
        GDBResponse.ResultRecord.Type type = (GDBResponse.ResultRecord.Type)resultTypeMap.get((Object)typeStr);
        GDBTuple results = new GDBTuple();
        GDBResponse.ResultRecord res = (GDBResponse.ResultRecord)this.visitMultiple_bkpt_result(ctx.multiple_bkpt_result());
        assert (res.getResultList().size() == 1);
        results.add(res.getResultList().get(0));
        return new GDBResponse.ResultRecord(GDBResponse.ResultRecord.Category.result, type, results);
    }

    @Override
    public GDBResponse visitCommonResult(@NotNull GdbParser.CommonResultContext ctx) {
        GDBResponse.ResultRecord.Type type = (GDBResponse.ResultRecord.Type)resultTypeMap.get((Object)ctx.result_class().getText());
        GDBTuple results = new GDBTuple();
        int i = 0;
        while (ctx.result(i) != null) {
            GdbParser.ResultContext rctx = ctx.result(i);
            GDBResponse.ResultRecord res = (GDBResponse.ResultRecord)this.visitResult(rctx);
            assert (res.getResultList().size() == 1);
            results.add(res.getResultList().get(0));
            ++i;
        }
        return new GDBResponse.ResultRecord(GDBResponse.ResultRecord.Category.result, type, results);
    }

    @Override
    public GDBResponse visitResultWithString(@NotNull GdbParser.ResultWithStringContext ctx) {
        GDBResponse.ResultRecord.Type type = (GDBResponse.ResultRecord.Type)resultTypeMap.get((Object)ctx.result_class().getText());
        GDBTuple result = new GDBTuple();
        result.add(Couple.of((Object)"msg", (Object)GDBResponseVisitor.getUnquotedString(ctx.c_string(), true)));
        return new GDBResponse.ResultRecord(GDBResponse.ResultRecord.Category.result, type, result);
    }

    @Override
    public GDBResponse visitDefaultAsyncOutput(@NotNull GdbParser.DefaultAsyncOutputContext ctx) {
        String typeStr = ctx.async_output().async_class().getText();
        GDBTuple results = this.readAsyncOutputResult(ctx.async_output().result());
        return new GDBResponse.AsyncRecord(GDBResponse.AsyncRecord.Category.exec, typeStr, results);
    }

    @Override
    public GDBResponse visitIllformedStopped(@NotNull GdbParser.IllformedStoppedContext ctx) {
        GDBTuple results = this.readAsyncOutputResult(ctx.result());
        return new GDBResponse.AsyncRecord(GDBResponse.AsyncRecord.Category.exec, "stopped", results);
    }

    @Override
    public GDBResponse visitStatus_async_output(@NotNull GdbParser.Status_async_outputContext ctx) {
        String typeStr = ctx.async_output().async_class().getText();
        GDBTuple results = this.readAsyncOutputResult(ctx.async_output().result());
        return new GDBResponse.AsyncRecord(GDBResponse.AsyncRecord.Category.status, typeStr, results);
    }

    @Override
    public GDBResponse visitCommonNotification(@NotNull GdbParser.CommonNotificationContext ctx) {
        String typeStr = ctx.async_output().async_class().getText();
        GDBTuple results = this.readAsyncOutputResult(ctx.async_output().result());
        return new GDBResponse.AsyncRecord(GDBResponse.AsyncRecord.Category.notify, typeStr, results);
    }

    @NotNull
    private GDBTuple readAsyncOutputResult(@NotNull List<GdbParser.ResultContext> asyncOutputContext) {
        GDBTuple results = new GDBTuple();
        for (GdbParser.ResultContext each : asyncOutputContext) {
            GDBResponse.ResultRecord res = (GDBResponse.ResultRecord)this.visitResult(each);
            assert (res.getResultList().size() == 1);
            results.add(res.getResultList().get(0));
        }
        return results;
    }

    @Override
    public GDBResponse visitCorruptedMemoryChangedNotification(@NotNull GdbParser.CorruptedMemoryChangedNotificationContext ctx) {
        String typeStr = "memory-changed";
        GDBTuple results = new GDBTuple();
        String substring = GDBResponseVisitor.getUnquotedString(ctx.cnst().c_string(), false);
        results.add(Couple.of((Object)"thread-group", (Object)substring));
        int i = 0;
        while (ctx.result(i) != null) {
            GdbParser.ResultContext rctx = ctx.result(i);
            GDBResponse.ResultRecord res = (GDBResponse.ResultRecord)this.visitResult(rctx);
            assert (res.getResultList().size() == 1);
            results.add(res.getResultList().get(0));
            ++i;
        }
        return new GDBResponse.AsyncRecord(GDBResponse.AsyncRecord.Category.notify, typeStr, results);
    }

    @Override
    public GDBResponse visitBreakModified(@NotNull GdbParser.BreakModifiedContext ctx) {
        String typeStr = "breakpoint-modified";
        GDBTuple results = new GDBTuple();
        GDBResponse.ResultRecord res = (GDBResponse.ResultRecord)this.visitMultiple_bkpt_result(ctx.multiple_bkpt_result());
        results.add(res.getResultList().get(0));
        return new GDBResponse.AsyncRecord(GDBResponse.AsyncRecord.Category.notify, typeStr, results);
    }

    @Override
    public GDBResponse visitBreakCreated(@NotNull GdbParser.BreakCreatedContext ctx) {
        String typeStr = "breakpoint-created";
        GDBTuple results = new GDBTuple();
        GDBResponse.ResultRecord res = (GDBResponse.ResultRecord)this.visitMultiple_bkpt_result(ctx.multiple_bkpt_result());
        results.add(res.getResultList().get(0));
        return new GDBResponse.AsyncRecord(GDBResponse.AsyncRecord.Category.notify, typeStr, results);
    }

    @Override
    public GDBResponse visitConsole_stream_output(@NotNull GdbParser.Console_stream_outputContext ctx) {
        String output = DebuggerDriver.unescapeString(ctx.c_string().getText());
        assert (output.length() >= 2);
        return new GDBResponse.StreamRecord(GDBResponse.StreamRecord.Category.console, output.substring(1, output.length() - 1));
    }

    @Override
    public GDBResponse visitLog_stream_output(@NotNull GdbParser.Log_stream_outputContext ctx) {
        String output = DebuggerDriver.unescapeString(ctx.c_string().getText());
        assert (output.length() >= 2);
        return new GDBResponse.StreamRecord(GDBResponse.StreamRecord.Category.log, output.substring(1, output.length() - 1));
    }

    @NotNull
    private static String getUnquotedString(@NotNull GdbParser.C_stringContext stringContext, boolean unescape) {
        String str = stringContext.getText();
        String result = str.substring(1, str.length() - 1);
        return unescape ? DebuggerDriver.unescapeString(result) : result;
    }

    static {
        resultTypeMap.put((Object)"done", (Object)GDBResponse.ResultRecord.Type.done);
        resultTypeMap.put((Object)"running", (Object)GDBResponse.ResultRecord.Type.running);
        resultTypeMap.put((Object)"connected", (Object)GDBResponse.ResultRecord.Type.connected);
        resultTypeMap.put((Object)"error", (Object)GDBResponse.ResultRecord.Type.error);
        resultTypeMap.put((Object)"exit", (Object)GDBResponse.ResultRecord.Type.exit);
        resultTypeMap.put((Object)"stepping", (Object)GDBResponse.ResultRecord.Type.stepping);
        resultTypeMap.put((Object)"continuing", (Object)GDBResponse.ResultRecord.Type.continuing);
    }
}

