/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.containers.HashMap;
import com.jetbrains.cidr.execution.CidrDebuggerBundle;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import java.math.BigInteger;
import java.util.List;
import java.util.regex.Pattern;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLValue
extends UserDataHolderBase {
    @Language(value="RegExp")
    public static final String HEX_ADDRESS_PATTERN_STRING = "0x\\p{XDigit}+";
    @Language(value="RegExp")
    public static final String HEX_VALUE_PATTERN_STRING = "^(0x\\p{XDigit}+)";
    private static final Pattern HEX_VALUE_PATTERN = Pattern.compile("^(0x\\p{XDigit}+)");
    private static final String NIL_PATTERN_STRING = "0x0+";
    private static final Pattern NIL_PATTERN = Pattern.compile("0x0+");
    private static HashMap<String, Access> accessMap = new HashMap(3);
    @NotNull
    private String myId;
    @NotNull
    private final String myReferenceExpression;
    @NotNull
    private String myName;
    @NotNull
    private final String myType;
    @Nullable
    private final String myDynamicType;
    @NotNull
    private String myValue;
    @Nullable
    private final String myReadableValue;
    @NotNull
    private final Kind myKind;
    @NotNull
    private final Access myAccess;
    private final boolean myNSObject;
    private int myChildrenCount;
    private boolean myValid = true;
    private boolean myStruct;
    private final boolean myPointerReference;
    @Nullable
    private final TypeClass myTypeClass;

    public LLValue(@NotNull String id, @NotNull String name, @NotNull String type, @Nullable String dynamicType, @NotNull String value, @NotNull Kind kind, int childrenCount, boolean isNSObject, @Nullable String readableValue, @NotNull String referenceExpression, boolean isStruct, @Nullable TypeClass typeClass, @NotNull Access access) {
        this.myId = id;
        this.myName = name;
        this.myType = type;
        this.myDynamicType = dynamicType;
        this.myValue = value;
        this.myKind = kind;
        this.myChildrenCount = childrenCount;
        this.myNSObject = isNSObject;
        this.myReadableValue = readableValue;
        this.myReferenceExpression = referenceExpression;
        this.myStruct = isStruct;
        this.myTypeClass = typeClass;
        this.myPointerReference = typeClass == TypeClass.REFERENCE && this.isValidPointer();
        this.myAccess = access;
    }

    public LLValue(@NotNull String id, @NotNull String name, @NotNull String type, @Nullable String dynamicType, @NotNull String value, @NotNull Kind kind, int childrenCount, boolean isNSObject, @Nullable String readableValue, @NotNull String referenceExpression, boolean isStruct, @Nullable TypeClass typeClass) {
        this(id, name, type, dynamicType, value, kind, childrenCount, isNSObject, readableValue, referenceExpression, isStruct, typeClass, Access.PUBLIC);
    }

    public void setId(@NotNull String id) {
        this.myId = id;
    }

    public void setValue(@NotNull String value) {
        this.myValue = value;
    }

    public void setStruct(boolean struct) {
        this.myStruct = struct;
    }

    @NotNull
    public Access getAccess() {
        return this.myAccess;
    }

    @NotNull
    public String getReferenceExpression() {
        return this.myReferenceExpression;
    }

    @NotNull
    public String getId() {
        return this.myId;
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    public void setName(@NotNull String newName) {
        this.myName = newName;
    }

    public boolean isValid() {
        return this.myValid;
    }

    public void setValid(boolean valid) {
        this.myValid = valid;
    }

    @NotNull
    public String getType() {
        return this.myType;
    }

    @Nullable
    public String getDynamicType() {
        return this.myDynamicType;
    }

    @NotNull
    public String getBestType() {
        return this.myDynamicType == null ? this.myType : this.myDynamicType;
    }

    @NotNull
    public String getValue() {
        return this.myValue;
    }

    @NotNull
    public Kind getKind() {
        return this.myKind;
    }

    public int getChildrenCount() {
        return this.myChildrenCount;
    }

    public boolean mayHaveChildren() {
        return this.myValid && (this.myChildrenCount == -1 || this.myChildrenCount > 0);
    }

    public void setChildrenCount(int count) {
        this.myChildrenCount = count;
    }

    public boolean isPointer() {
        return this.getPointerSafely() != null;
    }

    public boolean isValidPointer() {
        String pointer = this.getPointerSafely();
        return pointer != null && !NIL_PATTERN.matcher(pointer).matches();
    }

    public boolean isNilPointer() {
        return LLValue.isNilPointer(this.getPointerSafely());
    }

    private static boolean isNilPointer(@Nullable String pointer) {
        return pointer != null && NIL_PATTERN.matcher(pointer).matches();
    }

    @NotNull
    public String getPointer() throws DBCannotEvaluateException {
        String result = this.getPointerSafely();
        if (result == null) {
            throw new DBCannotEvaluateException(CidrDebuggerBundle.message("debug.command.error.notAPointer", this.myValue));
        }
        return result;
    }

    @Nullable
    public String getPointerSafely() {
        return LLValue.getPointer(this.myValue);
    }

    @Nullable
    public static String getPointer(@Nullable String value) {
        if (value == null) {
            return null;
        }
        List matches = StringUtil.findMatches((String)value, (Pattern)HEX_VALUE_PATTERN);
        if (matches.size() == 1) {
            return (String)matches.get(0);
        }
        return null;
    }

    @Nullable
    public String getReadablePointer() {
        int i;
        String pointer = this.getPointerSafely();
        if (pointer == null) {
            return null;
        }
        if (LLValue.isNilPointer(pointer)) {
            return "0x0";
        }
        for (i = 2; i < pointer.length() && pointer.charAt(i) == '0'; ++i) {
        }
        if (i > 2) {
            pointer = "0x" + pointer.substring(i);
        }
        return pointer;
    }

    public boolean isStruct() {
        return this.myStruct;
    }

    public boolean isNSObject() {
        return this.myNSObject;
    }

    public boolean isPointerReference() {
        return this.myPointerReference;
    }

    public boolean isTrue() {
        return !this.isFalse();
    }

    public boolean isFalse() {
        String[] s;
        for (String s1 : s = new String[]{NIL_PATTERN_STRING, "0+", "false", "NO", "'\\\\0'", "0 [LUu]?'.*'"}) {
            if (!Pattern.compile(s1).matcher(this.myValue).matches()) continue;
            return true;
        }
        return false;
    }

    public long intValue() throws DBCannotEvaluateException {
        try {
            String pointer = this.getPointerSafely();
            if (pointer != null) {
                return DebuggerDriver.parseAddressSafe(pointer);
            }
            return new BigInteger(this.myValue).longValue();
        }
        catch (NumberFormatException e) {
            throw new DBCannotEvaluateException(CidrDebuggerBundle.message("debug.command.error.cannotReadInteger", this.myValue));
        }
    }

    @NotNull
    public String getReadableValue() {
        if (this.myReadableValue != null) {
            return this.myReadableValue;
        }
        List matches = StringUtil.findMatches((String)this.myValue, (Pattern)Pattern.compile("^0x\\p{XDigit}+ (\"(?:.*)\")$"));
        if (matches.size() == 1) {
            return (String)matches.get(0);
        }
        return this.myValue;
    }

    @Nullable
    public TypeClass getTypeClass() {
        return this.myTypeClass;
    }

    public String toString() {
        return (Object)((Object)this.myAccess) + ":" + (Object)((Object)this.myKind) + ":" + this.myName + "(" + this.myType + ":" + this.myDynamicType + ")=" + this.myValue;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        LLValue that = (LLValue)((Object)o);
        if (!this.myName.equals(that.myName)) {
            return false;
        }
        if (!this.myType.equals(that.myType)) {
            return false;
        }
        if (Comparing.equal((String)this.myDynamicType, (String)that.myDynamicType)) {
            return false;
        }
        if (!this.myValue.equals(that.myValue)) {
            return false;
        }
        if (!this.myKind.equals((Object)that.myKind)) {
            return false;
        }
        return this.myAccess.equals((Object)that.myAccess);
    }

    public int hashCode() {
        int result = this.myName.hashCode();
        result = 31 * result + this.myType.hashCode();
        result = 31 * result + (this.myDynamicType != null ? this.myDynamicType.hashCode() : 0);
        result = 31 * result + this.myValue.hashCode();
        result = 31 * result + this.myKind.hashCode();
        return result;
    }

    public static enum Access {
        PUBLIC("public"),
        PROTECTED("protected"),
        PRIVATE("private");

        private String access;

        private Access(String access) {
            this.access = access;
            accessMap.put((Object)access, (Object)this);
        }

        public static Access valueFor(String str) {
            if (str == null) {
                return null;
            }
            return (Access)((Object)accessMap.get((Object)str));
        }

        public String toString() {
            return this.access;
        }
    }

    public static enum TypeClass {
        REFERENCE,
        FUNCTION,
        BUILTIN;

    }

    public static enum Kind {
        LOCAL,
        EVALUATED;

    }
}

