/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.text.StringUtil;
import org.jetbrains.annotations.Nullable;

public class LLThread {
    private final int myId;
    @Nullable
    private final String myState;
    @Nullable
    private final String myWorkQueue;
    @Nullable
    private final String myName;

    public LLThread(int id, @Nullable String state, @Nullable String workQueue) {
        this(id, state, workQueue, null);
    }

    public LLThread(int id, @Nullable String state, @Nullable String workQueue, @Nullable String name) {
        this.myId = id;
        this.myState = StringUtil.nullize((String)state);
        this.myWorkQueue = StringUtil.nullize((String)workQueue);
        this.myName = StringUtil.nullize((String)name);
    }

    public int getId() {
        return this.myId;
    }

    @Nullable
    public String getState() {
        return this.myState;
    }

    @Nullable
    public String getWorkQueue() {
        return this.myWorkQueue;
    }

    public String getDisplayName() {
        if (this.myName != null) {
            return this.myName;
        }
        StringBuilder builder = new StringBuilder();
        builder.append("Thread-").append(this.myId);
        if (this.myWorkQueue != null) {
            builder.append("-<").append(this.myWorkQueue).append(">");
        }
        if (this.myState != null) {
            builder.append(":").append(this.myState);
        }
        return builder.toString();
    }

    public String toString() {
        return this.getDisplayName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LLThread gdbThread = (LLThread)o;
        if (this.myId != gdbThread.myId) {
            return false;
        }
        if (!Comparing.equal((String)this.myState, (String)gdbThread.myState)) {
            return false;
        }
        return Comparing.equal((String)this.myWorkQueue, (String)gdbThread.myWorkQueue);
    }

    public int hashCode() {
        int result = this.myId;
        result = 31 * result + (this.myState != null ? this.myState.hashCode() : 0);
        result = 31 * result + (this.myWorkQueue != null ? this.myWorkQueue.hashCode() : 0);
        return result;
    }
}

