/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.openapi.util.SystemInfo;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerPathManager;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBDriver;
import com.jetbrains.cidr.execution.debugger.backend.lldb.LLDBValueRendererFactory;
import com.jetbrains.cidr.execution.debugger.evaluation.ValueRendererFactory;
import java.io.File;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLDBDriverConfiguration
extends DebuggerDriverConfiguration {
    private static File myLLDBFrontedExecutable;

    @Override
    @NotNull
    public String getDriverName() {
        return "LLDB";
    }

    @Override
    public boolean isAttachSupported() {
        return SystemInfo.isMac;
    }

    @Override
    @NotNull
    public DebuggerDriver createDriver(@NotNull DebuggerDriver.Handler handler2) {
        return new LLDBDriver(handler2, this);
    }

    @NotNull
    protected File getLLDBFrameworkFile() {
        return this.getLLDBBinFile(SystemInfo.isWindows ? "liblldb.dll" : (SystemInfo.isLinux ? "lib/liblldb.so.3" : "LLDB.framework"));
    }

    @NotNull
    protected File getLLDBBinFile(@NotNull String relativePath) {
        return CidrDebuggerPathManager.getLLDBBinFile(relativePath);
    }

    @Override
    @NotNull
    public GeneralCommandLine createDriverCommandLine(@NotNull DebuggerDriver driver, @NotNull Installer installer) throws ExecutionException {
        File frontendExecutable;
        File lldbFrameworkFile = this.getLLDBFrameworkFile();
        if (!lldbFrameworkFile.exists()) {
            throw new ExecutionException(lldbFrameworkFile + " not found");
        }
        File file2 = myLLDBFrontedExecutable != null ? myLLDBFrontedExecutable : (frontendExecutable = this.getLLDBBinFile(SystemInfo.isWindows ? "LLDBFrontend.exe" : "LLDBFrontend"));
        if (!frontendExecutable.exists()) {
            throw new ExecutionException(frontendExecutable.getAbsolutePath() + " not found");
        }
        GeneralCommandLine result = new GeneralCommandLine();
        result.setExePath(frontendExecutable.getAbsolutePath());
        result.addParameter(String.valueOf(((LLDBDriver)driver).getPort()));
        LLDBDriverConfiguration.setupCommonParameters(result);
        Map env = result.getEnvironment();
        if (SystemInfo.isLinux) {
            env.put("LD_LIBRARY_PATH", lldbFrameworkFile.getParent());
            File lldbServer = new File(lldbFrameworkFile.getParent(), "lldb-server");
            if (lldbServer.exists()) {
                env.put("LLDB_DEBUGSERVER_PATH", lldbServer.getAbsolutePath());
            }
        } else if (SystemInfo.isWindows) {
            env.put("PATH", lldbFrameworkFile.getParent() + ";" + frontendExecutable.getParent());
        } else if (SystemInfo.isMac) {
            env.put("DYLD_FRAMEWORK_PATH", lldbFrameworkFile.getParent());
            File debugserver = new File(lldbFrameworkFile, "Resources/debugserver");
            if (debugserver.exists()) {
                env.put("LLDB_DEBUGSERVER_PATH", debugserver.getAbsolutePath());
                env.put("LLDB_DEBUGSERVER_EXTRA_ARG_1", "--reverse-connect");
            }
            env.put("NSUnbufferedIO", "YES");
            File pythonDir = CidrDebuggerPathManager.getSystemPythonBinDir();
            if (pythonDir != null) {
                env.put("PATH", pythonDir.getAbsolutePath());
            } else {
                CidrDebuggerLog.LOG.warn("Python bin dir not found");
            }
            result.putUserData(LLDBDriver.ENABLE_STL_RENDERERS, (Object)true);
            env.put("PYTHONPATH", CidrDebuggerPathManager.getBundledLLDBSTLPrettyPrinters().getAbsolutePath());
        }
        this.configureDriverCommandLine(result);
        return result;
    }

    protected void configureDriverCommandLine(@NotNull GeneralCommandLine result) {
    }

    public static void setLLDBFrontedExecutable(@Nullable File LLDBFrontedExecutable) {
        myLLDBFrontedExecutable = LLDBFrontedExecutable;
    }

    @Override
    @NotNull
    public ValueRendererFactory getValueRenderersFactory() {
        return new LLDBValueRendererFactory();
    }
}

