/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.jetbrains.cidr.execution.debugger.backend.LLCodepoint;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LLBreakpoint
extends LLCodepoint {
    @NotNull
    private final String myFile;
    private final int myLine;
    private final boolean myPending;
    @Nullable
    private String myCondition;
    @Nullable
    private String myConditionError;

    public LLBreakpoint(int id, @NotNull String file2, int line, boolean pending, @Nullable String condition, @Nullable String conditionError) {
        super(id);
        this.myFile = file2;
        this.myLine = line;
        this.myPending = pending;
        this.myCondition = condition;
        this.myConditionError = conditionError;
    }

    @NotNull
    public String getFile() {
        return this.myFile;
    }

    public int getLine() {
        return this.myLine;
    }

    @Nullable
    public String getCondition() {
        return this.myCondition;
    }

    @Nullable
    public String getConditionError() {
        return this.myConditionError;
    }

    public String toString() {
        String result = "Breakpoint-" + this.getId() + "@" + this.myFile + ":" + this.myLine;
        if (this.myPending) {
            result = result + "(pending)";
        }
        if (this.myCondition != null) {
            result = result + ":condition:" + this.myCondition;
        }
        if (this.myConditionError != null) {
            result = result + ":condition-error:" + this.myConditionError;
        }
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        LLBreakpoint that = (LLBreakpoint)o;
        if (this.myLine != that.myLine) {
            return false;
        }
        if (this.myPending != that.myPending) {
            return false;
        }
        if (this.myCondition != null ? !this.myCondition.equals(that.myCondition) : that.myCondition != null) {
            return false;
        }
        if (this.myConditionError != null ? !this.myConditionError.equals(that.myConditionError) : that.myConditionError != null) {
            return false;
        }
        return this.myFile.equals(that.myFile);
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.myFile.hashCode();
        result = 31 * result + this.myLine;
        result = 31 * result + (this.myPending ? 1 : 0);
        result = 31 * result + (this.myCondition != null ? this.myCondition.hashCode() : 0);
        result = 31 * result + (this.myConditionError != null ? this.myConditionError.hashCode() : 0);
        return result;
    }
}

