/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.backend;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.configurations.GeneralCommandLine;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.lang.Language;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.util.Consumer;
import com.intellij.util.concurrency.QueueProcessor;
import com.intellij.util.containers.ContainerUtil;
import com.jetbrains.cidr.execution.FileOutputReaders;
import com.jetbrains.cidr.execution.Installer;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLog;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectFramesException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotCollectVariablesException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotEvaluateException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotLoadVariableException;
import com.jetbrains.cidr.execution.debugger.backend.DBCannotSetBreakpointException;
import com.jetbrains.cidr.execution.debugger.backend.LLBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLSymbolicBreakpoint;
import com.jetbrains.cidr.execution.debugger.backend.LLThread;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import gnu.trove.TLongHashSet;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.math.BigInteger;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class DebuggerDriver {
    public static final Key<String> DEBUGSERVER_SOCKET = Key.create((String)"DEBUGSERVER_SOCKET");
    public static final int LOAD_TIMEOUT_MS = 120000;
    public static final int TIMEOUT_MS = 30000;
    public static final int EVALUATION_TIMEOUT_MS = 30000;
    public static final int MAX_CHILD_COUNT = Integer.MAX_VALUE;
    protected final Handler myHandler;
    private volatile TargetState myState = TargetState.NOT_READY;
    protected final List<Consumer<Pair<String, Key>>> myOutputListeners = ContainerUtil.createLockFreeCopyOnWriteList();
    protected final QueueProcessor<Runnable> myHandlerProcessor;
    @Nullable
    protected FileOutputReaders myReaders;
    protected volatile GeneralCommandLine myTargetCommandLine;
    protected volatile Installer myInstaller;
    protected volatile TLongHashSet myIndirectSymbols;
    protected boolean myToRedirect;

    public DebuggerDriver(@NotNull Handler handler2) {
        this.myHandler = handler2;
        this.myHandlerProcessor = QueueProcessor.createRunnableQueueProcessor();
    }

    public boolean supportsWatchpoints() {
        return true;
    }

    public abstract boolean supportsWatchpointLifetime();

    @NotNull
    public abstract Language getConsoleLanguage();

    @NotNull
    public abstract ProcessHandler getProcessHandler();

    public abstract boolean isInPromptMode();

    public TargetState getState() {
        return this.myState;
    }

    public abstract void start(@NotNull Installer var1, @Nullable String var2) throws ExecutionException;

    public abstract void setValuesFilteringEnabled(boolean var1) throws ExecutionException;

    public abstract void loadForLaunch() throws ExecutionException;

    public abstract void loadForAttach() throws ExecutionException;

    public abstract void loadForRemote(File var1) throws ExecutionException;

    public abstract void launch() throws ExecutionException;

    public abstract void attachTo(int var1) throws ExecutionException;

    public abstract void detach() throws ExecutionException;

    public abstract void attachByName(String var1, boolean var2) throws ExecutionException;

    public abstract boolean interrupt() throws ExecutionException;

    public abstract boolean resume() throws ExecutionException;

    public abstract void stepOver() throws ExecutionException;

    public abstract void stepInto() throws ExecutionException;

    public abstract void stepOut() throws ExecutionException;

    public abstract void runTo(String var1, int var2) throws ExecutionException;

    public abstract boolean abort() throws ExecutionException;

    @NotNull
    public abstract LLWatchpoint addWatchpoint(int var1, int var2, LLValue var3, String var4, LLWatchpoint.Lifetime var5, LLWatchpoint.AccessType var6) throws ExecutionException, DBCannotSetBreakpointException;

    public abstract void removeWatchpoint(List<Integer> var1) throws ExecutionException;

    @NotNull
    public List<LLBreakpoint> addBreakpoint(String path, int line) throws ExecutionException, DBCannotSetBreakpointException {
        return this.addBreakpoint(path, line, null);
    }

    @NotNull
    public abstract List<LLBreakpoint> addBreakpoint(String var1, int var2, @Nullable String var3) throws ExecutionException, DBCannotSetBreakpointException;

    @NotNull
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull String name) throws ExecutionException, DBCannotSetBreakpointException {
        return this.addSymbolicBreakpoint(name, null, null);
    }

    @NotNull
    public LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull String pattern, @Nullable String module2, @Nullable String condition) throws ExecutionException, DBCannotSetBreakpointException {
        SymbolicBreakpoint symBreakpoint = new SymbolicBreakpoint();
        symBreakpoint.setPattern(pattern);
        symBreakpoint.setModule(module2);
        symBreakpoint.setCondition(condition);
        return this.addSymbolicBreakpoint(symBreakpoint);
    }

    @NotNull
    public abstract LLSymbolicBreakpoint addSymbolicBreakpoint(@NotNull SymbolicBreakpoint var1) throws ExecutionException, DBCannotSetBreakpointException;

    public abstract void removeCodepoints(@NotNull Collection<Integer> var1) throws ExecutionException;

    @NotNull
    public List<LLFrame> getFrames(int threadId) throws ExecutionException, DBCannotCollectFramesException {
        return this.getFrames(threadId, false);
    }

    @NotNull
    public abstract List<LLFrame> getFrames(int var1, boolean var2) throws ExecutionException, DBCannotCollectFramesException;

    @NotNull
    public abstract List<LLValue> getVariables(int var1, int var2) throws ExecutionException;

    public int getChildrenCount(LLValue var) throws ExecutionException, DBCannotCollectVariablesException {
        return this.getChildrenCount(var, Integer.MAX_VALUE);
    }

    public abstract int getChildrenCount(LLValue var1, int var2) throws ExecutionException, DBCannotCollectVariablesException;

    @NotNull
    public abstract List<LLValue> getVariableChildren(LLValue var1) throws ExecutionException, DBCannotCollectVariablesException;

    @NotNull
    public abstract List<LLValue> getVariableChildrenRange(LLValue var1, int var2, int var3) throws ExecutionException, DBCannotCollectVariablesException;

    @NotNull
    public final LLValue evaluate(int threadId, int frameNumber, @NotNull String expression) throws ExecutionException, DBCannotEvaluateException {
        return this.evaluate(threadId, frameNumber, expression, null);
    }

    @NotNull
    public abstract LLValue evaluate(int var1, int var2, @NotNull String var3, @Nullable DebuggerLanguage var4) throws ExecutionException, DBCannotEvaluateException;

    @NotNull
    public abstract ShellCommandResult executeShellCommand(@NotNull String var1, @Nullable List<String> var2, @Nullable String var3, int var4) throws ExecutionException;

    public abstract void executeConsoleCommand(String var1) throws ExecutionException;

    public abstract void executeConsoleCommand(int var1, int var2, String var3) throws ExecutionException;

    public abstract void handleCompletion(String var1, int var2, List<String> var3) throws ExecutionException;

    public abstract void handleSignal(String var1, boolean var2, boolean var3, boolean var4) throws ExecutionException;

    public void addOutputListener(Consumer<Pair<String, Key>> listener2) {
        this.myOutputListeners.add(listener2);
    }

    protected void setState(TargetState state) {
        this.myState = state;
    }

    protected void handleRunning() {
        this.setState(TargetState.RUNNING);
        this.myHandlerProcessor.add((Object)new Runnable(){

            @Override
            public void run() {
                DebuggerDriver.this.myHandler.handleRunning();
            }
        });
    }

    protected void handleWatchpointScope(final int wpnum) {
        this.setState(TargetState.SUSPENDED);
        this.myHandlerProcessor.add((Object)new Runnable(){

            @Override
            public void run() {
                DebuggerDriver.this.myHandler.handleWatchpointScope(wpnum);
            }
        });
    }

    protected void handleBreakpoint(final int num, final List<LLThread> threads, final int currentThread) {
        this.setState(TargetState.SUSPENDED);
        this.myHandlerProcessor.add((Object)new Runnable(){

            @Override
            public void run() {
                DebuggerDriver.this.myHandler.handleBreakpoint(num, threads, currentThread);
            }
        });
    }

    protected void handleWatchpoint(final int num, final List<LLThread> threads, final int currentThread) {
        this.setState(TargetState.SUSPENDED);
        this.myHandlerProcessor.add((Object)new Runnable(){

            @Override
            public void run() {
                DebuggerDriver.this.myHandler.handleWatchpoint(num, threads, currentThread);
            }
        });
    }

    protected void handleInterrupted(final List<LLThread> threads, final int currentThread) {
        this.setState(TargetState.SUSPENDED);
        this.myHandlerProcessor.add((Object)new Runnable(){

            @Override
            public void run() {
                DebuggerDriver.this.myHandler.handleInterrupted(threads, currentThread);
            }
        });
    }

    protected void handleSignal(final List<LLThread> threads, final int currentThread, final String signal, final String meaning) {
        this.setState(TargetState.SUSPENDED);
        this.myHandlerProcessor.add((Object)new Runnable(){

            @Override
            public void run() {
                DebuggerDriver.this.myHandler.handleSignal(threads, currentThread, signal, meaning);
            }
        });
    }

    protected void handleException(final List<LLThread> threads, final int currentThread, final String description) {
        this.setState(TargetState.SUSPENDED);
        this.myHandlerProcessor.add((Object)new Runnable(){

            @Override
            public void run() {
                DebuggerDriver.this.myHandler.handleException(threads, currentThread, description);
            }
        });
    }

    protected void handleTargetOutput(final String text, final Key type) {
        this.myHandlerProcessor.add((Object)new Runnable(){

            @Override
            public void run() {
                DebuggerDriver.this.myHandler.handleTargetOutput(text, type);
                for (Consumer<Pair<String, Key>> each : DebuggerDriver.this.myOutputListeners) {
                    each.consume((Object)Pair.create((Object)text, (Object)type));
                }
            }
        });
    }

    protected void handleAttached(final int pid) {
        this.myHandlerProcessor.add((Object)new Runnable(){

            @Override
            public void run() {
                DebuggerDriver.this.myHandler.handleAttached(pid);
            }
        });
    }

    protected void handleGDBOutput(final String text) {
        this.myHandlerProcessor.add((Object)new Runnable(){

            @Override
            public void run() {
                DebuggerDriver.this.myHandler.handleGDBOutput(text);
            }
        });
    }

    protected void handlePrompt() {
        String promptText = this.getPromptText();
        this.handlePrompt("(" + promptText + ") ");
    }

    protected abstract String getPromptText();

    protected void handlePrompt(final @NotNull String prompt) {
        this.myHandlerProcessor.add((Object)new Runnable(){

            @Override
            public void run() {
                DebuggerDriver.this.myHandler.handlePrompt(prompt);
            }
        });
    }

    protected void handleTargetFinished(final int code, final String description) {
        this.setState(TargetState.FINISHED);
        this.myHandlerProcessor.add((Object)new Runnable(){

            @Override
            public void run() {
                DebuggerDriver.this.myHandler.handleTargetFinished(code, description);
            }
        });
    }

    protected void handleTargetTerminated() {
        this.setState(TargetState.FINISHED);
        this.myHandlerProcessor.add((Object)new Runnable(){

            @Override
            public void run() {
                DebuggerDriver.this.myHandler.handleTargetTerminated();
            }
        });
    }

    protected void handleDetached() {
        this.setState(TargetState.FINISHED);
        this.myHandlerProcessor.add((Object)new Runnable(){

            @Override
            public void run() {
                DebuggerDriver.this.myHandler.handleDetached();
            }
        });
    }

    protected void handleExited(final int code) {
        this.setState(TargetState.FINISHED);
        this.myHandlerProcessor.add((Object)new Runnable(){

            @Override
            public void run() {
                DebuggerDriver.this.myHandler.handleExited(code);
            }
        });
    }

    @Nullable
    public OutputStream getProcessInput() {
        return null;
    }

    protected void printTargetCommandLine(@Nullable GeneralCommandLine commandLine) {
        if (commandLine != null) {
            this.handleTargetOutput(commandLine.getCommandLineString() + "\n", ProcessOutputTypes.SYSTEM);
        }
    }

    public void setRedirectOutputToFiles(boolean toRedirect) {
        this.myToRedirect = toRedirect;
    }

    protected void initReaders(boolean usePty) throws ExecutionException {
        this.myReaders = new FileOutputReaders(){

            @Override
            protected void onTextAvailable(@NotNull String text, @NotNull Key type) {
                DebuggerDriver.this.handleTargetOutput(text, type);
            }
        };
        this.myReaders.init(this.myTargetCommandLine, usePty);
    }

    protected void closeOutputReaders() {
        if (this.myReaders != null) {
            this.myReaders.close();
        }
    }

    protected void readOutputFully() {
        if (this.myReaders != null) {
            this.myReaders.readFully();
        }
    }

    protected static boolean isTargetTerminationSignal(int signal) {
        return 15 == signal || 9 == signal;
    }

    protected static boolean isTargetTerminationSignal(@Nullable String name) {
        return "SIGTERM".equals(name) || "SIGKILL".equals(name);
    }

    protected String getDebugServerSocket() {
        return (String)this.myTargetCommandLine.getUserData(DEBUGSERVER_SOCKET);
    }

    public static String getShlibPathSubstitutions(String buildPath, String bundlePathOnDevice, File deviceSupport) {
        String[] substitutions = new String[]{"/usr", new File(deviceSupport, "Symbols/usr").getAbsolutePath(), "/System", new File(deviceSupport, "Symbols/System").getAbsolutePath(), bundlePathOnDevice, new File(buildPath).getAbsolutePath(), bundlePathOnDevice.substring("/private".length()), new File(buildPath).getAbsolutePath(), "/Developer", new File(deviceSupport, "Symbols/Developer").getAbsolutePath()};
        String result = "";
        for (String s : substitutions) {
            result = result + "\"" + s + "\" ";
        }
        return result;
    }

    public abstract void addSymbolsFile(File var1, File var2) throws ExecutionException;

    private static int escapedByte(String s, int idx, ByteArrayOutputStream bs) {
        if (idx + 4 > s.length() || s.charAt(idx) != '\\') {
            return -1;
        }
        try {
            int code = Integer.parseInt(s.substring(idx + 1, idx + 4), 8);
            bs.write(code);
            return idx + 4;
        }
        catch (NumberFormatException e) {
            return -1;
        }
    }

    @NotNull
    public static String unescapeString(@NotNull String s) {
        StringBuilder buffer = new StringBuilder(s.length());
        ByteArrayOutputStream bs = new ByteArrayOutputStream();
        boolean escaped = false;
        for (int idx = 0; idx < s.length(); ++idx) {
            char ch = s.charAt(idx);
            if (!escaped) {
                if (ch == '\\') {
                    escaped = true;
                    continue;
                }
                buffer.append(ch);
                continue;
            }
            switch (ch) {
                case 'n': {
                    buffer.append('\n');
                    break;
                }
                case 'r': {
                    buffer.append('\r');
                    break;
                }
                case 'b': {
                    buffer.append('\b');
                    break;
                }
                case 't': {
                    buffer.append('\t');
                    break;
                }
                case 'f': {
                    buffer.append('\f');
                    break;
                }
                case 'e': {
                    buffer.append('\u001b');
                    break;
                }
                case 'a': {
                    buffer.append('\u0007');
                    break;
                }
                case '\'': {
                    buffer.append('\'');
                    break;
                }
                case '\"': {
                    buffer.append('\"');
                    break;
                }
                case '\\': {
                    buffer.append('\\');
                    break;
                }
                default: {
                    int i = idx - 1;
                    bs.reset();
                    while ((i = DebuggerDriver.escapedByte(s, i, bs)) != -1) {
                        idx = i;
                    }
                    if (bs.size() > 0) {
                        try {
                            buffer.append(new String(bs.toByteArray(), "UTF-8"));
                        }
                        catch (UnsupportedEncodingException e) {
                            CidrDebuggerLog.LOG.error((Throwable)e);
                        }
                        --idx;
                        break;
                    }
                    buffer.append('\\');
                    buffer.append(ch);
                }
            }
            escaped = false;
        }
        if (escaped) {
            buffer.append('\\');
        }
        return buffer.toString();
    }

    public static long parseAddress(@NotNull String str) throws ExecutionException {
        if (str.length() < 2 || !"0x".equals(str.substring(0, 2))) {
            throw new ExecutionException("Invalid address string: \"" + str + "\"");
        }
        try {
            BigInteger address = new BigInteger(str.substring(2), 16);
            if (address.bitLength() > 64) {
                throw new ExecutionException("Address is too huge: " + str);
            }
            return address.longValue();
        }
        catch (NumberFormatException e) {
            throw new ExecutionException("Invalid address string: \"" + str + "\"");
        }
    }

    public static long parseAddressSafe(@NotNull String str) throws DBCannotEvaluateException {
        try {
            return DebuggerDriver.parseAddress(str);
        }
        catch (ExecutionException e) {
            throw new DBCannotEvaluateException(e);
        }
    }

    public abstract boolean isStructType(LLValue var1) throws ExecutionException, DBCannotLoadVariableException;

    public static class SymbolicBreakpoint {
        public static final int INVALID_THREAD_ID = 0;
        private String myPattern;
        private boolean myRegexpPattern = false;
        @Nullable
        private String myModule;
        @Nullable
        private String myCondition;
        private int myThreadId = 0;

        public String getPattern() {
            return this.myPattern;
        }

        public void setPattern(String pattern) {
            this.myPattern = pattern;
        }

        public boolean isRegexpPattern() {
            return this.myRegexpPattern;
        }

        public void setRegexpPattern(boolean regexpPattern) {
            this.myRegexpPattern = regexpPattern;
        }

        @Nullable
        public String getModule() {
            return this.myModule;
        }

        public void setModule(@Nullable String module2) {
            this.myModule = module2;
        }

        @Nullable
        public String getCondition() {
            return this.myCondition;
        }

        public void setCondition(@Nullable String condition) {
            this.myCondition = condition;
        }

        public int getThreadId() {
            return this.myThreadId;
        }

        public void setThreadId(int threadId) {
            this.myThreadId = threadId;
        }
    }

    public static enum StandardDebuggerLanguage implements DebuggerLanguage
    {
        C("C"),
        C_PLUS_PLUS("C++"),
        OBJC("Objective-C"),
        OBJC_PLUS_PLUS("Objective-C++"),
        SWIFT("Swift");

        private final String myName;

        private StandardDebuggerLanguage(String name) {
            this.myName = name;
        }

        @Override
        @NotNull
        public String toString() {
            return this.myName;
        }
    }

    public static interface DebuggerLanguage {
        public String toString();
    }

    public static interface Handler {
        public void handleRunning();

        public void handleInterrupted(@NotNull List<LLThread> var1, int var2);

        public void handleSignal(@NotNull List<LLThread> var1, int var2, @NotNull String var3, @NotNull String var4);

        public void handleBreakpoint(int var1, @NotNull List<LLThread> var2, int var3);

        public void handleTargetOutput(@NotNull String var1, @NotNull Key var2);

        public void handleGDBOutput(@NotNull String var1);

        public void handlePrompt(@NotNull String var1);

        public void handleTargetFinished(int var1, @Nullable String var2);

        public void handleTargetTerminated();

        public void handleExited(int var1);

        public void handleWatchpointScope(int var1);

        public void handleWatchpoint(int var1, List<LLThread> var2, int var3);

        public void handleAttached(int var1);

        public void handleDetached();

        public void handleException(List<LLThread> var1, int var2, String var3);

        public void handleModulesLoaded(@NotNull List<String> var1);
    }

    public static enum TargetState {
        NOT_READY,
        RUNNING,
        SUSPENDED,
        FINISHED;

    }

    public static class ShellCommandResult {
        private final String myOutput;
        private final int myStatus;
        private final int mySignal;

        public ShellCommandResult(@NotNull String output, int status, int signal) {
            this.myOutput = output;
            this.myStatus = status;
            this.mySignal = signal;
        }

        @NotNull
        public String getOutput() {
            return this.myOutput;
        }

        public int getStatus() {
            return this.myStatus;
        }

        public int getSignal() {
            return this.mySignal;
        }
    }
}

