/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.breakpoints.XBreakpoint;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.ui.tree.actions.XDebuggerTreeActionBase;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrWatchpointUtil;
import com.jetbrains.cidr.execution.debugger.backend.LLWatchpoint;
import com.jetbrains.cidr.execution.debugger.breakpoints.CidrWatchpointType;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrLocalValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import org.jetbrains.annotations.NotNull;

public class CidrAddWatchpointAction
extends XDebuggerTreeActionBase {
    @Override
    public void update(AnActionEvent e) {
        super.update(e);
        Project project2 = CidrAddWatchpointAction.getEventProject((AnActionEvent)e);
        XDebugSession currentSession = project2 == null ? null : XDebuggerManager.getInstance((Project)project2).getCurrentSession();
        XDebugProcess process = currentSession == null ? null : currentSession.getDebugProcess();
        e.getPresentation().setVisible(process instanceof CidrDebugProcess);
        e.getPresentation().setEnabled(process instanceof CidrDebugProcess && ((CidrDebugProcess)process).supportsWatchpoints());
    }

    @Override
    protected boolean isEnabled(@NotNull XValueNodeImpl node, @NotNull AnActionEvent e) {
        XValue value = (XValue)node.getValueContainer();
        return value instanceof CidrLocalValue || value instanceof CidrMemberValue;
    }

    @Override
    protected void perform(XValueNodeImpl node, @NotNull String nodeName, AnActionEvent e) {
        XValue valueContainer = (XValue)node.getValueContainer();
        XBreakpoint<CidrWatchpointType.CidrWatchpointProperties> breakpoint = CidrWatchpointUtil.addWatchpoint(valueContainer, LLWatchpoint.AccessType.WRITE, LLWatchpoint.Lifetime.STACK_FRAME);
        if (breakpoint != null) {
            CidrWatchpointUtil.showWatchpointEditor(node, breakpoint, CidrAddWatchpointAction.getEventProject((AnActionEvent)e));
        }
    }
}

