/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.PsiElementProcessor;
import com.intellij.psi.util.PsiElementFilter;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.xdebugger.XExpression;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.XDebuggerEvaluator;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.breakpoints.XExpressionImpl;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrStackFrame;
import com.jetbrains.cidr.execution.debugger.backend.DBUserException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrEvaluatedValue;
import com.jetbrains.cidr.lang.parser.OCPunctuatorElementType;
import com.jetbrains.cidr.lang.parser.OCTokenTypes;
import com.jetbrains.cidr.lang.psi.OCArraySelectionExpression;
import com.jetbrains.cidr.lang.psi.OCCallExpression;
import com.jetbrains.cidr.lang.psi.OCCastExpression;
import com.jetbrains.cidr.lang.psi.OCExpression;
import com.jetbrains.cidr.lang.psi.OCLiteralExpression;
import com.jetbrains.cidr.lang.psi.OCMacroCall;
import com.jetbrains.cidr.lang.psi.OCParenthesizedExpression;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCReferenceExpression;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCMacroSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCClassSymbol;
import com.jetbrains.cidr.lang.util.OCElementUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCEvaluator
extends CidrEvaluator {
    public OCEvaluator(@NotNull CidrStackFrame frame) {
        super(frame);
    }

    public boolean isCodeFragmentEvaluationSupported() {
        return this.myFrame.getProcess().getRendererFactory().isCodeFragmentEvaluationSupported();
    }

    public void evaluate(@NotNull String expression, @NotNull XDebuggerEvaluator.XEvaluationCallback callback, @Nullable XSourcePosition expressionPosition) {
        this.evaluate(XExpressionImpl.fromText(expression), callback, expressionPosition);
    }

    public void evaluate(final @NotNull XExpression expression, final @NotNull XDebuggerEvaluator.XEvaluationCallback callback, final @Nullable XSourcePosition expressionPosition) {
        this.myFrame.getProcess().postCommand(new CidrDebugProcess.DebuggerCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                XSourcePosition valuePosition = expressionPosition == null ? OCEvaluator.this.myFrame.getSourcePosition() : expressionPosition;
                try {
                    CidrEvaluatedValue evaluatedValue = OCEvaluator.this.doEvaluate(driver, valuePosition, expression);
                    callback.evaluated((XValue)evaluatedValue);
                }
                catch (DBUserException e) {
                    callback.errorOccurred(e.getMessage());
                }
                catch (ExecutionException e) {
                    callback.errorOccurred(e.getMessage());
                    throw e;
                }
            }

            @Override
            public void rejected(@NotNull String reason) {
                callback.errorOccurred(reason);
            }
        });
    }

    public TextRange getExpressionRangeAtOffset(final Project project2, final Document document, final int offset, final boolean sideEffectsAllowed) {
        return (TextRange)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<TextRange>(){

            public TextRange compute() {
                PsiFile file2 = PsiDocumentManager.getInstance((Project)project2).getPsiFile(document);
                if (file2 == null) {
                    return null;
                }
                PsiElement el = OCEvaluator.findSuitableExpression(file2, offset, sideEffectsAllowed);
                return el == null ? null : el.getTextRange();
            }
        });
    }

    @Nullable
    private static PsiElement findSuitableExpression(PsiFile file2, int offset, boolean sideEffectsAllowed) {
        OCSymbol s;
        PsiElement result = null;
        if (sideEffectsAllowed) {
            PsiElement macro;
            result = file2.findElementAt(offset);
            if (result == null || OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(OCElementUtil.getElementType(result))) {
                if (offset > 0) {
                    result = file2.findElementAt(offset - 1);
                }
                if (result == null || OCTokenTypes.WHITE_SPACE_OR_COMMENT_BIT_SET.contains(OCElementUtil.getElementType(result))) {
                    return null;
                }
            }
            if ((macro = OCEvaluator.getIfMacroCall(result)) != null) {
                result = macro;
            } else {
                PsiElement call = OCEvaluator.getIfFunctionCall(result = PsiTreeUtil.getParentOfType((PsiElement)result, OCExpression.class, (boolean)false));
                if (call != null) {
                    result = call;
                }
            }
        } else {
            PsiReference ref = file2.findReferenceAt(offset);
            if (ref instanceof OCReference) {
                OCSymbol symbol;
                result = PsiTreeUtil.getParentOfType((PsiElement)ref.getElement(), OCReferenceExpression.class, (boolean)false);
                if (result != null && ((symbol = ((OCReferenceExpression)result).resolveToSymbol()) == null || symbol instanceof OCMacroSymbol)) {
                    return null;
                }
                if (OCEvaluator.getIfFunctionCall(result) != null) {
                    return null;
                }
            }
        }
        if (result instanceof OCReferenceExpression && (s = ((OCReferenceExpression)result).resolveToSymbol()) instanceof OCClassSymbol) {
            return null;
        }
        PsiElement slice = OCEvaluator.getIfArraySlice(result, sideEffectsAllowed);
        if (slice != null) {
            result = slice;
        }
        return result;
    }

    @Nullable
    private static PsiElement getIfFunctionCall(@Nullable PsiElement el) {
        PsiElement parent;
        if (el instanceof OCReferenceExpression && (parent = el.getParent()) instanceof OCCallExpression) {
            return parent;
        }
        return null;
    }

    @Nullable
    private static PsiElement getIfMacroCall(@Nullable PsiElement el) {
        PsiElement parent;
        PsiElement psiElement = parent = el == null ? null : el.getParent();
        if (parent != null) {
            if (el.getNode().getElementType() instanceof OCPunctuatorElementType && parent instanceof OCMacroCall) {
                return parent;
            }
            PsiElement grandParent = parent.getParent();
            if (grandParent instanceof OCMacroCall) {
                return grandParent;
            }
        }
        return null;
    }

    @Nullable
    private static PsiElement getIfArraySlice(@Nullable PsiElement el, boolean sideEffectsAllowed) {
        if (el == null) {
            return null;
        }
        PsiElement parent = el.getParent();
        OCArraySelectionExpression slice = null;
        if (el instanceof OCArraySelectionExpression) {
            slice = (OCArraySelectionExpression)el;
        } else if (parent instanceof OCArraySelectionExpression) {
            slice = (OCArraySelectionExpression)parent;
        }
        if (slice == null) {
            return null;
        }
        if (!sideEffectsAllowed) {
            OCExpression index = slice.getIndexExpression();
            PsiElementProcessor.FindFilteredElement processor2 = new PsiElementProcessor.FindFilteredElement(new PsiElementFilter(){

                public boolean isAccepted(PsiElement each) {
                    return each instanceof OCExpression && !(each instanceof OCLiteralExpression) && !(each instanceof OCReferenceExpression) && !(each instanceof OCCastExpression) && !(each instanceof OCParenthesizedExpression);
                }
            });
            PsiTreeUtil.processElements((PsiElement)index, (PsiElementProcessor)processor2);
            if (processor2.isFound()) {
                return null;
            }
        }
        return slice;
    }
}

