/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.jetbrains.cidr.ContextFreeResolveUtil;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrDebuggerTypesHelper;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrMemberValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrPhysicalValue;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.psi.OCFile;
import com.jetbrains.cidr.lang.psi.OCForStatement;
import com.jetbrains.cidr.lang.psi.OCReference;
import com.jetbrains.cidr.lang.psi.OCTypeElement;
import com.jetbrains.cidr.lang.symbols.OCResolveContext;
import com.jetbrains.cidr.lang.symbols.OCSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCDeclaratorSymbol;
import com.jetbrains.cidr.lang.symbols.cpp.OCThisSelfSuperSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCInstanceVariableSymbol;
import com.jetbrains.cidr.lang.symbols.objc.OCMemberSymbol;
import com.jetbrains.cidr.lang.types.OCObjectType;
import com.jetbrains.cidr.lang.types.OCPointerType;
import com.jetbrains.cidr.lang.types.OCReferenceType;
import com.jetbrains.cidr.lang.types.OCStructType;
import com.jetbrains.cidr.lang.types.OCType;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDebuggerTypesHelper
extends CidrDebuggerTypesHelper {
    public OCDebuggerTypesHelper(CidrDebugProcess process) {
        super(process);
    }

    @Override
    public PsiElement resolveToDeclaration(XSourcePosition position, LLValue var) {
        PsiElement context = this.getContextElement(position);
        if (context == null) {
            return null;
        }
        OCReference ref = this.createReferenceFromText(var, context);
        if (ref == null) {
            return null;
        }
        PsiElement resolved = ref.resolve();
        if (resolved == null) {
            return null;
        }
        if (resolved.getContainingFile() == ((PsiElement)ref).getContainingFile()) {
            return null;
        }
        return resolved;
    }

    @Nullable
    protected OCReference createReferenceFromText(@NotNull LLValue var, @NotNull PsiElement context) {
        return context.getLanguage() == OCLanguage.getInstance() ? OCElementFactory.referenceElementFromText(var.getName(), context, false) : null;
    }

    @Override
    @Nullable
    public Boolean isImplicitContextVariable(@NotNull XSourcePosition position, @NotNull LLValue var) {
        PsiElement context = this.getContextElement(position);
        if (context == null) {
            return null;
        }
        return OCThisSelfSuperSymbol.tryResolveThisSelfSuper(var.getName(), context, new OCResolveContext(context)) != null;
    }

    @Nullable
    protected OCType resolveType(CidrPhysicalValue value, Class ... klass) {
        XSourcePosition pos = value.getSourcePosition();
        if (pos == null) {
            return null;
        }
        PsiFile psiFile = PsiManager.getInstance((Project)this.myProcess.getProject()).findFile(pos.getFile());
        OCType dynamicResult = null;
        String dynamicType = value.getVar().getDynamicType();
        if (dynamicType != null) {
            dynamicResult = this.doResolveType(pos, dynamicType, psiFile, klass);
        }
        if (dynamicResult != null && !dynamicResult.isUnknown()) {
            return dynamicResult;
        }
        String type = value.getVar().getType();
        return this.doResolveType(pos, type, psiFile, klass);
    }

    @Nullable
    public OCType resolveTypeInRA(final CidrPhysicalValue value, final Class ... klasses) {
        return (OCType)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<OCType>(){

            public OCType compute() {
                if (OCDebuggerTypesHelper.this.myProcess.getProject().isDisposed()) {
                    return null;
                }
                return OCDebuggerTypesHelper.this.resolveType(value, klasses);
            }
        });
    }

    @Nullable
    private OCType doResolveType(@NotNull XSourcePosition pos, @NotNull String typeName, PsiFile psiFile, Class ... klass) {
        PsiElement element = this.getContextElement(pos);
        return OCDebuggerTypesHelper.doResolveType(typeName, psiFile, element, klass);
    }

    @Nullable
    private static OCType doResolveType(@NotNull String typeName, PsiFile psiFile, PsiElement context, Class ... klass) {
        if (context == null) {
            return null;
        }
        OCTypeElement exp = OCElementFactory.typeElementFromTextOrNull(typeName, context, false);
        if (exp == null) {
            return null;
        }
        OCType expType = exp.getType();
        OCType resolved = expType.resolve(psiFile);
        if (resolved instanceof OCReferenceType) {
            OCReferenceType referenceType = (OCReferenceType)resolved;
            List<OCSymbol> symbols = referenceType.getReference(psiFile).resolveToSymbols(psiFile);
            for (OCSymbol symbol : symbols) {
                OCSymbol definitionSymbol = symbol.getDefinitionSymbol();
                if (definitionSymbol == null || !OCDebuggerTypesHelper.isInstanceOf(definitionSymbol.getResolvedType(), klass)) continue;
                return definitionSymbol.getResolvedType();
            }
            for (OCSymbol symbol : symbols) {
                OCType type = symbol.getResolvedType();
                if (type == null || !OCDebuggerTypesHelper.isInstanceOf(type, klass)) continue;
                return type;
            }
        } else if (OCDebuggerTypesHelper.isInstanceOf(resolved, klass)) {
            return resolved;
        }
        return null;
    }

    private static boolean isInstanceOf(OCType type, Class[] klass) {
        for (Class each : klass) {
            if (!each.isInstance(type)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isCPPThisPsi(CidrPhysicalValue value) {
        if (!value.getVar().getName().equals("this")) {
            return false;
        }
        Project project2 = this.myProcess.getProject();
        XSourcePosition position = value.getSourcePosition();
        if (position == null) {
            return true;
        }
        AccessToken token = ApplicationManager.getApplication().acquireReadActionLock();
        boolean result = false;
        try {
            PsiFile file2 = PsiManager.getInstance((Project)project2).findFile(position.getFile());
            if (file2 instanceof OCFile) {
                result = ((OCFile)file2).isCpp();
            }
        }
        finally {
            token.finish();
        }
        return result;
    }

    @Override
    public boolean isCStringType(CidrPhysicalValue value) {
        OCType pointerType = this.resolveTypeInRA(value, OCPointerType.class);
        return pointerType != null && pointerType.isCString();
    }

    @Override
    public XSourcePosition computeSourcePosition(CidrMemberValue value) {
        OCDeclaratorSymbol field;
        OCType type = this.resolveType(value.getParent(), OCPointerType.class, OCStructType.class, OCReferenceType.class, OCObjectType.class);
        if (type == null) {
            return null;
        }
        OCType terminalType = type.getTerminalType();
        if (terminalType instanceof OCObjectType) {
            OCInstanceVariableSymbol var = ((OCObjectType)terminalType).findMember(value.getVar().getName(), OCInstanceVariableSymbol.class);
            if (var != null) {
                return XDebuggerUtil.getInstance().createPositionByOffset(var.getContainingFile(), var.getOffset());
            }
        } else if (terminalType instanceof OCStructType && (field = ((OCStructType)terminalType).findField(value.getVar().getName())) != null) {
            return XDebuggerUtil.getInstance().createPositionByOffset(field.getContainingFile(), field.getOffset());
        }
        return null;
    }

    @Override
    @Nullable
    public PsiElement getContextElement(@Nullable XSourcePosition sourcePosition) {
        return OCDebuggerTypesHelper.getContextElement(sourcePosition, this.myProcess.getProject());
    }

    @Override
    @Nullable
    public XSourcePosition resolveProperty(@NotNull CidrMemberValue value, @Nullable String dynamicTypeName) {
        OCMemberSymbol symbol = ContextFreeResolveUtil.resolveToProperty(dynamicTypeName, value.getName(), this.myProcess.getProject());
        if (symbol == null) {
            return null;
        }
        return XDebuggerUtil.getInstance().createPositionByOffset(symbol.getContainingFile(), symbol.getOffset());
    }

    public static PsiElement getContextElement(XSourcePosition sourcePosition, Project project2) {
        PsiElement result = OCDebuggerTypesHelper.getDefaultContextElement(sourcePosition, project2);
        if (result != null && result.getParent() instanceof OCForStatement) {
            result = ((OCForStatement)result.getParent()).getInitializer();
        }
        return result;
    }
}

