/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.application.Result;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.testFramework.LightVirtualFile;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.evaluation.EvaluationMode;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.jetbrains.cidr.execution.debugger.OCDebuggerTypesHelper;
import com.jetbrains.cidr.lang.OCFileType;
import com.jetbrains.cidr.lang.OCLanguage;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.util.OCElementFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCDebuggerEditorsProvider
extends XDebuggerEditorsProvider {
    @NotNull
    public FileType getFileType() {
        return OCFileType.INSTANCE;
    }

    @NotNull
    public Document createDocument(final @NotNull Project project2, final @NotNull String text, @Nullable XSourcePosition sourcePosition, final @NotNull EvaluationMode mode) {
        final PsiElement context = OCDebuggerTypesHelper.getContextElement(sourcePosition, project2);
        if (context != null && context.getLanguage() == OCLanguage.getInstance()) {
            return (Document)new WriteAction<Document>(){

                protected void run(@NotNull Result<Document> result) throws Throwable {
                    OCCodeFragment fragment = mode == EvaluationMode.EXPRESSION ? OCElementFactory.expressionCodeFragment(text, project2, context, true, false) : OCElementFactory.expressionOrStatementsCodeFragment(text, project2, context, true, false);
                    result.setResult((Object)PsiDocumentManager.getInstance((Project)project2).getDocument((PsiFile)fragment));
                }
            }.execute().getResultObject();
        }
        LightVirtualFile plainTextFile = new LightVirtualFile("oc-debug-editor-when-no-source-position-available.txt", (CharSequence)text);
        return FileDocumentManager.getInstance().getDocument((VirtualFile)plainTextFile);
    }
}

