/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.openapi.editor.Document;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.util.messages.MessageBusConnection;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionAdapter;
import com.intellij.xdebugger.XDebugSessionListener;
import com.jetbrains.cidr.execution.debugger.BackendConsoleInjectionHelper;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.lang.GDBExpressionPlaceholder;
import com.jetbrains.cidr.lang.editor.OCInjectionListener;
import com.jetbrains.cidr.lang.psi.OCCodeFragment;
import com.jetbrains.cidr.lang.psi.OCFile;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class OCBackendConsoleInjectionHelper
implements BackendConsoleInjectionHelper {
    @Override
    public void subscribeToInjection(@NotNull XDebugSession session) {
        final MessageBusConnection connection = session.getProject().getMessageBus().connect();
        class Listener
        extends XDebugSessionAdapter
        implements OCInjectionListener {
            private volatile Pair<Document, OCCodeFragment> myDocumentAndFragment;

            Listener() {
            }

            @Override
            public void didInject(@NotNull OCFile injected, PsiLanguageInjectionHost host) {
                Document document;
                if (host instanceof GDBExpressionPlaceholder && (document = host.getContainingFile().getOriginalFile().getViewProvider().getDocument()) != null) {
                    this.myDocumentAndFragment = Pair.create((Object)document, (Object)((OCCodeFragment)injected));
                    OCBackendConsoleInjectionHelper.updateContextInGDBConsole((Pair<Document, OCCodeFragment>)this.myDocumentAndFragment);
                }
            }

            public void stackFrameChanged() {
                OCBackendConsoleInjectionHelper.updateContextInGDBConsole((Pair<Document, OCCodeFragment>)this.myDocumentAndFragment);
            }

            public void sessionStopped() {
                connection.disconnect();
            }
        }
        Listener listener2 = new Listener();
        connection.subscribe(OCInjectionListener.INJECTION_TOPIC, (Object)listener2);
        session.addSessionListener((XDebugSessionListener)listener2);
    }

    private static void updateContextInGDBConsole(@Nullable Pair<Document, OCCodeFragment> documentAndFragment) {
        if (documentAndFragment == null) {
            return;
        }
        CidrDebugProcess process = (CidrDebugProcess)((Document)documentAndFragment.first).getUserData(CidrDebugProcess.DEBUG_PROCESS_KEY);
        if (process != null) {
            ((OCCodeFragment)documentAndFragment.second).setContext(process.getDebuggerContext());
        }
    }
}

