/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NullableComputable;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.UserDataHolderEx;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.ui.ColoredTextContainer;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebuggerUtil;
import com.intellij.xdebugger.XSourcePosition;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XStackFrame;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.jetbrains.cidr.execution.debugger.CidrDebugProcess;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerLanguageSupportFactory;
import com.jetbrains.cidr.execution.debugger.CidrDebuggerSettings;
import com.jetbrains.cidr.execution.debugger.CidrEvaluator;
import com.jetbrains.cidr.execution.debugger.CidrSuspensionCause;
import com.jetbrains.cidr.execution.debugger.ThrowInTest;
import com.jetbrains.cidr.execution.debugger.backend.DBUserException;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriver;
import com.jetbrains.cidr.execution.debugger.backend.LLFrame;
import com.jetbrains.cidr.execution.debugger.backend.LLValue;
import com.jetbrains.cidr.execution.debugger.evaluation.CidrValue;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CidrStackFrame
extends XStackFrame
implements UserDataHolderEx {
    @NotNull
    private final UserDataHolderBase myUserDataHolder = new UserDataHolderBase();
    @NotNull
    private final CidrDebugProcess myProcess;
    private final int myThreadId;
    @NotNull
    private final LLFrame myFrame;
    @NotNull
    private final LLFrame mySourcePositionFrame;
    @Nullable
    private final CidrSuspensionCause mySuspensionCause;
    public static final Key THROW_ON_VARIABLES_COLLECTION = Key.create((String)"THROW_ON_VARIABLES_COLLECTION");

    public CidrStackFrame(@NotNull CidrDebugProcess process, int threadId, @NotNull LLFrame frame, @Nullable CidrStackFrame nextFrame, @Nullable CidrSuspensionCause suspensionCause) {
        this.myProcess = process;
        this.myThreadId = threadId;
        this.myFrame = frame;
        this.mySuspensionCause = suspensionCause;
        LLFrame suspendFrame = this.myFrame;
        if (CidrStackFrame.getSourcePosition(suspendFrame) == null && nextFrame != null) {
            suspendFrame = nextFrame.mySourcePositionFrame;
        }
        this.mySourcePositionFrame = suspendFrame;
    }

    @Nullable
    public <T> T getUserData(@NotNull Key<T> key) {
        return (T)this.myUserDataHolder.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, @Nullable T value) {
        this.myUserDataHolder.putUserData(key, value);
    }

    @NotNull
    public <T> T putUserDataIfAbsent(@NotNull Key<T> key, @NotNull T value) {
        return (T)this.myUserDataHolder.putUserDataIfAbsent(key, value);
    }

    public <T> boolean replace(@NotNull Key<T> key, @Nullable T oldValue, @Nullable T newValue) {
        return this.myUserDataHolder.replace(key, oldValue, newValue);
    }

    @NotNull
    public CidrDebugProcess getProcess() {
        return this.myProcess;
    }

    public int getThreadId() {
        return this.myThreadId;
    }

    @NotNull
    public LLFrame getFrame() {
        return this.myFrame;
    }

    @NotNull
    public LLFrame getSourcePositionFrame() {
        return this.mySourcePositionFrame;
    }

    public int getFrameNumber() {
        return this.mySourcePositionFrame.getNumber();
    }

    public Object getEqualityObject() {
        return Pair.create((Object)this.myThreadId, (Object)this.mySourcePositionFrame.getNumber());
    }

    @Nullable
    public XSourcePosition getSourcePosition() {
        return CidrStackFrame.getSourcePosition(this.mySourcePositionFrame);
    }

    @Nullable
    private static XSourcePosition getSourcePosition(final LLFrame frame) {
        final String file2 = frame.getFile();
        if (file2 == null) {
            return null;
        }
        return (XSourcePosition)ApplicationManager.getApplication().runReadAction((Computable)new Computable<XSourcePosition>(){

            public XSourcePosition compute() {
                VirtualFile vFile = LocalFileSystem.getInstance().findFileByPath(file2);
                return vFile == null ? null : XDebuggerUtil.getInstance().createPosition(vFile, frame.getLine());
            }
        });
    }

    @Nullable
    public PsiElement getContext() {
        return (PsiElement)ApplicationManager.getApplication().runReadAction((Computable)new NullableComputable<PsiElement>(){

            public PsiElement compute() {
                return CidrStackFrame.this.myProcess.getTypesHelper().getContextElement(CidrStackFrame.this.getSourcePosition());
            }
        });
    }

    public void customizePresentation(@NotNull ColoredTextContainer component) {
        XSourcePosition pos = CidrStackFrame.getSourcePosition(this.myFrame);
        if (pos != null) {
            component.append(this.myFrame.getFunction(), SimpleTextAttributes.REGULAR_ATTRIBUTES);
            component.append(" " + pos.getFile().getName() + ":" + (this.myFrame.getLine() + 1), SimpleTextAttributes.GRAY_ITALIC_ATTRIBUTES);
        } else {
            component.append(this.myFrame.getFunction(), SimpleTextAttributes.GRAY_ATTRIBUTES);
        }
    }

    public final void computeChildren(final @NotNull XCompositeNode node) {
        this.myProcess.postCommand(new CidrDebugProcess.DebuggerImplicitCommand(){

            @Override
            public void run(@NotNull DebuggerDriver driver) throws ExecutionException {
                try {
                    CidrStackFrame.this.doComputeChildren(driver, node);
                }
                catch (DBUserException e) {
                    node.setErrorMessage(e.getMessage());
                }
                catch (ExecutionException e) {
                    node.setErrorMessage(e.getMessage());
                    throw e;
                }
            }
        });
    }

    private void doComputeChildren(@NotNull DebuggerDriver driver, @NotNull XCompositeNode node) throws DBUserException, ExecutionException {
        if (node.isObsolete()) {
            return;
        }
        if (this.mySuspensionCause != null) {
            XValueChildrenList list = new XValueChildrenList(1);
            list.add(new XNamedValue(this.mySuspensionCause.type){

                public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
                    node.setPresentation(((CidrStackFrame)CidrStackFrame.this).mySuspensionCause.icon, null, ((CidrStackFrame)CidrStackFrame.this).mySuspensionCause.reason, false);
                }
            });
            node.addChildren(list, false);
        }
        ThrowInTest.doThrow((UserDataHolder)this, THROW_ON_VARIABLES_COLLECTION);
        final XSourcePosition framePosition = this.getSourcePosition();
        driver.setValuesFilteringEnabled(CidrDebuggerSettings.getInstance().VALUES_FILTER_ENABLED);
        List vars = driver.getVariables(this.myThreadId, this.mySourcePositionFrame.getNumber());
        vars = ContainerUtil.filter(vars, (Condition)new Condition<LLValue>(){

            public boolean value(final LLValue value) {
                if (framePosition == null) {
                    value.setValid(false);
                    return true;
                }
                final boolean[] resolved = new boolean[1];
                final boolean[] special = new boolean[]{false};
                Integer variableLine = (Integer)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Integer>(){

                    public Integer compute() {
                        PsiElement declarator = CidrStackFrame.this.myProcess.getTypesHelper().resolveToDeclaration(framePosition, value);
                        boolean bl = resolved[0] = declarator != null;
                        if (declarator == null) {
                            Boolean thisSelfSupper = CidrStackFrame.this.myProcess.getTypesHelper().isImplicitContextVariable(framePosition, value);
                            special[0] = thisSelfSupper != null ? thisSelfSupper : false;
                            return null;
                        }
                        PsiFile targetFile = declarator.getContainingFile();
                        if (!Comparing.equal((Object)targetFile.getVirtualFile(), (Object)framePosition.getFile())) {
                            return null;
                        }
                        int endOffset = declarator.getTextRange().getEndOffset();
                        Document document = PsiDocumentManager.getInstance((Project)targetFile.getProject()).getDocument(targetFile);
                        if (document == null) {
                            return null;
                        }
                        return document.getLineNumber(endOffset);
                    }
                });
                value.setValid(special[0] || resolved[0] && variableLine != null && variableLine < framePosition.getLine());
                return !CidrDebuggerSettings.getInstance().VALUES_FILTER_ENABLED || resolved[0] || special[0];
            }
        });
        CidrValue.addLocalValues(vars, this.myProcess, framePosition, this, node);
    }

    public CidrEvaluator getEvaluator() {
        for (CidrDebuggerLanguageSupportFactory factory : (CidrDebuggerLanguageSupportFactory[])CidrDebuggerLanguageSupportFactory.EP_NAME.getExtensions()) {
            CidrEvaluator evaluator = factory.createEvaluator(this);
            if (evaluator == null) continue;
            return evaluator;
        }
        return null;
    }

    public String toString() {
        return this.myFrame + " (" + this.mySourcePositionFrame.toString() + ")";
    }
}

