/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.cidr.execution.debugger;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.filters.TextConsoleBuilder;
import com.intellij.execution.filters.TextConsoleBuilderFactory;
import com.intellij.execution.process.ProcessInfo;
import com.intellij.openapi.project.Project;
import com.intellij.xdebugger.XDebugProcess;
import com.intellij.xdebugger.XDebugProcessStarter;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebugSessionListener;
import com.intellij.xdebugger.XDebuggerManager;
import com.intellij.xdebugger.attach.XLocalAttachDebugger;
import com.jetbrains.cidr.execution.debugger.CidrLocalAttachedDebugProcess;
import com.jetbrains.cidr.execution.debugger.backend.DebuggerDriverConfiguration;
import org.jetbrains.annotations.NotNull;

public class CidrLocalAttachDebugger
implements XLocalAttachDebugger {
    @NotNull
    private final DebuggerDriverConfiguration myConfiguration;

    public CidrLocalAttachDebugger(@NotNull DebuggerDriverConfiguration configuration) {
        this.myConfiguration = configuration;
    }

    @Override
    @NotNull
    public String getDebuggerDisplayName() {
        return this.myConfiguration.getDriverName();
    }

    @NotNull
    public DebuggerDriverConfiguration getConfiguration() {
        return this.myConfiguration;
    }

    @Override
    @NotNull
    public XDebugSession attachDebugSession(@NotNull Project project2, @NotNull ProcessInfo processInfo) throws ExecutionException {
        return this.doAttachDebugSession(project2, processInfo, new XDebugSessionListener[0]);
    }

    @NotNull
    public XDebugSession doAttachDebugSession(final @NotNull Project project2, final @NotNull ProcessInfo processInfo, final XDebugSessionListener ... listeners) throws ExecutionException {
        return XDebuggerManager.getInstance((Project)project2).startSessionAndShowTab(processInfo.getExecutableDisplayName(), null, new XDebugProcessStarter(){

            @NotNull
            public XDebugProcess start(@NotNull XDebugSession session) throws ExecutionException {
                for (XDebugSessionListener l : listeners) {
                    session.addSessionListener(l);
                }
                TextConsoleBuilder consoleBuilder = TextConsoleBuilderFactory.getInstance().createBuilder(project2);
                CidrLocalAttachedDebugProcess process = new CidrLocalAttachedDebugProcess(CidrLocalAttachDebugger.this.myConfiguration, processInfo, session, consoleBuilder);
                process.start();
                return process;
            }
        });
    }
}

